/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.perforce.PerforceSCM;
import hudson.plugins.perforce.PerforceTagAction;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerforceTagNotifier
extends Notifier {
    protected static final Logger LOGGER = Logger.getLogger(PerforceTagNotifier.class.getName());
    public String rawLabelName;
    public boolean onlyOnSuccess = true;

    public boolean isOnlyOnSuccess() {
        return this.onlyOnSuccess;
    }

    public void setOnlyOnSuccess(boolean onlyOnSuccess) {
        this.onlyOnSuccess = onlyOnSuccess;
    }

    public String getRawLabelName() {
        return this.rawLabelName;
    }

    public void setRawLabelName(String rawLabelName) {
        this.rawLabelName = rawLabelName;
    }

    @DataBoundConstructor
    public PerforceTagNotifier(String rawLabelName, boolean onlyOnSuccess) {
        this.rawLabelName = rawLabelName;
        this.onlyOnSuccess = onlyOnSuccess;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        if (!this.onlyOnSuccess || build.getResult() == Result.SUCCESS) {
            EnvVars environment;
            try {
                environment = build.getEnvironment((TaskListener)listener);
            }
            catch (IOException e) {
                listener.getLogger().println("Could not load build environment.");
                return false;
            }
            PerforceTagAction tagAction = (PerforceTagAction)build.getAction(PerforceTagAction.class);
            if (tagAction == null) {
                listener.getLogger().println("Could not find tag information, checking if this is a promotion job.");
                String jobName = (String)environment.get((Object)"PROMOTED_JOB_NAME");
                String buildNumber = (String)environment.get((Object)"PROMOTED_NUMBER");
                if (jobName == null || jobName.isEmpty() || buildNumber == null || buildNumber.isEmpty()) {
                    listener.getLogger().println("Not a promotion job.");
                } else {
                    AbstractProject project = (AbstractProject)Hudson.getInstance().getItemByFullName(jobName, AbstractProject.class);
                    int buildNum = Integer.parseInt(buildNumber);
                    build = (AbstractBuild)project.getBuildByNumber(buildNum);
                    tagAction = (PerforceTagAction)build.getAction(PerforceTagAction.class);
                }
                if (tagAction == null) {
                    listener.getLogger().println("Could not label build in perforce; is it a valid perforce job?");
                    return false;
                }
            }
            listener.getLogger().println("Labelling Build in Perforce using " + this.rawLabelName);
            String labelName = PerforceSCM.substituteParameters(this.rawLabelName, build);
            if (labelName == null || labelName.equals("")) {
                listener.getLogger().println("Label Name is empty, cannot label.");
                return false;
            }
            try {
                tagAction.tagBuild(labelName, "Label automatically generated by Hudson Perforce Plugin.");
            }
            catch (IOException e) {
                listener.getLogger().println(e.getMessage());
                return false;
            }
            listener.getLogger().println("Label '" + labelName + "' successfully generated.");
        }
        return true;
    }

    public static DescriptorImpl descriptor() {
        return (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Create or Update Label in Perforce";
        }
    }
}

