/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce;

import com.tek42.perforce.PerforceException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.perforce.HudsonP4Executor;
import hudson.remoting.Callable;
import hudson.remoting.FastPipedInputStream;
import hudson.remoting.FastPipedOutputStream;
import hudson.remoting.Future;
import hudson.remoting.RemoteInputStream;
import hudson.remoting.RemoteOutputStream;
import hudson.remoting.VirtualChannel;
import hudson.util.StreamTaskListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HudsonP4RemoteExecutor
implements HudsonP4Executor {
    private BufferedReader reader;
    private BufferedWriter writer;
    private InputStream input;
    private OutputStream output;
    private Launcher hudsonLauncher;
    private String[] env;
    private FilePath filePath;

    HudsonP4RemoteExecutor(Launcher hudsonLauncher, Map<String, String> envMap, FilePath filePath) {
        this.hudsonLauncher = hudsonLauncher;
        this.env = this.convertEnvMaptoArray(envMap);
        this.filePath = filePath;
    }

    @Override
    public void close() {
        try {
            this.output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void exec(String[] cmd) throws PerforceException {
        try {
            if (null == this.hudsonLauncher) {
                this.hudsonLauncher = Hudson.getInstance().createLauncher((TaskListener)new StreamTaskListener(System.out));
            }
            VirtualChannel channel = this.hudsonLauncher.getChannel();
            FastPipedOutputStream hudsonOut = new FastPipedOutputStream();
            FastPipedInputStream p4in = new FastPipedInputStream(hudsonOut);
            this.input = p4in;
            FastPipedInputStream hudsonIn = new FastPipedInputStream();
            FastPipedOutputStream p4out = new FastPipedOutputStream(hudsonIn);
            this.output = p4out;
            RemoteOutputStream out = hudsonOut == null ? null : new RemoteOutputStream((OutputStream)hudsonOut);
            RemoteInputStream in = hudsonIn == null ? null : new RemoteInputStream((InputStream)hudsonIn);
            String remotePath = this.filePath.getRemote();
            TaskListener listener = this.hudsonLauncher.getListener();
            RemoteCall remoteCall = new RemoteCall(Arrays.asList(cmd), this.env, (InputStream)in, (OutputStream)out, null, remotePath, listener);
            Future future = channel.callAsync((Callable)remoteCall);
            Proc.RemoteProc proc = new Proc.RemoteProc((java.util.concurrent.Future)future);
        }
        catch (IOException e) {
            this.closeBuffers();
            throw new PerforceException("Could not run perforce command.", e);
        }
    }

    @Override
    public BufferedWriter getWriter() {
        if (this.writer == null) {
            this.writer = new BufferedWriter(new OutputStreamWriter(this.output));
        }
        return this.writer;
    }

    @Override
    public BufferedReader getReader() {
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader(this.input));
        }
        return this.reader;
    }

    private String[] convertEnvMaptoArray(Map<String, String> envMap) {
        Set<String> keySet = envMap.keySet();
        String[] keys = keySet.toArray(new String[0]);
        String[] result = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            result[i] = keys[i] + "=" + envMap.get(keys[i]);
        }
        return result;
    }

    @Override
    public InputStream getInputStream() {
        return this.input;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.output;
    }

    private void closeBuffers() {
        try {
            this.input.close();
        }
        catch (IOException ignoredException) {
            // empty catch block
        }
        try {
            this.output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RemoteCall
    implements Callable<Integer, IOException> {
        private final List<String> cmd;
        private final String[] env;
        private final InputStream in;
        private final OutputStream out;
        private final OutputStream err;
        private final String workDir;
        private final TaskListener listener;

        RemoteCall(List<String> cmd, String[] env, InputStream in, OutputStream out, OutputStream err, String workDir, TaskListener listener) {
            this.cmd = new ArrayList<String>(cmd);
            this.env = env;
            this.in = in;
            this.out = out;
            this.err = err;
            this.workDir = workDir;
            this.listener = listener;
        }

        public Integer call() throws IOException {
            Launcher.ProcStarter ps = new Launcher.LocalLauncher(this.listener).launch();
            ps.cmds(this.cmd).envs(this.env).stdin(this.in).stdout(this.out);
            if (this.err != null) {
                ps.stderr(this.err);
            }
            if (this.workDir != null) {
                ps.pwd(this.workDir);
            }
            Proc p = ps.start();
            try {
                Integer ret = p.join();
                if (this.out != null) {
                    this.out.close();
                }
                if (this.err != null) {
                    this.err.close();
                }
                return ret;
            }
            catch (InterruptedException e) {
                if (this.out != null) {
                    this.out.close();
                }
                if (this.err != null) {
                    this.err.close();
                }
                return -1;
            }
        }
    }
}

