/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce;

import com.tek42.perforce.PerforceException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PerforceSCMHelper {
    private static final Logger LOGGER = Logger.getLogger(PerforceSCMHelper.class.getName());
    private static final String DEPOT_ROOT = "//";
    private static final String EXCLUSION_VIEW_PREFIX = "-";

    private PerforceSCMHelper() {
    }

    static String computePathFromViews(Collection<String> views) {
        StringBuilder path = new StringBuilder("");
        for (String view : views) {
            StringTokenizer columns = new StringTokenizer(view, " ");
            String leftColumn = columns.nextToken().trim();
            if (leftColumn.indexOf("-//") != -1) continue;
            leftColumn = leftColumn.substring(leftColumn.indexOf(DEPOT_ROOT));
            path.append(leftColumn + " ");
        }
        return path.toString();
    }

    static boolean projectPathIsValidForMultiviews(String projectPath) {
        return projectPath.equals("//...") || projectPath.indexOf(64) > -1;
    }

    public static int readInt(InputStream stream) throws IOException {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result += (stream.read() & 0xFF) << 8 * i;
        }
        return result;
    }

    private static Map<String, String> readPythonDictionary(InputStream stream) throws IOException {
        boolean counter = false;
        HashMap<String, String> map = new HashMap<String, String>();
        if (stream.read() == 123) {
            int b = stream.read();
            while (b != -1 && b != 48) {
                String value;
                if (b != 115) {
                    throw new IOException("Expected 's', but got '" + Integer.toString(b) + "'.");
                }
                String key = PerforceSCMHelper.readPythonString(stream);
                b = stream.read();
                if (b == 115) {
                    value = PerforceSCMHelper.readPythonString(stream);
                    b = stream.read();
                } else if (b == 105) {
                    value = Integer.toString(PerforceSCMHelper.readInt(stream));
                    b = stream.read();
                } else {
                    throw new IOException("Expected 's' or 'i', but got '" + Integer.toString(b) + "'.");
                }
                map.put(key, value);
            }
        } else {
            return null;
        }
        return map;
    }

    private static String readPythonString(InputStream stream) throws IOException {
        int length = PerforceSCMHelper.readInt(stream);
        byte[] buf = new byte[length];
        stream.read(buf, 0, length);
        String result = new String(buf);
        return result;
    }

    public static List<WhereMapping> parseWhereMapping(byte[] whereOutput) throws PerforceException {
        ByteArrayInputStream stream = new ByteArrayInputStream(whereOutput);
        ArrayList<WhereMapping> maps = new ArrayList<WhereMapping>();
        try {
            Map<String, String> map;
            while ((map = PerforceSCMHelper.readPythonDictionary(stream)) != null) {
                if (map.get("code").equals("error")) {
                    LOGGER.log(Level.FINE, "P4 Where Parsing Error: " + map.get("data"));
                    if (map.get("data") != null && !map.get("data").contains("not in client view")) {
                        throw new PerforceException("P4 Where Parsing Error: " + map.get("data"));
                    }
                }
                if (map.get("depotFile") == null || map.get("clientFile") == null || map.get("path") == null) {
                    LOGGER.log(Level.WARNING, "P4 Where returned unexpected output! Check to make sure your perforce client and server versions are up to date!");
                    continue;
                }
                String depot = map.get("depotFile");
                String workspace = map.get("clientFile");
                String filesystem = map.get("path");
                maps.add(new WhereMapping(depot, workspace, filesystem));
            }
        }
        catch (IOException e) {
            throw new PerforceException("Could not parse Where map.", e);
        }
        return maps;
    }

    public static String mapToWorkspace(List<WhereMapping> maps, String depotPath) {
        String result = null;
        for (WhereMapping map : maps) {
            if (!PerforceSCMHelper.doesPathMatchView(depotPath, map.getDepotPath())) continue;
            if (map.getDepotPath().startsWith(EXCLUSION_VIEW_PREFIX)) {
                result = null;
                continue;
            }
            result = PerforceSCMHelper.doMapping(map.getDepotPath(), map.getWorkspacePath(), depotPath);
        }
        return result;
    }

    public static boolean doesPathMatchView(String path, String view) {
        Pattern pattern = PerforceSCMHelper.getTokenPattern(view = PerforceSCMHelper.trimPlusMinus(view));
        Matcher matcher = pattern.matcher(path);
        return matcher.matches();
    }

    public static String trimPlusMinus(String str) {
        return str.replaceAll("^[-+]", "").trim();
    }

    public static Pattern getTokenPattern(String str) {
        String regex = str.replaceAll("\\[(.*?)\\]", Matcher.quoteReplacement("\\[") + "$1" + Matcher.quoteReplacement("\\]"));
        regex = regex.replaceAll("\\-", Matcher.quoteReplacement("\\-"));
        regex = regex.replaceAll("\\*", "([^/]*)");
        regex = regex.replaceAll("([^\\.])\\.([^\\.])", "$1\\\\.$2");
        regex = regex.replaceAll("\\.\\.\\.", "(.*)");
        regex = regex.replaceAll("%%[0-9]", "([^/]*)");
        regex = regex.replaceAll("\\$", Matcher.quoteReplacement("\\$"));
        Pattern pattern = Pattern.compile(regex);
        return pattern;
    }

    public static String doMapping(String lhs, String rhs, String orig) {
        lhs = PerforceSCMHelper.trimPlusMinus(lhs);
        rhs = PerforceSCMHelper.trimPlusMinus(rhs);
        Pattern pattern = PerforceSCMHelper.getTokenPattern(lhs);
        Matcher oldTokens = pattern.matcher(lhs);
        oldTokens.matches();
        Matcher values = pattern.matcher(orig);
        values.matches();
        if (oldTokens.groupCount() != values.groupCount()) {
            return null;
        }
        HashMap<Integer, String> numberedTokenMap = new HashMap<Integer, String>();
        ArrayList<String> tripleDotTokens = new ArrayList<String>();
        ArrayList<String> asteriskTokens = new ArrayList<String>();
        for (int i = 1; i <= oldTokens.groupCount(); ++i) {
            if (oldTokens.group(i).equals("...")) {
                tripleDotTokens.add(values.group(i));
                continue;
            }
            if (oldTokens.group(i).equals("*")) {
                asteriskTokens.add(values.group(i));
                continue;
            }
            if (!oldTokens.group(i).startsWith("%%")) continue;
            numberedTokenMap.put(Integer.valueOf(oldTokens.group(i).substring(2)), values.group(i));
        }
        Iterator tripleDotIterator = tripleDotTokens.iterator();
        Iterator asteriskIterator = asteriskTokens.iterator();
        HashMap newGroupMap = new HashMap();
        String mappedPath = rhs;
        while (true) {
            Matcher match;
            if ((match = Pattern.compile("\\.\\.\\.").matcher(mappedPath)).find()) {
                mappedPath = match.replaceFirst(Matcher.quoteReplacement((String)tripleDotIterator.next()));
                continue;
            }
            match = Pattern.compile("\\*").matcher(mappedPath);
            if (match.find()) {
                mappedPath = match.replaceFirst(Matcher.quoteReplacement((String)asteriskIterator.next()));
                continue;
            }
            match = Pattern.compile("%%([0-9])").matcher(mappedPath);
            if (!match.find()) break;
            mappedPath = match.replaceFirst(Matcher.quoteReplacement((String)numberedTokenMap.get(Integer.valueOf(match.group(1)))));
        }
        return mappedPath;
    }

    public static class WhereMapping {
        private String depot;
        private String workspace;
        private String filesystem;

        public WhereMapping(String depot, String workspace, String filesystem) {
            this.depot = depot;
            this.workspace = workspace;
            this.filesystem = filesystem;
        }

        public String getDepotPath() {
            return this.depot;
        }

        public String getFilesystemPath() {
            return this.filesystem;
        }

        public String getWorkspacePath() {
            return this.workspace;
        }
    }
}

