/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce.utils;

import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.perforce.PerforceSCM;
import hudson.plugins.perforce.utils.ParameterSubstitutionException;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.NodeProperty;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroStringHelper {
    public static final Level SUBSTITUTION_ERROR_LEVEL = Level.WARNING;

    public static String substituteParameters(String string, Map<String, String> subst) throws ParameterSubstitutionException {
        String result = MacroStringHelper.substituteParametersNoCheck(string, subst);
        MacroStringHelper.checkString(result);
        return result;
    }

    public static String substituteParameters(String string, AbstractBuild build, Map<String, String> env) throws ParameterSubstitutionException {
        String result = MacroStringHelper.substituteParametersNoCheck(string, build, env);
        MacroStringHelper.checkString(result);
        return result;
    }

    public static void checkString(String string) throws ParameterSubstitutionException {
        if (string == null) {
            return;
        }
        if (string.matches(".*\\$\\{.*\\}.*")) {
            throw new ParameterSubstitutionException(string, "Found unresolved macro at '" + string + "'");
        }
    }

    public static String substituteParametersNoCheck(String string, Map<String, String> subst) {
        if (string == null) {
            return null;
        }
        String newString = string;
        for (Map.Entry<String, String> entry : subst.entrySet()) {
            newString = newString.replace("${" + entry.getKey() + "}", entry.getValue());
        }
        return newString;
    }

    public static boolean containsMacro(String str) {
        return str != null && str.contains("${");
    }

    public static String substituteParametersNoCheck(String inputString, AbstractBuild build, Map<String, String> env) {
        if (!MacroStringHelper.containsMacro(inputString)) {
            return inputString;
        }
        String string = inputString;
        if (env != null && !env.isEmpty()) {
            string = MacroStringHelper.substituteParametersNoCheck(string, env);
            if (!MacroStringHelper.containsMacro(inputString)) {
                return string;
            }
        }
        for (NodeProperty nodeProperty : Hudson.getInstance().getGlobalNodeProperties()) {
            if (!(nodeProperty instanceof EnvironmentVariablesNodeProperty)) continue;
            string = ((EnvironmentVariablesNodeProperty)nodeProperty).getEnvVars().expand(string);
        }
        for (NodeProperty nodeProperty : build.getBuiltOn().getNodeProperties()) {
            if (!(nodeProperty instanceof EnvironmentVariablesNodeProperty)) continue;
            string = ((EnvironmentVariablesNodeProperty)nodeProperty).getEnvVars().expand(string);
        }
        if (!MacroStringHelper.containsMacro(string)) {
            return string;
        }
        TreeMap<String, String> subst = new TreeMap<String, String>();
        boolean useEnvironment = true;
        for (StackTraceElement ste : new Throwable().getStackTrace()) {
            if (!ste.getMethodName().equals("buildEnvVars") || !ste.getClassName().equals(PerforceSCM.class.getName())) continue;
            useEnvironment = false;
        }
        if (useEnvironment) {
            try {
                EnvVars vars = build.getEnvironment(TaskListener.NULL);
                subst.putAll((Map<String, String>)vars);
            }
            catch (IOException ex) {
                Logger.getLogger(PerforceSCM.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(PerforceSCM.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (!MacroStringHelper.containsMacro(string)) {
            return string;
        }
        subst.put("JOB_NAME", MacroStringHelper.getSafeJobName(build));
        String hudsonName = Hudson.getInstance().getDisplayName().toLowerCase();
        subst.put("BUILD_TAG", hudsonName + "-" + build.getProject().getName() + "-" + String.valueOf(build.getNumber()));
        subst.put("BUILD_ID", build.getId());
        subst.put("BUILD_NUMBER", String.valueOf(build.getNumber()));
        String result = MacroStringHelper.substituteParametersNoCheck(string, subst);
        result = MacroStringHelper.substituteParametersNoCheck(result, build.getBuildVariables());
        return result;
    }

    public static String getSafeJobName(AbstractBuild build) {
        return MacroStringHelper.getSafeJobName(build.getProject());
    }

    public static String getSafeJobName(AbstractProject project) {
        return project.getFullName().replace('/', '-').replace('=', '-').replace(',', '-');
    }
}

