/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce;

import com.tek42.perforce.model.Changelist;
import hudson.model.AbstractBuild;
import hudson.plugins.perforce.PerforceChangeLogEntry;
import hudson.plugins.perforce.PerforceChangeLogSet;
import hudson.scm.ChangeLogParser;
import hudson.scm.ChangeLogSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerforceChangeLogParser
extends ChangeLogParser {
    public ChangeLogSet<? extends ChangeLogSet.Entry> parse(AbstractBuild build, File file) throws IOException, SAXException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            ChangeLogHandler handler = new ChangeLogHandler(build);
            parser.parse(file, (DefaultHandler)handler);
            return handler.getChangeLogSet();
        }
        catch (Exception e) {
            throw new SAXException("Could not parse perforce changelog: ", e);
        }
    }

    public static String javaDateToStringDate(Date newDate) {
        if (newDate == null) {
            return "";
        }
        GregorianCalendar cal = (GregorianCalendar)Calendar.getInstance();
        cal.clear();
        cal.setTime(newDate);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        String date = year + "-" + PerforceChangeLogParser.putZero(month) + "-" + PerforceChangeLogParser.putZero(day);
        if (hour + min + sec > 0) {
            date = date + " " + PerforceChangeLogParser.putZero(hour) + ":" + PerforceChangeLogParser.putZero(min) + ":" + PerforceChangeLogParser.putZero(sec);
        }
        return date;
    }

    public static Date stringDateToJavaDate(String newDate) {
        if (newDate == null || newDate.equals("")) {
            return null;
        }
        String[] parts = newDate.split(" ");
        String[] date = parts[0].split("-");
        String[] time = null;
        if (parts.length > 1) {
            time = parts[1].split(":");
            time[2] = time[2].replaceAll("\\.0", "");
        } else {
            time = "00:00:00".split(":");
        }
        GregorianCalendar cal = (GregorianCalendar)Calendar.getInstance();
        cal.clear();
        cal.set(new Integer(date[0]), new Integer(date[1]) - 1, new Integer(date[2]), new Integer(time[0]), new Integer(time[1]), new Integer(time[2]));
        return cal.getTime();
    }

    public static String putZero(int i) {
        if (i < 10) {
            return "0" + i;
        }
        return i + "";
    }

    public static class ChangeLogHandler
    extends DefaultHandler {
        private Stack objects = new Stack();
        private StringBuffer text = new StringBuffer();
        private List<PerforceChangeLogEntry> changeLogEntries = null;
        private PerforceChangeLogSet changeLogSet = null;
        private AbstractBuild build = null;

        public ChangeLogHandler(AbstractBuild build) {
            this.build = build;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.text.append(ch, start, length);
        }

        public void endDocument() throws SAXException {
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            Changelist changelist;
            if (qName.equalsIgnoreCase("changelog")) {
                return;
            }
            if (this.objects.peek() instanceof Changelist) {
                changelist = (Changelist)this.objects.peek();
                if (qName.equalsIgnoreCase("changenumber")) {
                    changelist.setChangeNumber(new Integer(this.text.toString()));
                    return;
                }
                if (qName.equalsIgnoreCase("date")) {
                    changelist.setDate(PerforceChangeLogParser.stringDateToJavaDate(this.text.toString()));
                    return;
                }
                if (qName.equalsIgnoreCase("description")) {
                    changelist.setDescription(this.text.toString());
                    return;
                }
                if (qName.equalsIgnoreCase("user")) {
                    changelist.setUser(this.text.toString());
                    return;
                }
                if (qName.equalsIgnoreCase("workspace")) {
                    changelist.setWorkspace(this.text.toString());
                    return;
                }
            }
            if (this.objects.peek() instanceof Changelist.JobEntry) {
                Changelist.JobEntry job = (Changelist.JobEntry)this.objects.peek();
                if (qName.equalsIgnoreCase("name")) {
                    job.setJob(this.text.toString());
                    return;
                }
                if (qName.equalsIgnoreCase("description")) {
                    job.setDescription(this.text.toString());
                    return;
                }
                if (qName.equalsIgnoreCase("status")) {
                    job.setStatus(this.text.toString());
                    return;
                }
                if (qName.equalsIgnoreCase("job")) {
                    this.objects.pop();
                    List joblist = (List)this.objects.peek();
                    joblist.add(job);
                    return;
                }
            }
            if (this.objects.peek() instanceof Changelist.FileEntry) {
                Changelist.FileEntry file = (Changelist.FileEntry)this.objects.peek();
                if (qName.equalsIgnoreCase("name")) {
                    file.setFilename(this.text.toString());
                    return;
                }
                if (qName.equalsIgnoreCase("workspacePath")) {
                    file.setWorkspacePath(this.text.toString());
                    return;
                }
                if (qName.equalsIgnoreCase("action")) {
                    file.setAction(Changelist.FileEntry.Action.valueOf(this.text.toString()));
                    return;
                }
                if (qName.equalsIgnoreCase("rev")) {
                    file.setRevision(this.text.toString());
                    return;
                }
                if (qName.equalsIgnoreCase("changenumber")) {
                    file.setChangenumber(this.text.toString());
                    return;
                }
                if (qName.equalsIgnoreCase("file")) {
                    this.objects.pop();
                    List filelist = (List)this.objects.peek();
                    filelist.add(file);
                    return;
                }
            }
            if (qName.equalsIgnoreCase("files")) {
                ArrayList files = (ArrayList)this.objects.pop();
                Changelist changelist2 = (Changelist)this.objects.peek();
                changelist2.setFiles(files);
                return;
            }
            if (qName.equalsIgnoreCase("jobs")) {
                ArrayList jobs = (ArrayList)this.objects.pop();
                Changelist changelist3 = (Changelist)this.objects.peek();
                changelist3.setJobs(jobs);
                return;
            }
            if (qName.equalsIgnoreCase("entry")) {
                changelist = (Changelist)this.objects.pop();
                PerforceChangeLogEntry entry = new PerforceChangeLogEntry(this.changeLogSet);
                entry.setChange(changelist);
                this.changeLogEntries.add(entry);
                return;
            }
        }

        public void startDocument() throws SAXException {
            this.changeLogEntries = new ArrayList<PerforceChangeLogEntry>();
            this.changeLogSet = new PerforceChangeLogSet(this.build, this.changeLogEntries);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.text.setLength(0);
            if (qName.equalsIgnoreCase("changelog")) {
                return;
            }
            if (qName.equalsIgnoreCase("entry")) {
                this.objects.push(new Changelist());
                return;
            }
            if (this.objects.peek() instanceof Changelist) {
                if (qName.equalsIgnoreCase("files")) {
                    this.objects.push(new ArrayList());
                    return;
                }
                if (qName.equalsIgnoreCase("jobs")) {
                    this.objects.push(new ArrayList());
                    return;
                }
            }
            if (qName.equalsIgnoreCase("job")) {
                this.objects.push(new Changelist.JobEntry());
                return;
            }
            if (qName.equalsIgnoreCase("file")) {
                this.objects.push(new Changelist.FileEntry());
                return;
            }
        }

        public PerforceChangeLogSet getChangeLogSet() {
            return this.changeLogSet;
        }
    }
}

