/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce;

import com.tek42.perforce.model.Changelist;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.plugins.perforce.PerforceChangeLogEntry;
import hudson.plugins.perforce.PerforceChangeLogParser;
import hudson.scm.ChangeLogSet;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.kohsuke.stapler.framework.io.WriterOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerforceChangeLogSet
extends ChangeLogSet<PerforceChangeLogEntry> {
    private List<PerforceChangeLogEntry> history = null;

    public PerforceChangeLogSet(AbstractBuild<?, ?> build, List<PerforceChangeLogEntry> logs) {
        super(build);
        this.history = Collections.unmodifiableList(logs);
    }

    public List<PerforceChangeLogEntry> getHistory() {
        return this.history;
    }

    public boolean isEmptySet() {
        return this.history.isEmpty();
    }

    public Collection<PerforceChangeLogEntry> getLogs() {
        return this.history;
    }

    public Iterator<PerforceChangeLogEntry> iterator() {
        return this.history.iterator();
    }

    public static void saveToChangeLog(OutputStream outputStream, List<Changelist> changes) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, Charset.forName("UTF-8"));
        WriterOutputStream stream1 = new WriterOutputStream((Writer)writer);
        PrintStream stream = new PrintStream((OutputStream)stream1);
        stream.println("<?xml version='1.0' encoding='UTF-8'?>");
        stream.println("<changelog>");
        for (Changelist change : changes) {
            stream.println("\t<entry>");
            stream.println("\t\t<changenumber>" + change.getChangeNumber() + "</changenumber>");
            stream.println("\t\t<date>" + Util.xmlEscape((String)PerforceChangeLogParser.javaDateToStringDate(change.getDate())) + "</date>");
            stream.println("\t\t<description>" + Util.xmlEscape((String)change.getDescription()) + "</description>");
            stream.println("\t\t<user>" + Util.xmlEscape((String)change.getUser()) + "</user>");
            stream.println("\t\t<workspace>" + Util.xmlEscape((String)change.getWorkspace()) + "</workspace>");
            stream.println("\t\t<files>");
            for (Changelist.FileEntry fileEntry : change.getFiles()) {
                stream.println("\t\t\t<file>");
                stream.println("\t\t\t\t<name>" + Util.xmlEscape((String)fileEntry.getFilename()) + "</name>");
                stream.println("\t\t\t\t<workspacePath>" + Util.xmlEscape((String)fileEntry.getWorkspacePath()) + "</workspacePath>");
                stream.println("\t\t\t\t<rev>" + Util.xmlEscape((String)fileEntry.getRevision()) + "</rev>");
                stream.println("\t\t\t\t<changenumber>" + Util.xmlEscape((String)fileEntry.getChangenumber()) + "</changenumber>");
                stream.println("\t\t\t\t<action>" + (Object)((Object)fileEntry.getAction()) + "</action>");
                stream.println("\t\t\t</file>");
            }
            stream.println("\t\t</files>");
            stream.println("\t\t<jobs>");
            for (Changelist.JobEntry jobEntry : change.getJobs()) {
                stream.println("\t\t\t<job>");
                stream.println("\t\t\t\t<name>" + Util.xmlEscape((String)jobEntry.getJob()) + "</name>");
                stream.println("\t\t\t\t<description>" + Util.xmlEscape((String)jobEntry.getDescription()) + "</description>");
                stream.println("\t\t\t\t<status>" + Util.xmlEscape((String)jobEntry.getStatus()) + "</status>");
                stream.println("\t\t\t</job>");
            }
            stream.println("\t\t</jobs>");
            stream.println("\t</entry>");
        }
        stream.println("</changelog>");
        stream.close();
    }
}

