/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce;

import hudson.model.TaskListener;
import hudson.plugins.perforce.QuickCleaner;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ClosedInputStream;

class QuickRestoreCall
implements QuickCleaner.RemoteCall {
    private String[] env;
    private OutputStream out;
    private String workDir;
    private TaskListener listener;
    private String p4exe;
    private FileFilter filter;
    private String p4ticket;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer call() throws IOException {
        try {
            this.forceSyncUsingP4DiffOption("-se");
            this.forceSyncUsingP4DiffOption("-sd");
        }
        finally {
            IOUtils.closeQuietly((OutputStream)this.out);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceSyncUsingP4DiffOption(String option) throws IOException {
        PipedInputStream forceSyncInput = new PipedInputStream();
        PipedOutputStream diffOutput = new PipedOutputStream();
        forceSyncInput.connect(diffOutput);
        ArrayList<String> forceSyncCmdList = new ArrayList<String>();
        ArrayList<String> findDiffFilesCmdList = new ArrayList<String>();
        forceSyncCmdList.add(this.p4exe);
        if (this.p4ticket != null && !this.p4ticket.trim().isEmpty()) {
            forceSyncCmdList.add("-P");
            forceSyncCmdList.add(this.p4ticket);
        }
        forceSyncCmdList.add("-d");
        forceSyncCmdList.add(this.workDir);
        forceSyncCmdList.add("-x-");
        forceSyncCmdList.add("sync");
        forceSyncCmdList.add("-f");
        QuickCleaner.PerforceCall forceSync = new QuickCleaner.PerforceCall(this.env, forceSyncCmdList.toArray(new String[forceSyncCmdList.size()]), forceSyncInput, this.out, this.workDir, this.listener, false);
        findDiffFilesCmdList.add(this.p4exe);
        if (this.p4ticket != null && !this.p4ticket.trim().isEmpty()) {
            findDiffFilesCmdList.add("-P");
            findDiffFilesCmdList.add(this.p4ticket);
        }
        findDiffFilesCmdList.add("-d");
        findDiffFilesCmdList.add(this.workDir);
        findDiffFilesCmdList.add("diff");
        findDiffFilesCmdList.add(option);
        QuickCleaner.PerforceCall findDiffFiles = new QuickCleaner.PerforceCall(this.env, findDiffFilesCmdList.toArray(new String[findDiffFilesCmdList.size()]), (InputStream)new ClosedInputStream(), diffOutput, this.workDir, this.listener, true);
        try {
            forceSync.start();
            findDiffFiles.start();
            findDiffFiles.join();
            forceSync.join();
        }
        catch (InterruptedException e) {
            forceSync.interrupt();
            findDiffFiles.interrupt();
        }
        finally {
            IOUtils.closeQuietly((InputStream)forceSyncInput);
            IOUtils.closeQuietly((OutputStream)diffOutput);
        }
    }

    public void setEnv(String[] env) {
        this.env = env;
    }

    public void setFilter(FileFilter filter) {
        this.filter = filter;
    }

    public void setListener(TaskListener listener) {
        this.listener = listener;
    }

    public void setOut(OutputStream out) {
        this.out = out;
    }

    public void setP4exe(String p4exe) {
        this.p4exe = p4exe;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    public void setP4Ticket(String p4ticket) {
        this.p4ticket = p4ticket;
    }
}

