/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce;

import com.tek42.perforce.Depot;
import com.tek42.perforce.PerforceException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.perforce.QuickCleanerCall;
import hudson.plugins.perforce.QuickRestoreCall;
import hudson.remoting.Callable;
import hudson.remoting.FastPipedInputStream;
import hudson.remoting.FastPipedOutputStream;
import hudson.remoting.RemoteOutputStream;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class QuickCleaner {
    private Launcher hudsonLauncher;
    private String[] env;
    private FilePath filePath;
    private String p4exe;
    private FileFilter filter;
    private String p4ticket;

    QuickCleaner(String p4exe, String p4ticket, Launcher hudsonLauncher, Depot depot, FilePath filePath, FileFilter filter) {
        this.hudsonLauncher = hudsonLauncher;
        this.env = QuickCleaner.getEnvFromDepot(depot, filePath.getRemote());
        this.filePath = filePath;
        this.p4exe = p4exe;
        this.filter = filter;
        this.p4ticket = p4ticket;
    }

    public void doClean() throws PerforceException {
        this.call(new QuickCleanerCall());
    }

    public void doRestore() throws PerforceException {
        this.call(new QuickRestoreCall());
    }

    public void exec() throws PerforceException {
        this.call(new QuickCleanerCall());
    }

    public void call(RemoteCall remoteCall) throws PerforceException {
        try {
            if (null == this.hudsonLauncher) {
                this.hudsonLauncher = Hudson.getInstance().createLauncher((TaskListener)new StreamTaskListener(System.out));
            }
            TaskListener listener = this.hudsonLauncher.getListener();
            FastPipedOutputStream hudsonOut = new FastPipedOutputStream();
            FastPipedInputStream p4in = new FastPipedInputStream(hudsonOut);
            RemoteOutputStream out = hudsonOut == null ? null : new RemoteOutputStream((OutputStream)hudsonOut);
            remoteCall.setEnv(this.env);
            remoteCall.setP4exe(this.p4exe);
            remoteCall.setOut((OutputStream)out);
            remoteCall.setWorkDir(this.filePath.getRemote());
            remoteCall.setListener(listener);
            remoteCall.setFilter(this.filter);
            remoteCall.setP4Ticket(this.p4ticket);
            LogPrinter logPrinter = new LogPrinter(listener.getLogger(), (InputStream)p4in);
            logPrinter.start();
            this.filePath.act((Callable)remoteCall);
            logPrinter.join();
        }
        catch (Exception e) {
            throw new PerforceException("Could not run quick clean.", e);
        }
    }

    private static String[] getEnvFromDepot(Depot depot, String workDir) {
        String[] keys = new String[]{"P4USER", "P4PASSWD", "P4PORT", "P4COMMANDCHARSET", "P4CHARSET", "P4CLIENT", "PATH", "SystemDrive", "SystemRoot"};
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < keys.length; ++i) {
            String value = depot.getProperty(keys[i]);
            if (value == null || value.trim().isEmpty()) continue;
            result.add(keys[i] + "=" + value);
        }
        try {
            result.add("PWD=" + new File(workDir).getCanonicalPath());
            result.add("CD=" + new File(workDir).getCanonicalPath());
        }
        catch (IOException ex) {
            Logger.getLogger(QuickCleaner.class.getName()).log(Level.SEVERE, null, ex);
        }
        result.add("P4CONFIG=");
        return result.toArray(new String[result.size()]);
    }

    public static class PerforceCall
    extends Thread {
        private String[] env;
        private InputStream input;
        private OutputStream output;
        private String workDir;
        private TaskListener listener;
        private String[] cmdList;
        private boolean closePipes;

        PerforceCall(String[] env, String[] cmdList, InputStream input, OutputStream output, String workDir, TaskListener listener, boolean closeOutputPipe) {
            this.input = input;
            this.output = output;
            this.env = env;
            this.workDir = workDir;
            this.listener = listener;
            this.cmdList = cmdList;
            this.closePipes = closeOutputPipe;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Launcher.ProcStarter ps = new Launcher.LocalLauncher(this.listener).launch();
            ps.envs(this.env).stdin(this.input).stdout(this.output).cmds(this.cmdList);
            if (this.workDir != null) {
                ps.pwd(this.workDir);
            }
            try {
                Proc p = ps.start();
                Integer ret = p.join();
            }
            catch (InterruptedException e) {
                if (this.output != null && this.closePipes) {
                    IOUtils.closeQuietly((OutputStream)this.output);
                }
            }
            catch (IOException e) {
                if (this.output != null && this.closePipes) {
                    IOUtils.closeQuietly((OutputStream)this.output);
                }
            }
            finally {
                if (this.closePipes) {
                    IOUtils.closeQuietly((OutputStream)this.output);
                }
                IOUtils.closeQuietly((InputStream)this.input);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RemoteCall
    extends Callable<Integer, IOException> {
        public Integer call() throws IOException;

        public void setEnv(String[] var1);

        public void setFilter(FileFilter var1);

        public void setListener(TaskListener var1);

        public void setOut(OutputStream var1);

        public void setP4exe(String var1);

        public void setWorkDir(String var1);

        public void setP4Ticket(String var1);
    }

    private class LogPrinter
    extends Thread {
        private PrintStream log;
        private InputStream input;

        LogPrinter(PrintStream log, InputStream input) {
            this.log = log;
            this.input = input;
        }

        public void run() {
            try {
                IOUtils.copy((InputStream)this.input, (OutputStream)this.log);
            }
            catch (IOException ex) {
                Logger.getLogger(QuickCleaner.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

