/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce;

import hudson.Util;
import hudson.model.TaskListener;
import hudson.plugins.perforce.QuickCleaner;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class QuickCleanerCall
implements QuickCleaner.RemoteCall {
    private String[] env;
    private OutputStream out;
    private String workDir;
    private TaskListener listener;
    private String p4exe;
    private FileFilter filter;

    QuickCleanerCall() {
    }

    public void setEnv(String[] env) {
        this.env = env;
    }

    public void setFilter(FileFilter filter) {
        this.filter = filter;
    }

    public void setListener(TaskListener listener) {
        this.listener = listener;
    }

    public void setOut(OutputStream out) {
        this.out = out;
    }

    public void setP4exe(String p4exe) {
        this.p4exe = p4exe;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    public Integer call() throws IOException {
        PipedOutputStream dsOutput = new PipedOutputStream();
        PipedInputStream p4Input = new PipedInputStream();
        PipedOutputStream p4Output = new PipedOutputStream();
        PipedInputStream cleanerInput = new PipedInputStream();
        DirectoryScanner directoryScanner = new DirectoryScanner(this.workDir, dsOutput, this.filter);
        ProcessByPerforce p4Processor = new ProcessByPerforce(this.env, this.p4exe, p4Input, p4Output, this.workDir, this.listener);
        Cleaner cleaner = new Cleaner(this.workDir, cleanerInput, this.out);
        dsOutput.connect(p4Input);
        p4Output.connect(cleanerInput);
        cleaner.start();
        p4Processor.start();
        directoryScanner.start();
        try {
            directoryScanner.join();
            p4Processor.join();
            cleaner.join();
        }
        catch (InterruptedException e) {
            directoryScanner.interrupt();
            p4Processor.interrupt();
            cleaner.interrupt();
        }
        return 0;
    }

    private class Cleaner
    extends Thread {
        private BufferedReader in;
        private BufferedWriter log;
        private String workDir;

        Cleaner(String workDir, InputStream input, OutputStream err) {
            this.workDir = workDir;
            this.in = new BufferedReader(new InputStreamReader(input));
            this.log = new BufferedWriter(new OutputStreamWriter(err));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String line;
                while ((line = this.in.readLine()) != null) {
                    String filename;
                    File file;
                    if (!line.contains("- file(s) not on client.") || this.safelyDelete(file = new File(this.workDir, filename = line.replace("- file(s) not on client.", "").trim()))) continue;
                    this.log("Error deleting file: " + filename);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                IOUtils.closeQuietly((Reader)this.in);
                IOUtils.closeQuietly((Writer)this.log);
            }
        }

        private boolean safelyDelete(File file) throws IOException {
            File parent = new File(this.workDir).getCanonicalFile();
            File testPath = file.getCanonicalFile();
            while ((testPath = testPath.getParentFile()) != null) {
                if (!testPath.equals(parent)) continue;
                Util.deleteFile((File)file);
                return true;
            }
            this.log("Warning, file outside workspace not cleaned: " + file.getPath());
            return false;
        }

        private void log(String string) throws IOException {
            this.log.write(string);
            this.log.newLine();
            this.log.flush();
        }
    }

    private class ProcessByPerforce
    extends QuickCleaner.PerforceCall {
        ProcessByPerforce(String[] env, String p4exe, InputStream input, OutputStream output, String workDir, TaskListener listener) {
            super(env, new String[]{p4exe, "-d", workDir, "-x-", "have"}, input, output, workDir, listener, true);
        }
    }

    private class DirectoryScanner
    extends Thread {
        private File workDir;
        private BufferedWriter output;
        private FileFilter filter;

        DirectoryScanner(String workDir, OutputStream os, FileFilter filter) {
            this.workDir = new File(workDir);
            this.output = new BufferedWriter(new OutputStreamWriter(os));
            this.filter = filter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.scanDirForFiles(this.workDir);
            }
            catch (IOException ex) {
                Logger.getLogger(QuickCleanerCall.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                IOUtils.closeQuietly((Writer)this.output);
            }
        }

        private void scanDirForFiles(File dir) throws IOException {
            for (File file : dir.listFiles()) {
                if (Util.isSymlink((File)file) || this.filter != null && !this.filter.accept(file)) continue;
                if (file.isFile()) {
                    this.outputFilePath(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.scanDirForFiles(file);
            }
        }

        private void outputFilePath(File file) throws IOException {
            String path = file.getPath();
            if (!path.startsWith(this.workDir.getPath())) {
                return;
            }
            path = path.substring(this.workDir.getPath().length());
            if (path.startsWith(File.separator)) {
                path = path.substring(1);
            }
            this.output.write(path);
            this.output.newLine();
            this.output.flush();
        }
    }
}

