/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce;

import com.tek42.perforce.Depot;
import com.tek42.perforce.PerforceException;
import com.tek42.perforce.model.Changelist;
import com.tek42.perforce.model.Counter;
import com.tek42.perforce.model.User;
import com.tek42.perforce.model.Workspace;
import com.tek42.perforce.parse.Counters;
import com.tek42.perforce.parse.Workspaces;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Project;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.UserProperty;
import hudson.model.listeners.ItemListener;
import hudson.plugins.perforce.HudsonP4ExecutorFactory;
import hudson.plugins.perforce.PerforceChangeLogParser;
import hudson.plugins.perforce.PerforceChangeLogSet;
import hudson.plugins.perforce.PerforcePasswordEncryptor;
import hudson.plugins.perforce.PerforceRepositoryBrowser;
import hudson.plugins.perforce.PerforceSCMHelper;
import hudson.plugins.perforce.PerforceSCMRevisionState;
import hudson.plugins.perforce.PerforceTagAction;
import hudson.plugins.perforce.PerforceToolInstallation;
import hudson.plugins.perforce.PerforceUserProperty;
import hudson.plugins.perforce.QuickCleaner;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.NodeProperty;
import hudson.tasks.Messages;
import hudson.util.FormValidation;
import hudson.util.LogTaskListener;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerforceSCM
extends SCM {
    private Long configVersion = 0L;
    String p4User;
    String p4Passwd;
    String p4Port;
    String p4Client;
    String clientSpec;
    String projectPath;
    String projectOptions;
    String p4Label;
    String p4Counter;
    String p4UpstreamProject;
    String p4Stream;
    String clientOwner;
    transient String p4Exe;
    String p4SysDrive = "C:";
    String p4SysRoot = "C:\\WINDOWS";
    PerforceRepositoryBrowser browser;
    private static final Logger LOGGER = Logger.getLogger(PerforceSCM.class.getName());
    private static final int MAX_CHANGESETS_ON_FIRST_BUILD = 50;
    String p4Tool;
    boolean useClientSpec = false;
    boolean useStreamDepot = false;
    transient int lastChange;
    boolean forceSync = false;
    boolean alwaysForceSync = false;
    boolean dontUpdateServer = false;
    boolean disableAutoSync = false;
    boolean disableSyncOnly = false;
    boolean showIntegChanges = false;
    @Deprecated
    boolean useOldClientName = false;
    Boolean createWorkspace = true;
    boolean updateView = true;
    @Deprecated
    boolean dontRenameClient = true;
    boolean updateCounterValue = false;
    boolean dontUpdateClient = false;
    boolean exposeP4Passwd = false;
    boolean wipeBeforeBuild = false;
    boolean quickCleanBeforeBuild = false;
    boolean restoreChangedDeletedFiles = false;
    boolean wipeRepoBeforeBuild = false;
    int firstChange = -1;
    int fileLimit = 0;
    String excludedUsers;
    String excludedFiles;
    Boolean excludedFilesCaseSensitivity;
    private String p4Ticket = null;
    String slaveClientNameFormat = null;
    private transient String changelogFilename = null;
    private String lineEndValue = "local";
    private boolean useViewMask = false;
    private String viewMask = null;
    private boolean useViewMaskForPolling = true;
    private boolean useViewMaskForSyncing = false;
    private boolean pollOnlyOnMaster = false;
    private String p4Charset = null;
    private String p4CommandCharset = null;
    private static final Pattern COMMENT = Pattern.compile("^\\s*$|^#.*$");
    private static final Pattern DEPOT_ONLY = Pattern.compile("^\\s*[+-]?//\\S+?(/\\S+)$");
    private static final Pattern DEPOT_ONLY_QUOTED = Pattern.compile("^\\s*\"[+-]?//\\S+?(/[^\"]+)\"$");
    private static final Pattern DEPOT_AND_WORKSPACE = Pattern.compile("^\\s*([+-]?//\\S+?/\\S+)\\s+//\\S+?(/\\S+)$");
    private static final Pattern DEPOT_AND_WORKSPACE_QUOTED = Pattern.compile("^\\s*\"([+-]?//\\S+?/[^\"]+)\"\\s+\"//\\S+?(/[^\"]+)\"$");
    private static final Pattern DEPOT_AND_QUOTED_WORKSPACE = Pattern.compile("^\\s*([+-]?//\\S+?/\\S+)\\s+\"//\\S+?(/[^\"]+)\"$");
    private static final Pattern QUOTED_DEPOT_AND_WORKSPACE = Pattern.compile("^\\s*\"([+-]?//\\S+?/[^\"]+)\"\\s+//\\S+?(/\\S+)$");

    @DataBoundConstructor
    public PerforceSCM(String p4User, String p4Passwd, String p4Client, String p4Port, String projectOptions, String p4Tool, String p4SysRoot, String p4SysDrive, String p4Label, String p4Counter, String p4UpstreamProject, String lineEndValue, String p4Charset, String p4CommandCharset, String clientOwner, boolean updateCounterValue, boolean forceSync, boolean dontUpdateServer, boolean alwaysForceSync, boolean createWorkspace, boolean updateView, boolean disableAutoSync, boolean disableSyncOnly, boolean showIntegChanges, boolean dontUpdateClient, boolean exposeP4Passwd, boolean pollOnlyOnMaster, String slaveClientNameFormat, int firstChange, int fileLimit, PerforceRepositoryBrowser browser, String excludedUsers, String excludedFiles, boolean excludedFilesCaseSensitivity) {
        this.p4User = p4User;
        this.setP4Passwd(p4Passwd);
        this.exposeP4Passwd = exposeP4Passwd;
        this.p4Client = p4Client;
        this.p4Port = p4Port;
        this.p4Tool = p4Tool;
        this.pollOnlyOnMaster = pollOnlyOnMaster;
        String string = this.projectOptions = projectOptions != null ? projectOptions : "noallwrite clobber nocompress unlocked nomodtime rmdir";
        if (this.p4Label != null && p4Label != null) {
            Logger.getLogger(PerforceSCM.class.getName()).warning("Label found in views and in label field.  Using: " + p4Label);
        }
        this.p4Label = Util.fixEmptyAndTrim((String)p4Label);
        this.p4Counter = Util.fixEmptyAndTrim((String)p4Counter);
        this.updateCounterValue = updateCounterValue;
        this.p4UpstreamProject = Util.fixEmptyAndTrim((String)p4UpstreamProject);
        this.projectPath = Util.fixEmptyAndTrim((String)this.projectPath);
        this.clientOwner = Util.fixEmptyAndTrim((String)clientOwner);
        if (p4SysRoot != null && p4SysRoot.length() != 0) {
            this.p4SysRoot = Util.fixEmptyAndTrim((String)p4SysRoot);
        }
        if (p4SysDrive != null && p4SysDrive.length() != 0) {
            this.p4SysDrive = Util.fixEmptyAndTrim((String)p4SysDrive);
        }
        String systemDrive = null;
        String systemRoot = null;
        if (Hudson.isWindows()) {
            try {
                Computer currentComputer = Computer.currentComputer();
                if (currentComputer != null) {
                    EnvVars envVars = currentComputer.getEnvironment();
                    systemDrive = (String)envVars.get((Object)"SystemDrive");
                    systemRoot = (String)envVars.get((Object)"SystemRoot");
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        if (p4SysRoot != null && p4SysRoot.length() != 0) {
            this.p4SysRoot = Util.fixEmptyAndTrim((String)p4SysRoot);
        } else if (systemRoot != null && !systemRoot.trim().equals("")) {
            this.p4SysRoot = Util.fixEmptyAndTrim((String)systemRoot);
        }
        if (p4SysDrive != null && p4SysDrive.length() != 0) {
            this.p4SysDrive = Util.fixEmptyAndTrim((String)p4SysDrive);
        } else if (systemDrive != null && !systemDrive.trim().equals("")) {
            this.p4SysDrive = Util.fixEmptyAndTrim((String)systemDrive);
        }
        this.lineEndValue = lineEndValue;
        this.forceSync = forceSync;
        this.dontUpdateServer = dontUpdateServer;
        this.alwaysForceSync = alwaysForceSync;
        this.disableAutoSync = disableAutoSync;
        this.disableSyncOnly = disableSyncOnly;
        this.showIntegChanges = showIntegChanges;
        this.browser = browser;
        this.createWorkspace = createWorkspace;
        this.updateView = updateView;
        this.dontUpdateClient = dontUpdateClient;
        this.slaveClientNameFormat = slaveClientNameFormat;
        this.firstChange = firstChange;
        this.fileLimit = fileLimit;
        this.dontRenameClient = false;
        this.useOldClientName = false;
        this.p4Charset = Util.fixEmptyAndTrim((String)p4Charset);
        this.p4CommandCharset = Util.fixEmptyAndTrim((String)p4CommandCharset);
        this.excludedUsers = Util.fixEmptyAndTrim((String)excludedUsers);
        this.excludedFiles = Util.fixEmptyAndTrim((String)excludedFiles);
        this.excludedFilesCaseSensitivity = excludedFilesCaseSensitivity;
    }

    protected Depot getDepot(Launcher launcher, FilePath workspace, AbstractProject project, AbstractBuild build, Node node) {
        HudsonP4ExecutorFactory p4Factory = new HudsonP4ExecutorFactory(launcher, workspace);
        Depot depot = new Depot(p4Factory);
        depot.setUser(this.p4User);
        depot.setPort(this.p4Port);
        if (build != null) {
            depot.setClient(PerforceSCM.substituteParameters(this.p4Client, build));
            depot.setPassword(this.getDecryptedP4Passwd(build));
        } else if (project != null) {
            depot.setClient(PerforceSCM.substituteParameters(this.p4Client, this.getDefaultSubstitutions(project)));
            depot.setPassword(this.getDecryptedP4Passwd(project));
        } else {
            depot.setClient(this.p4Client);
            depot.setPassword(this.getDecryptedP4Passwd());
        }
        if (node == null) {
            depot.setExecutable(this.getP4Executable(this.p4Tool));
        } else {
            depot.setExecutable(this.getP4Executable(this.p4Tool, node, TaskListener.NULL));
        }
        depot.setSystemDrive(this.p4SysDrive);
        depot.setSystemRoot(this.p4SysRoot);
        depot.setCharset(this.p4Charset);
        depot.setCommandCharset(this.p4CommandCharset);
        return depot;
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        env.put("P4PORT", this.p4Port);
        env.put("P4USER", this.p4User);
        if (this.exposeP4Passwd) {
            PerforcePasswordEncryptor encryptor = new PerforcePasswordEncryptor();
            env.put("P4PASSWD", encryptor.decryptString(this.p4Passwd));
        }
        if (this.p4Ticket != null) {
            env.put("P4TICKET", this.p4Ticket);
        }
        env.put("P4CLIENT", this.getEffectiveClientName(build));
        PerforceTagAction pta = (PerforceTagAction)build.getAction(PerforceTagAction.class);
        if (pta != null) {
            if (pta.getChangeNumber() > 0) {
                int lastChange = pta.getChangeNumber();
                env.put("P4_CHANGELIST", Integer.toString(lastChange));
            } else if (pta.getTag() != null) {
                String label = pta.getTag();
                env.put("P4_LABEL", label);
            }
        }
        if (this.changelogFilename != null) {
            env.put("HUDSON_CHANGELOG_FILE", this.changelogFilename);
        }
    }

    public String getP4Executable(String tool) {
        PerforceToolInstallation toolInstallation = this.getP4Tool(tool);
        if (toolInstallation == null) {
            return "p4";
        }
        return toolInstallation.getP4Exe();
    }

    public String getP4Executable(String tool, Node node, TaskListener listener) {
        PerforceToolInstallation toolInstallation = this.getP4Tool(tool);
        if (toolInstallation == null) {
            return "p4";
        }
        String p4Exe = "p4";
        try {
            p4Exe = toolInstallation.forNode(node, listener).getP4Exe();
        }
        catch (IOException e) {
            listener.getLogger().println(e);
        }
        catch (InterruptedException e) {
            listener.getLogger().println(e);
        }
        return p4Exe;
    }

    public PerforceToolInstallation getP4Tool(String tool) {
        PerforceToolInstallation[] installations;
        for (PerforceToolInstallation i : installations = ((PerforceToolInstallation.DescriptorImpl)Hudson.getInstance().getDescriptorByType(PerforceToolInstallation.DescriptorImpl.class)).getInstallations()) {
            if (!i.getName().equals(tool)) continue;
            return i;
        }
        return null;
    }

    public Object readResolve() {
        if (this.createWorkspace == null) {
            this.createWorkspace = Boolean.TRUE;
        }
        if (this.p4Exe != null) {
            PerforceToolInstallation.migrateOldData(this.p4Exe);
            this.p4Tool = this.p4Exe;
        }
        if (this.excludedFilesCaseSensitivity == null) {
            this.excludedFilesCaseSensitivity = Boolean.TRUE;
        }
        if (this.clientOwner == null) {
            this.clientOwner = "";
        }
        if (this.configVersion == null) {
            this.configVersion = 0L;
        }
        return this;
    }

    private Hashtable<String, String> getDefaultSubstitutions(AbstractProject project) {
        Hashtable<String, String> subst = new Hashtable<String, String>();
        subst.put("JOB_NAME", PerforceSCM.getSafeJobName(project));
        for (NodeProperty nodeProperty : Hudson.getInstance().getGlobalNodeProperties()) {
            if (!(nodeProperty instanceof EnvironmentVariablesNodeProperty)) continue;
            subst.putAll((Map<String, String>)((EnvironmentVariablesNodeProperty)nodeProperty).getEnvVars());
        }
        ParametersDefinitionProperty pdp = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
        if (pdp != null) {
            for (ParameterDefinition pd : pdp.getParameterDefinitions()) {
                try {
                    ParameterValue defaultValue = pd.getDefaultParameterValue();
                    if (defaultValue == null) continue;
                    String name = defaultValue.getName();
                    String value = (String)defaultValue.createVariableResolver(null).resolve(name);
                    subst.put(name, value);
                }
                catch (Exception e) {}
            }
        }
        return subst;
    }

    private String getEffectiveProjectPath(AbstractBuild build, AbstractProject project, PrintStream log, Depot depot) throws PerforceException {
        String projectPath = this.useClientSpec ? this.getEffectiveProjectPathFromFile(build, project, log, depot) : PerforceSCM.substituteParameters(this.projectPath, build);
        return projectPath;
    }

    private String getEffectiveProjectPathFromFile(AbstractBuild build, AbstractProject project, PrintStream log, Depot depot) throws PerforceException {
        String clientSpec = build != null ? PerforceSCM.substituteParameters(this.clientSpec, build) : PerforceSCM.substituteParameters(this.clientSpec, this.getDefaultSubstitutions(project));
        log.println("Read ClientSpec from: " + clientSpec);
        com.tek42.perforce.parse.File f = depot.getFile(clientSpec);
        String projectPath = f.read();
        projectPath = build != null ? PerforceSCM.substituteParameters(projectPath, build) : PerforceSCM.substituteParameters(projectPath, this.getDefaultSubstitutions(project));
        return projectPath;
    }

    private int getLastBuildChangeset(AbstractProject project) {
        Run lastBuild = project.getLastBuild();
        return this.getLastChange(lastBuild);
    }

    private String getLocalPathName(FilePath path, boolean isUnix) throws IOException, InterruptedException {
        return PerforceSCM.processPathName(path.getRemote(), isUnix);
    }

    public static String processPathName(String path, boolean isUnix) {
        String pathName = path;
        pathName = pathName.replaceAll("/\\./", "/");
        pathName = pathName.replaceAll("\\\\\\.\\\\", "\\\\");
        pathName = pathName.replaceAll("/+", "/");
        boolean isRemoteUNC = pathName.startsWith("\\\\");
        pathName = pathName.replaceAll("\\\\+", "\\\\");
        if (isRemoteUNC) {
            pathName = "\\" + pathName;
        }
        pathName = isUnix ? pathName.replaceAll("\\\\", "/") : pathName.replaceAll("/", "\\\\");
        return pathName;
    }

    private static void retrieveUserInformation(Depot depot, List<Changelist> changes) throws PerforceException {
        HashSet<String> users = new HashSet<String>();
        for (Changelist change : changes) {
            users.add(change.getUser());
        }
        for (String user : users) {
            User pu;
            try {
                pu = depot.getUsers().getUser(user);
            }
            catch (Exception e) {
                throw new PerforceException("Problem getting user information for " + user, e);
            }
            if (pu == null) {
                LOGGER.warning("Perforce User (" + user + ") does not exist.");
                continue;
            }
            hudson.model.User author = hudson.model.User.get((String)user);
            PerforceUserProperty puprop = (PerforceUserProperty)author.getProperty(PerforceUserProperty.class);
            if (puprop == null || puprop.getPerforceId() == null || puprop.getPerforceId().equals("")) {
                puprop = new PerforceUserProperty();
                try {
                    author.addProperty((UserProperty)puprop);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
            puprop.setPerforceEmail(pu.getEmail());
            puprop.setPerforceId(user);
        }
    }

    public static boolean isFileInView(String filename, String projectPath, boolean caseSensitive) {
        List<String> view = PerforceSCM.parseProjectPath(projectPath, "workspace");
        boolean inView = false;
        for (int i = 0; i < view.size(); i += 2) {
            String viewline = view.get(i);
            if (viewline.startsWith("-")) {
                if (!PerforceSCM.doesFilenameMatchP4Pattern(filename, viewline.substring(1), caseSensitive)) continue;
                inView = false;
                continue;
            }
            if (viewline.startsWith("+")) {
                if (!PerforceSCM.doesFilenameMatchP4Pattern(filename, viewline.substring(1), caseSensitive)) continue;
                inView = true;
                continue;
            }
            if (!PerforceSCM.doesFilenameMatchP4Pattern(filename, viewline, caseSensitive)) continue;
            inView = true;
        }
        return inView;
    }

    private static boolean overrideWithBooleanParameter(String paramName, AbstractBuild build, boolean dflt) {
        Object param;
        if (build.getBuildVariables() != null && (param = build.getBuildVariables().get(paramName)) != null) {
            String paramString = param.toString();
            return paramString.toUpperCase().equals("TRUE") || paramString.equals("1");
        }
        return dflt;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        PrintStream log = listener.getLogger();
        this.changelogFilename = changelogFile.getAbsolutePath();
        boolean wipeBeforeBuild = PerforceSCM.overrideWithBooleanParameter("P4CLEANWORKSPACE", build, this.wipeBeforeBuild);
        boolean quickCleanBeforeBuild = PerforceSCM.overrideWithBooleanParameter("P4QUICKCLEANWORKSPACE", build, this.quickCleanBeforeBuild);
        boolean wipeRepoBeforeBuild = PerforceSCM.overrideWithBooleanParameter("P4CLEANREPOINWORKSPACE", build, this.wipeRepoBeforeBuild);
        boolean forceSync = PerforceSCM.overrideWithBooleanParameter("P4FORCESYNC", build, this.forceSync);
        boolean disableAutoSync = PerforceSCM.overrideWithBooleanParameter("P4DISABLESYNC", build, this.disableAutoSync);
        boolean disableSyncOnly = PerforceSCM.overrideWithBooleanParameter("P4DISABLESYNCONLY", build, this.disableSyncOnly);
        String p4Label = PerforceSCM.substituteParameters(this.p4Label, build);
        String viewMask = PerforceSCM.substituteParameters(this.viewMask, build);
        Depot depot = this.getDepot(launcher, workspace, build.getProject(), build, build.getBuiltOn());
        String p4Stream = PerforceSCM.substituteParameters(this.p4Stream, build);
        if ((build instanceof MatrixBuild || build instanceof MatrixRun) && !this.alwaysForceSync && !wipeBeforeBuild) {
            log.println("This is a matrix build; It is HIGHLY recommended that you enable the 'Always Force Sync' or 'Clean Workspace' options. Failing to do so will likely result in child builds not being synced properly.");
        }
        try {
            boolean bl;
            String projectPath = this.getEffectiveProjectPath(build, build.getProject(), log, depot);
            Workspace p4workspace = this.getPerforceWorkspace(build.getProject(), projectPath, depot, build.getBuiltOn(), build, launcher, workspace, (TaskListener)listener, false);
            boolean dirtyWorkspace = p4workspace.isDirty();
            this.saveWorkspaceIfDirty(depot, p4workspace, log);
            String p4config = PerforceSCM.substituteParameters("${P4CONFIG}", build);
            WipeWorkspaceExcludeFilter wipeFilter = new WipeWorkspaceExcludeFilter(".p4config", p4config);
            if (wipeBeforeBuild || quickCleanBeforeBuild) {
                long cleanStartTime = System.currentTimeMillis();
                if (wipeRepoBeforeBuild) {
                    log.println("Clear workspace includes .repository ...");
                } else {
                    log.println("Note: .repository directory in workspace (if exists) is skipped during clean.");
                    wipeFilter.exclude(".repository");
                }
                if (wipeBeforeBuild) {
                    log.println("Wiping workspace...");
                    List workspaceDirs = workspace.list((FileFilter)wipeFilter);
                    for (FilePath dir : workspaceDirs) {
                        dir.deleteRecursive();
                    }
                    log.println("Wiped workspace.");
                    forceSync = true;
                }
                if (quickCleanBeforeBuild) {
                    QuickCleaner quickCleaner = new QuickCleaner(depot.getExecutable(), launcher, depot, workspace, wipeFilter);
                    log.println("Quickly cleaning workspace...");
                    quickCleaner.doClean();
                    log.println("Workspace is clean.");
                    if (this.restoreChangedDeletedFiles) {
                        log.println("Restoring changed and deleted files...");
                        quickCleaner.doRestore();
                        log.println("Files restored.");
                    }
                }
                long cleanEndTime = System.currentTimeMillis();
                long cleanDuration = cleanEndTime - cleanStartTime;
                log.println("Clean complete, took " + cleanDuration + " ms");
            }
            if (this.useStreamDepot) {
                if (dirtyWorkspace) {
                    String p4Client = this.getConcurrentClientName(workspace, this.getEffectiveClientName(build));
                    p4workspace = depot.getWorkspaces().getWorkspace(p4Client, p4Stream);
                }
                projectPath = p4workspace.getTrimmedViewsAsString();
            }
            if (!this.updateView) {
                projectPath = p4workspace.getTrimmedViewsAsString();
            }
            String p4WorkspacePath = "//" + p4workspace.getName() + "/...";
            int lastChange = this.getLastChange(build.getPreviousBuild());
            log.println("Last build changeset: " + lastChange);
            int newestChange = lastChange;
            if (!disableAutoSync) {
                void var25_35;
                Counter counter;
                if (p4Label != null && !p4Label.trim().isEmpty()) {
                    newestChange = depot.getChanges().getHighestLabelChangeNumber(p4workspace, p4Label.trim(), p4WorkspacePath);
                } else if (this.p4UpstreamProject != null && this.p4UpstreamProject.length() > 0) {
                    log.println("Using last successful or unstable build of upstream project " + this.p4UpstreamProject);
                    Job job = (Job)Hudson.getInstance().getItemByFullName(this.p4UpstreamProject, Job.class);
                    if (job == null) {
                        throw new AbortException("Configured upstream job does not exist anymore: " + this.p4UpstreamProject + ". Please update your job configuration.");
                    }
                    Run upStreamRun = job.getLastSuccessfulBuild();
                    int lastUpStreamChange = PerforceSCM.getLastChangeNoFirstChange(upStreamRun);
                    if (lastUpStreamChange <= 0) {
                        log.println("No P4 revision found in upstream project " + this.p4UpstreamProject);
                        throw new AbortException("Configured upstream job has not been run yet: " + this.p4UpstreamProject + ". Please run it once befor launching a new build.");
                    }
                    log.println("Using P4 revision " + lastUpStreamChange + " from upstream project " + this.p4UpstreamProject);
                    newestChange = lastUpStreamChange;
                } else if (this.p4Counter != null && !this.updateCounterValue) {
                    String counterName = PerforceSCM.substituteParameters(this.p4Counter, build);
                    counter = depot.getCounters().getCounter(counterName);
                    newestChange = counter.getValue();
                } else {
                    try {
                        List<Integer> depotChanges = depot.getChanges().getChangeNumbers("//...", 0, 1);
                        if (depotChanges != null && depotChanges.size() > 0) {
                            newestChange = depotChanges.get(0);
                        }
                    }
                    catch (PerforceException e) {
                        counter = depot.getCounters().getCounter("change");
                        newestChange = counter.getValue();
                    }
                }
                if (build instanceof MatrixRun) {
                    newestChange = this.getOrSetMatrixChangeSet(build, depot, newestChange, projectPath, log);
                }
                if (lastChange <= 0 && (lastChange = newestChange - 50) < 0) {
                    lastChange = 0;
                }
                if (lastChange >= newestChange) {
                    ArrayList arrayList = new ArrayList(0);
                } else {
                    List<Integer> changeNumbersTo = this.useViewMaskForSyncing && this.useViewMask ? depot.getChanges().getChangeNumbersInRange(p4workspace, lastChange + 1, newestChange, viewMask, this.showIntegChanges) : depot.getChanges().getChangeNumbersInRange(p4workspace, lastChange + 1, newestChange, this.showIntegChanges);
                    List<Changelist> list = depot.getChanges().getChangelistsFromNumbers(changeNumbersTo, this.fileLimit);
                }
                if (var25_35.size() > 0) {
                    PerforceChangeLogSet.saveToChangeLog(new FileOutputStream(changelogFile), (List<Changelist>)var25_35);
                    newestChange = ((Changelist)var25_35.get(0)).getChangeNumber();
                    PerforceSCM.retrieveUserInformation(depot, (List<Changelist>)var25_35);
                } else {
                    this.createEmptyChangeLog(changelogFile, listener, "changelog");
                }
                if (!disableSyncOnly) {
                    StringBuilder sbMessage = new StringBuilder("Sync'ing workspace to ");
                    StringBuilder sbSyncPath = new StringBuilder(p4WorkspacePath);
                    StringBuilder sbSyncPathSuffix = new StringBuilder();
                    sbSyncPathSuffix.append("@");
                    if (p4Label != null && !p4Label.trim().isEmpty()) {
                        sbMessage.append("label ");
                        sbMessage.append(p4Label);
                        sbSyncPathSuffix.append(p4Label);
                    } else {
                        sbMessage.append("changelist ");
                        sbMessage.append(newestChange);
                        sbSyncPathSuffix.append(newestChange);
                    }
                    sbSyncPath.append((CharSequence)sbSyncPathSuffix);
                    if (forceSync || this.alwaysForceSync) {
                        sbMessage.append(" (forcing sync of unchanged files).");
                    } else {
                        sbMessage.append(".");
                    }
                    log.println(sbMessage.toString());
                    String syncPath = sbSyncPath.toString();
                    long startTime = System.currentTimeMillis();
                    if (!this.useViewMaskForSyncing || !this.useViewMask) {
                        depot.getWorkspaces().syncTo(syncPath, forceSync || this.alwaysForceSync, this.dontUpdateServer);
                    } else {
                        for (String path : viewMask.replaceAll("\r", "").split("\n")) {
                            StringBuilder sbMaskPath = new StringBuilder(path);
                            sbMaskPath.append((CharSequence)sbSyncPathSuffix);
                            String maskPath = sbMaskPath.toString();
                            depot.getWorkspaces().syncTo(maskPath, forceSync || this.alwaysForceSync, this.dontUpdateServer);
                        }
                    }
                    long endTime = System.currentTimeMillis();
                    long duration = endTime - startTime;
                    log.println("Sync complete, took " + duration + " ms");
                }
            }
            boolean bl2 = false;
            if (this.forceSync || this.firstChange != -1) {
                this.forceSync = false;
                this.firstChange = -1;
                boolean bl3 = true;
            }
            if (!this.updateView && !projectPath.equals(this.projectPath)) {
                this.projectPath = projectPath;
                bl = true;
            }
            if (bl) {
                build.getParent().save();
            }
            build.addAction((Action)new PerforceTagAction(build, depot, newestChange, projectPath, this.p4User));
            build.addAction((Action)new PerforceSCMRevisionState(newestChange));
            if (this.p4Counter != null && this.updateCounterValue) {
                Counter counter = new Counter();
                String counterName = PerforceSCM.substituteParameters(this.p4Counter, build);
                counter.setName(counterName);
                counter.setValue(newestChange);
                log.println("Updating counter " + counterName + " to " + newestChange);
                depot.getCounters().saveCounter(counter);
            }
            this.p4Ticket = depot.getP4Ticket();
            return true;
        }
        catch (PerforceException e) {
            log.print("Caught exception communicating with perforce. " + e.getMessage());
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            e.printStackTrace(pw);
            pw.flush();
            log.print(sw.toString());
            throw new AbortException("Unable to communicate with perforce. " + e.getMessage());
        }
        catch (InterruptedException e) {
            throw new IOException("Unable to get hostname from slave. " + e.getMessage());
        }
    }

    private synchronized int getOrSetMatrixChangeSet(AbstractBuild build, Depot depot, int newestChange, String projectPath, PrintStream log) {
        int lastChange = 0;
        if (build instanceof MatrixRun) {
            log.println("This is a matrix run, trying to use change number from parent/siblings...");
            MatrixBuild parentBuild = ((MatrixRun)build).getParentBuild();
            if (parentBuild != null) {
                int parentChange = this.getLastChange((Run)parentBuild);
                if (parentChange > 0) {
                    log.println("Latest change from parent is: " + Integer.toString(parentChange));
                    lastChange = parentChange;
                } else {
                    log.println("No change number has been set by parent/siblings. Using latest.");
                    parentBuild.addAction((Action)new PerforceTagAction(build, depot, newestChange, projectPath, this.p4User));
                }
            }
        }
        return lastChange;
    }

    private String getChangesPaths(Workspace p4workspace) {
        return PerforceSCMHelper.computePathFromViews(p4workspace.getViews());
    }

    public PerforceRepositoryBrowser getBrowser() {
        return this.browser;
    }

    public ChangeLogParser createChangeLogParser() {
        return new PerforceChangeLogParser();
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> ab, Launcher lnchr, TaskListener tl) throws IOException, InterruptedException {
        PerforceTagAction action = (PerforceTagAction)ab.getAction(PerforceTagAction.class);
        if (action == null) {
            return null;
        }
        return new PerforceSCMRevisionState(action.getChangeNumber());
    }

    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState scmrs) throws IOException, InterruptedException {
        PrintStream logger = listener.getLogger();
        logger.println("Looking for changes...");
        PerforceSCMRevisionState baseline = scmrs instanceof PerforceSCMRevisionState ? (PerforceSCMRevisionState)scmrs : (project.getLastBuild() != null ? (PerforceSCMRevisionState)this.calcRevisionsFromBuild((AbstractBuild)project.getLastBuild(), launcher, listener) : new PerforceSCMRevisionState(-1));
        if (project.getLastBuild() == null || baseline == null) {
            listener.getLogger().println("No previous builds to use for comparison.");
            return PollingResult.BUILD_NOW;
        }
        Hashtable<String, String> subst = this.getDefaultSubstitutions(project);
        try {
            Depot depot;
            Node buildNode = this.getPollingNode(project);
            if (buildNode == null) {
                depot = this.getDepot(launcher, workspace, project, null, buildNode);
                logger.println("Using master");
            } else {
                depot = this.getDepot(buildNode.createLauncher(listener), buildNode.getRootPath(), project, null, buildNode);
                logger.println("Using node: " + buildNode.getDisplayName());
            }
            Workspace p4workspace = this.getPerforceWorkspace(project, this.getEffectiveProjectPath(null, project, logger, depot), depot, buildNode, null, launcher, workspace, listener, true);
            this.saveWorkspaceIfDirty(depot, p4workspace, logger);
            int lastChangeNumber = baseline.getRevision();
            SCMRevisionState repositoryState = this.getCurrentDepotRevisionState(p4workspace, project, depot, logger, lastChangeNumber);
            PollingResult.Change change = repositoryState.equals((Object)baseline) ? PollingResult.Change.NONE : PollingResult.Change.SIGNIFICANT;
            return new PollingResult((SCMRevisionState)baseline, repositoryState, change);
        }
        catch (PerforceException e) {
            System.out.println("Problem: " + e.getMessage());
            logger.println("Caught Exception communicating with perforce." + e.getMessage());
            throw new IOException("Unable to communicate with perforce.  Check log file for: " + e.getMessage());
        }
    }

    private Node getPollingNode(AbstractProject project) {
        Node buildNode = project.getLastBuiltOn();
        if (this.pollOnlyOnMaster) {
            buildNode = null;
        } else {
            buildNode = project.getLastBuiltOn();
            if (!this.isNodeOnline(buildNode)) {
                buildNode = null;
            }
            if (buildNode == null && !this.pollOnlyOnMaster) {
                buildNode = this.getOnlineConfiguredNode(project);
            }
            if (this.pollOnlyOnMaster) {
                buildNode = null;
            }
        }
        return buildNode;
    }

    private Node getOnlineConfiguredNode(AbstractProject project) {
        Node buildNode = null;
        for (Node node : Hudson.getInstance().getNodes()) {
            Label l = project.getAssignedLabel();
            if (l != null && !l.contains(node) || l == null && node.getMode() == Node.Mode.EXCLUSIVE || !this.isNodeOnline(node)) continue;
            buildNode = node;
            break;
        }
        return buildNode;
    }

    private boolean isNodeOnline(Node node) {
        return node != null && node.toComputer() != null && node.toComputer().isOnline();
    }

    private SCMRevisionState getCurrentDepotRevisionState(Workspace p4workspace, AbstractProject project, Depot depot, PrintStream logger, int lastChangeNumber) throws IOException, InterruptedException, PerforceException {
        List<Integer> changeNumbers;
        int highestSelectedChangeNumber;
        if (this.p4Counter != null && !this.updateCounterValue) {
            Counter counter = depot.getCounters().getCounter(this.p4Counter);
            highestSelectedChangeNumber = counter.getValue();
            logger.println("Latest submitted change selected by named counter is " + highestSelectedChangeNumber);
            String root = "//" + p4workspace.getName() + "/...";
            changeNumbers = depot.getChanges().getChangeNumbersInRange(p4workspace, lastChangeNumber + 1, highestSelectedChangeNumber, root, false);
        } else {
            Integer newestChange;
            String root;
            String p4Label = PerforceSCM.substituteParameters(this.p4Label, this.getDefaultSubstitutions(project));
            if (p4Label != null && !p4Label.trim().isEmpty()) {
                root = "//" + p4workspace.getName() + "/...";
                newestChange = depot.getChanges().getHighestLabelChangeNumber(p4workspace, p4Label.trim(), root);
            } else {
                Counter counter = depot.getCounters().getCounter("change");
                newestChange = counter.getValue();
            }
            if (this.useViewMaskForPolling && this.useViewMask) {
                changeNumbers = depot.getChanges().getChangeNumbersInRange(p4workspace, lastChangeNumber + 1, newestChange, PerforceSCM.substituteParameters(this.viewMask, this.getDefaultSubstitutions(project)), false);
            } else {
                root = "//" + p4workspace.getName() + "/...";
                changeNumbers = depot.getChanges().getChangeNumbersInRange(p4workspace, lastChangeNumber + 1, newestChange, root, false);
            }
            if (changeNumbers.isEmpty()) {
                logger.println("No changes found.");
                return new PerforceSCMRevisionState(lastChangeNumber);
            }
            highestSelectedChangeNumber = changeNumbers.get(0);
            logger.println("Latest submitted change selected by workspace is " + highestSelectedChangeNumber);
        }
        if (lastChangeNumber >= highestSelectedChangeNumber) {
            logger.println("Assuming that the workspace definition has not changed.");
            return new PerforceSCMRevisionState(lastChangeNumber);
        }
        for (int changeNumber : changeNumbers) {
            if (this.isChangelistExcluded(depot.getChanges().getChangelist(changeNumber, this.fileLimit), project, p4workspace.getViewsAsString(), logger)) {
                logger.println("Changelist " + changeNumber + " is composed of file(s) and/or user(s) that are excluded.");
                continue;
            }
            return new PerforceSCMRevisionState(changeNumber);
        }
        return new PerforceSCMRevisionState(lastChangeNumber);
    }

    private boolean isChangelistExcluded(Changelist changelist, AbstractProject project, String view, PrintStream logger) {
        if (changelist == null) {
            return false;
        }
        if (this.excludedUsers != null && !this.excludedUsers.trim().equals("")) {
            List<String> users = Arrays.asList(PerforceSCM.substituteParameters(this.excludedUsers, this.getDefaultSubstitutions(project)).split("\n"));
            if (users.contains(changelist.getUser())) {
                logger.println("Excluded User [" + changelist.getUser() + "] found in changelist.");
                return true;
            }
            for (String regex : users) {
                try {
                    Matcher matcher = Pattern.compile(regex).matcher(changelist.getUser());
                    if (!matcher.find()) continue;
                    logger.println("Excluded User [" + changelist.getUser() + "] found in changelist.");
                    return true;
                }
                catch (PatternSyntaxException pse) {
                    break;
                }
            }
        }
        if (this.excludedFiles != null && !this.excludedFiles.trim().equals("")) {
            List<String> files = Arrays.asList(PerforceSCM.substituteParameters(this.excludedFiles, this.getDefaultSubstitutions(project)).split("\n"));
            StringBuffer buff = null;
            if (files.size() > 0 && changelist.getFiles().size() > 0) {
                for (Changelist.FileEntry f : changelist.getFiles()) {
                    if (!PerforceSCM.doesFilenameMatchAnyP4Pattern(f.getFilename(), files, this.excludedFilesCaseSensitivity) && PerforceSCM.isFileInView(f.getFilename(), view, this.excludedFilesCaseSensitivity)) {
                        return false;
                    }
                    if (buff == null) {
                        buff = new StringBuffer("Exclude file(s) found:\n");
                    }
                    buff.append("\t").append(f.getFilename());
                }
                logger.println(buff.toString());
                return true;
            }
        }
        return false;
    }

    private static boolean doesFilenameMatchAnyP4Pattern(String filename, List<String> patternStrings, boolean caseSensitive) {
        for (String patternString : patternStrings) {
            if (patternString.trim().equals("") || !PerforceSCM.doesFilenameMatchP4Pattern(filename, patternString, caseSensitive)) continue;
            return true;
        }
        return false;
    }

    public static boolean doesFilenameMatchP4Pattern(String filename, String patternString, boolean caseSensitive) throws PatternSyntaxException {
        patternString = patternString.trim();
        filename = filename.trim();
        patternString = patternString.replaceAll("\\*", "[^/]*");
        patternString = patternString.replaceAll("\\.\\.\\.", ".*");
        Pattern pattern = Pattern.compile(patternString, !caseSensitive ? 2 : 0);
        Matcher matcher = pattern.matcher(filename);
        return matcher.matches();
    }

    private void flushWorkspaceTo0(Depot depot, Workspace p4workspace, PrintStream log) throws PerforceException {
        this.saveWorkspaceIfDirty(depot, p4workspace, log);
        depot.getWorkspaces().flushTo("//" + p4workspace.getName() + "/...#0");
    }

    private boolean wouldSyncChangeWorkspace(AbstractProject project, Depot depot, PrintStream logger) throws IOException, InterruptedException, PerforceException {
        Workspaces workspaces = depot.getWorkspaces();
        String result = workspaces.syncDryRun().toString();
        if (result.startsWith("File(s) up-to-date.")) {
            logger.println("Workspace up-to-date.");
            return false;
        }
        logger.println("Workspace not up-to-date.");
        return true;
    }

    public int getLastChange(Run build) {
        if (this.firstChange > 0) {
            return this.firstChange;
        }
        return PerforceSCM.getLastChangeNoFirstChange(build);
    }

    private static int getLastChangeNoFirstChange(Run build) {
        PerforceTagAction action = PerforceSCM.getMostRecentTagAction(build);
        if (action == null) {
            return 0;
        }
        return action.getChangeNumber();
    }

    private static PerforceTagAction getMostRecentTagAction(Run build) {
        if (build == null) {
            return null;
        }
        PerforceTagAction action = (PerforceTagAction)build.getAction(PerforceTagAction.class);
        if (action != null) {
            return action;
        }
        return PerforceSCM.getMostRecentTagAction(build.getPreviousBuild());
    }

    private Workspace getPerforceWorkspace(AbstractProject project, String projectPath, Depot depot, Node buildNode, AbstractBuild build, Launcher launcher, FilePath workspace, TaskListener listener, boolean dontChangeRoot) throws IOException, InterruptedException, PerforceException {
        return this.getPerforceWorkspace(project, projectPath, depot, buildNode, build, launcher, workspace, listener, dontChangeRoot, this.updateView);
    }

    private Workspace getPerforceWorkspace(AbstractProject project, String projectPath, Depot depot, Node buildNode, AbstractBuild build, Launcher launcher, FilePath workspace, TaskListener listener, boolean dontChangeRoot, boolean updateView) throws IOException, InterruptedException, PerforceException {
        PrintStream log = listener.getLogger();
        String p4Client = build != null ? this.getEffectiveClientName(build) : this.getDefaultEffectiveClientName(project, buildNode, workspace);
        p4Client = this.getConcurrentClientName(workspace, p4Client);
        if (!this.nodeIsRemote(buildNode)) {
            log.print("Using master perforce client: ");
            log.println(p4Client);
        } else if (this.dontRenameClient) {
            log.print("Using shared perforce client: ");
            log.println(p4Client);
        } else {
            log.println("Using remote perforce client: " + p4Client);
        }
        depot.setClient(p4Client);
        String p4Stream = build == null ? PerforceSCM.substituteParameters(this.p4Stream, this.getDefaultSubstitutions(project)) : PerforceSCM.substituteParameters(this.p4Stream, build);
        Workspace p4workspace = depot.getWorkspaces().getWorkspace(p4Client, p4Stream);
        assert (p4workspace != null);
        boolean creatingNewWorkspace = p4workspace.isNew();
        if (!this.createWorkspace.booleanValue() && creatingNewWorkspace) {
            log.println("*** Perforce client workspace '" + p4Client + "' doesn't exist.");
            log.println("*** Please create it, or allow Jenkins to manage clients on it's own.");
            log.println("*** If the client name mentioned above is not what you expected, ");
            log.println("*** check your 'Client name format for slaves' advanced config option.");
            throw new AbortException("Error accessing perforce workspace.");
        }
        p4workspace.setName(p4Client);
        if (this.projectOptions != null) {
            p4workspace.setOptions(this.projectOptions);
        }
        if (this.lineEndValue != null && this.getAllLineEndChoices().contains(this.lineEndValue)) {
            p4workspace.setLineEnd(this.lineEndValue);
        }
        if (this.clientOwner != null && !this.clientOwner.trim().isEmpty()) {
            p4workspace.setOwner(this.clientOwner);
        }
        boolean isunix = true;
        if (launcher != null) {
            isunix = launcher.isUnix();
        }
        String localPath = PerforceSCM.unescapeP4String(p4workspace.getRoot());
        if (workspace != null) {
            localPath = this.getLocalPathName(workspace, isunix);
        } else if (localPath.trim().equals("")) {
            localPath = project.getRootDir().getAbsolutePath();
        }
        localPath = PerforceSCM.escapeP4String(localPath);
        if (!(localPath.equals(p4workspace.getRoot()) || dontChangeRoot || this.dontUpdateClient)) {
            log.println("Changing P4 Client Root to: " + localPath);
            this.forceSync = true;
            p4workspace.setRoot(localPath);
        }
        if (updateView || creatingNewWorkspace) {
            if (this.useStreamDepot) {
                p4workspace.setStream(p4Stream);
            } else {
                List<String> mappingPairs;
                p4workspace.setStream("");
                if (this.useClientSpec) {
                    projectPath = this.getEffectiveProjectPathFromFile(build, project, log, depot);
                }
                if (!PerforceSCM.equalsProjectPath(mappingPairs = PerforceSCM.parseProjectPath(projectPath, p4Client, log), p4workspace.getViews())) {
                    log.println("Changing P4 Client View from:\n" + p4workspace.getViewsAsString());
                    log.println("Changing P4 Client View to: ");
                    p4workspace.clearViews();
                    int i = 0;
                    while (i < mappingPairs.size()) {
                        String depotPath = mappingPairs.get(i++);
                        String clientPath = mappingPairs.get(i++);
                        p4workspace.addView(" " + depotPath + " " + clientPath);
                        log.println("  " + depotPath + " " + clientPath);
                    }
                }
            }
        }
        p4workspace.setHost("");
        return p4workspace;
    }

    private String getEffectiveClientName(AbstractBuild build) {
        Node buildNode = build.getBuiltOn();
        FilePath workspace = build.getWorkspace();
        String p4Client = this.p4Client;
        p4Client = PerforceSCM.substituteParameters(p4Client, build);
        try {
            p4Client = this.getEffectiveClientName(p4Client, buildNode);
        }
        catch (Exception e) {
            new StreamTaskListener(System.out).getLogger().println("Could not get effective client name: " + e.getMessage());
        }
        return p4Client;
    }

    private String getDefaultEffectiveClientName(AbstractProject project, Node buildNode, FilePath workspace) throws IOException, InterruptedException {
        String basename = PerforceSCM.substituteParameters(this.p4Client, this.getDefaultSubstitutions(project));
        return this.getEffectiveClientName(basename, buildNode);
    }

    private String getEffectiveClientName(String basename, Node buildNode) throws IOException, InterruptedException {
        String p4Client = basename;
        if (this.nodeIsRemote(buildNode) && !this.getSlaveClientNameFormat().equals("")) {
            String host = null;
            Computer c = buildNode.toComputer();
            if (c != null) {
                host = c.getHostName();
            }
            if (host == null) {
                LOGGER.log(Level.WARNING, "Could not get hostname for slave " + buildNode.getDisplayName());
                host = "UNKNOWNHOST";
            }
            if (host.contains(".")) {
                host = String.valueOf(host.subSequence(0, host.indexOf(46)));
            }
            String hash = String.valueOf(buildNode.getNodeName().hashCode());
            Hashtable<String, String> substitutions = new Hashtable<String, String>();
            substitutions.put("nodename", buildNode.getNodeName());
            substitutions.put("hostname", host);
            substitutions.put("hash", hash);
            substitutions.put("basename", basename);
            p4Client = PerforceSCM.substituteParameters(this.getSlaveClientNameFormat(), substitutions);
        }
        p4Client = p4Client.replaceAll(" ", "_");
        return p4Client;
    }

    public String getSlaveClientNameFormat() {
        if (this.slaveClientNameFormat == null || this.slaveClientNameFormat.equals("")) {
            this.slaveClientNameFormat = this.dontRenameClient ? "${basename}" : (this.useOldClientName ? "${basename}-${hostname}" : "${basename}-${hash}");
        }
        return this.slaveClientNameFormat;
    }

    private boolean nodeIsRemote(Node buildNode) {
        return buildNode != null && buildNode.getNodeName().length() != 0;
    }

    private void saveWorkspaceIfDirty(Depot depot, Workspace p4workspace, PrintStream log) throws PerforceException {
        if (this.dontUpdateClient) {
            log.println("'Don't update client' is set. Not saving the client changes.");
            return;
        }
        if (p4workspace.isNew()) {
            log.println("Saving new client " + p4workspace.getName());
            depot.getWorkspaces().saveWorkspace(p4workspace);
        } else if (p4workspace.isDirty()) {
            log.println("Saving modified client " + p4workspace.getName());
            depot.getWorkspaces().saveWorkspace(p4workspace);
        }
    }

    public static String escapeP4String(String string) {
        if (string == null) {
            return null;
        }
        String result = new String(string);
        result = result.replace("%", "%25");
        result = result.replace("@", "%40");
        result = result.replace("#", "%23");
        result = result.replace("*", "%2A");
        return result;
    }

    public static String unescapeP4String(String string) {
        if (string == null) {
            return null;
        }
        String result = new String(string);
        result = result.replace("%40", "@");
        result = result.replace("%23", "#");
        result = result.replace("%2A", "*");
        result = result.replace("%25", "%");
        return result;
    }

    private String getConcurrentClientName(FilePath workspace, String p4Client) {
        Pattern p;
        Matcher matcher;
        if (workspace != null && (matcher = (p = Pattern.compile(".*@(\\d+)$")).matcher(workspace.getRemote())).find()) {
            p4Client = p4Client + "_" + matcher.group(1);
        }
        return p4Client;
    }

    public static List<String> parseProjectPath(String projectPath, String p4Client) {
        PrintStream log = new LogTaskListener(LOGGER, Level.WARNING).getLogger();
        return PerforceSCM.parseProjectPath(projectPath, p4Client, log);
    }

    public static List<String> parseProjectPath(String projectPath, String p4Client, PrintStream log) {
        ArrayList<String> parsed = new ArrayList<String>();
        for (String line : projectPath.split("\n")) {
            Matcher depotOnly = DEPOT_ONLY.matcher(line);
            if (depotOnly.find()) {
                parsed.add(line.trim());
                parsed.add("//" + p4Client + depotOnly.group(1));
                continue;
            }
            Matcher depotOnlyQuoted = DEPOT_ONLY_QUOTED.matcher(line);
            if (depotOnlyQuoted.find()) {
                parsed.add(line.trim());
                parsed.add("\"//" + p4Client + depotOnlyQuoted.group(1) + "\"");
                continue;
            }
            Matcher depotAndWorkspace = DEPOT_AND_WORKSPACE.matcher(line);
            if (depotAndWorkspace.find()) {
                parsed.add(depotAndWorkspace.group(1));
                parsed.add("//" + p4Client + depotAndWorkspace.group(2));
                continue;
            }
            Matcher depotAndWorkspaceQuoted = DEPOT_AND_WORKSPACE_QUOTED.matcher(line);
            if (depotAndWorkspaceQuoted.find()) {
                parsed.add("\"" + depotAndWorkspaceQuoted.group(1) + "\"");
                parsed.add("\"//" + p4Client + depotAndWorkspaceQuoted.group(2) + "\"");
                continue;
            }
            Matcher depotAndQuotedWorkspace = DEPOT_AND_QUOTED_WORKSPACE.matcher(line);
            if (depotAndQuotedWorkspace.find()) {
                parsed.add(depotAndQuotedWorkspace.group(1));
                parsed.add("\"//" + p4Client + depotAndQuotedWorkspace.group(2) + "\"");
                continue;
            }
            Matcher quotedDepotAndWorkspace = QUOTED_DEPOT_AND_WORKSPACE.matcher(line);
            if (quotedDepotAndWorkspace.find()) {
                parsed.add("\"" + quotedDepotAndWorkspace.group(1) + "\"");
                parsed.add("//" + p4Client + quotedDepotAndWorkspace.group(2));
                continue;
            }
            if (line.trim().length() <= 0 || line.startsWith("#")) continue;
            log.println("Warning: Client Spec line invalid, ignoring. (" + line + ")");
        }
        return parsed;
    }

    static String substituteParameters(String string, AbstractBuild build) {
        Hashtable<String, String> subst = new Hashtable<String, String>();
        boolean useEnvironment = true;
        for (StackTraceElement ste : new Throwable().getStackTrace()) {
            if (!ste.getMethodName().equals("buildEnvVars") || !ste.getClassName().equals(PerforceSCM.class.getName())) continue;
            useEnvironment = false;
        }
        if (useEnvironment) {
            try {
                EnvVars vars = build.getEnvironment(TaskListener.NULL);
                subst.putAll((Map<String, String>)vars);
            }
            catch (IOException ex) {
                Logger.getLogger(PerforceSCM.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(PerforceSCM.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        subst.put("JOB_NAME", PerforceSCM.getSafeJobName(build));
        String hudsonName = Hudson.getInstance().getDisplayName().toLowerCase();
        subst.put("BUILD_TAG", hudsonName + "-" + build.getProject().getName() + "-" + String.valueOf(build.getNumber()));
        subst.put("BUILD_ID", build.getId());
        subst.put("BUILD_NUMBER", String.valueOf(build.getNumber()));
        for (NodeProperty nodeProperty : Hudson.getInstance().getGlobalNodeProperties()) {
            if (!(nodeProperty instanceof EnvironmentVariablesNodeProperty)) continue;
            subst.putAll((Map<String, String>)((EnvironmentVariablesNodeProperty)nodeProperty).getEnvVars());
        }
        for (NodeProperty nodeProperty : build.getBuiltOn().getNodeProperties()) {
            if (!(nodeProperty instanceof EnvironmentVariablesNodeProperty)) continue;
            subst.putAll((Map<String, String>)((EnvironmentVariablesNodeProperty)nodeProperty).getEnvVars());
        }
        String result = PerforceSCM.substituteParameters(string, subst);
        result = PerforceSCM.substituteParameters(result, build.getBuildVariables());
        return result;
    }

    static String getSafeJobName(AbstractBuild build) {
        return PerforceSCM.getSafeJobName(build.getProject());
    }

    static String getSafeJobName(AbstractProject project) {
        return project.getFullName().replace('/', '-').replace('=', '-').replace(',', '-');
    }

    static String substituteParameters(String string, Map<String, String> subst) {
        if (string == null) {
            return null;
        }
        String newString = string;
        for (Map.Entry<String, String> entry : subst.entrySet()) {
            newString = newString.replace("${" + entry.getKey() + "}", entry.getValue());
        }
        return newString;
    }

    static boolean equalsProjectPath(List<String> pairs, List<String> lines) {
        Iterator<String> pi = pairs.iterator();
        for (String line : lines) {
            if (!pi.hasNext()) {
                return false;
            }
            String p1 = pi.next();
            String p2 = pi.next();
            if (line.trim().equals(p1.trim() + " " + p2.trim())) continue;
            return false;
        }
        return !pi.hasNext();
    }

    public String getClientSpec() {
        return this.clientSpec;
    }

    public void setClientSpec(String clientSpec) {
        this.clientSpec = clientSpec;
    }

    public boolean isUseClientSpec() {
        return this.useClientSpec;
    }

    public void setUseClientSpec(boolean useClientSpec) {
        this.useClientSpec = useClientSpec;
    }

    public boolean isUseStreamDepot() {
        return this.useStreamDepot;
    }

    public void setUseStreamDepot(boolean useStreamDepot) {
        this.useStreamDepot = useStreamDepot;
    }

    public String getP4Stream() {
        return this.p4Stream;
    }

    public void setP4Stream(String stream) {
        this.p4Stream = stream;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public void setProjectPath(String projectPath) {
        Matcher m = Pattern.compile("(@\\S+)\\s*").matcher(projectPath);
        if (m.find()) {
            this.p4Label = m.group(1);
            projectPath = projectPath.substring(0, m.start(1)) + projectPath.substring(m.end(1));
        }
        this.projectPath = projectPath;
    }

    public String getP4User() {
        return this.p4User;
    }

    public void setP4User(String user) {
        this.p4User = user;
    }

    public String getP4Passwd() {
        return this.p4Passwd;
    }

    public String getDecryptedP4Passwd() {
        PerforcePasswordEncryptor encryptor = new PerforcePasswordEncryptor();
        return encryptor.decryptString(this.p4Passwd);
    }

    public String getDecryptedP4Passwd(AbstractBuild build) {
        return PerforceSCM.substituteParameters(this.getDecryptedP4Passwd(), build);
    }

    public String getDecryptedP4Passwd(AbstractProject project) {
        return PerforceSCM.substituteParameters(this.getDecryptedP4Passwd(), this.getDefaultSubstitutions(project));
    }

    public void setP4Passwd(String passwd) {
        PerforcePasswordEncryptor encryptor = new PerforcePasswordEncryptor();
        this.p4Passwd = encryptor.appearsToBeAnEncryptedPassword(passwd) ? passwd : encryptor.encryptString(passwd);
    }

    public String getP4Port() {
        return this.p4Port;
    }

    public void setP4Port(String port) {
        this.p4Port = port;
    }

    public String getP4Client() {
        return this.p4Client;
    }

    public void setP4Client(String client) {
        this.p4Client = client;
    }

    public String getP4SysDrive() {
        return this.p4SysDrive;
    }

    public void setP4SysDrive(String sysDrive) {
        this.p4SysDrive = sysDrive;
    }

    public String getP4SysRoot() {
        return this.p4SysRoot;
    }

    public void setP4SysRoot(String sysRoot) {
        this.p4SysRoot = sysRoot;
    }

    public String getP4Exe() {
        return this.p4Exe;
    }

    public void setP4Exe(String exe) {
        this.p4Exe = exe;
    }

    public String getP4Tool() {
        return this.p4Tool;
    }

    public void setP4Tool(String tool) {
        this.p4Tool = tool;
    }

    public String getP4Label() {
        return this.p4Label;
    }

    public void setP4Label(String label) {
        this.p4Label = label;
    }

    public String getP4Counter() {
        return this.p4Counter;
    }

    public void setP4Counter(String counter) {
        this.p4Counter = counter;
    }

    public String getP4UpstreamProject() {
        return this.p4UpstreamProject;
    }

    public void setP4UpstreamProject(String project) {
        this.p4UpstreamProject = project;
    }

    public boolean isUpdateCounterValue() {
        return this.updateCounterValue;
    }

    public void setUpdateCounterValue(boolean updateCounterValue) {
        this.updateCounterValue = updateCounterValue;
    }

    public boolean isExposeP4Passwd() {
        return this.exposeP4Passwd;
    }

    public void setExposeP4Passwd(boolean exposeP4Passwd) {
        this.exposeP4Passwd = exposeP4Passwd;
    }

    public String getProjectOptions() {
        return this.projectOptions;
    }

    public void setProjectOptions(String projectOptions) {
        this.projectOptions = projectOptions;
    }

    public void setCreateWorkspace(boolean val) {
        this.createWorkspace = val;
    }

    public boolean isCreateWorkspace() {
        return this.createWorkspace;
    }

    public void setUpdateView(boolean update) {
        this.updateView = update;
    }

    public boolean isUpdateView() {
        return this.updateView;
    }

    public boolean isForceSync() {
        return this.forceSync;
    }

    public boolean isAlwaysForceSync() {
        return this.alwaysForceSync;
    }

    public boolean isDisableAutoSync() {
        return this.disableAutoSync;
    }

    public boolean isUseOldClientName() {
        return this.useOldClientName;
    }

    public void setForceSync(boolean force) {
        this.forceSync = force;
    }

    public void setAlwaysForceSync(boolean force) {
        this.alwaysForceSync = force;
    }

    public void setDisableAutoSync(boolean disable) {
        this.disableAutoSync = disable;
    }

    public void setUseOldClientName(boolean use) {
        this.useOldClientName = use;
    }

    public boolean isUseLabel() {
        return this.p4Label != null;
    }

    public void setDontRenameClient(boolean dontRenameClient) {
        this.dontRenameClient = dontRenameClient;
    }

    public boolean isDontRenameClient() {
        return this.dontRenameClient;
    }

    public boolean isWipeBeforeBuild() {
        return this.wipeBeforeBuild;
    }

    public boolean isCleanWorkspaceBeforeBuild() {
        return this.wipeBeforeBuild || this.quickCleanBeforeBuild;
    }

    public boolean isWipeRepoBeforeBuild() {
        return this.wipeRepoBeforeBuild;
    }

    public void setSlaveClientNameFormat(String clientFormat) {
        this.slaveClientNameFormat = clientFormat;
    }

    public void setWipeBeforeBuild(boolean wipeBeforeBuild) {
        this.wipeBeforeBuild = wipeBeforeBuild;
    }

    public void setQuickCleanBeforeBuild(boolean quickCleanBeforeBuild) {
        this.quickCleanBeforeBuild = quickCleanBeforeBuild;
    }

    public boolean isDontUpdateClient() {
        return this.dontUpdateClient;
    }

    public void setDontUpdateClient(boolean dontUpdateClient) {
        this.dontUpdateClient = dontUpdateClient;
    }

    public boolean isUseViewMaskForPolling() {
        return this.useViewMaskForPolling;
    }

    public void setUseViewMaskForPolling(boolean useViewMaskForPolling) {
        this.useViewMaskForPolling = useViewMaskForPolling;
    }

    public boolean isUseViewMaskForSyncing() {
        return this.useViewMaskForSyncing;
    }

    public void setUseViewMaskForSyncing(boolean useViewMaskForSyncing) {
        this.useViewMaskForSyncing = useViewMaskForSyncing;
    }

    public String getViewMask() {
        return this.viewMask;
    }

    public void setViewMask(String viewMask) {
        this.viewMask = viewMask;
    }

    public boolean isUseViewMask() {
        return this.useViewMask;
    }

    public void setUseViewMask(boolean useViewMask) {
        this.useViewMask = useViewMask;
    }

    public String getP4Charset() {
        return this.p4Charset;
    }

    public void setP4Charset(String p4Charset) {
        this.p4Charset = p4Charset;
    }

    public String getP4CommandCharset() {
        return this.p4CommandCharset;
    }

    public void setP4CommandCharset(String p4CommandCharset) {
        this.p4CommandCharset = p4CommandCharset;
    }

    public String getLineEndValue() {
        return this.lineEndValue;
    }

    public void setLineEndValue(String lineEndValue) {
        this.lineEndValue = lineEndValue;
    }

    public boolean isShowIntegChanges() {
        return this.showIntegChanges;
    }

    public void setShowIntegChanges(boolean showIntegChanges) {
        this.showIntegChanges = showIntegChanges;
    }

    public boolean isDisableSyncOnly() {
        return this.disableSyncOnly;
    }

    public void setDisableSyncOnly(boolean disableSyncOnly) {
        this.disableSyncOnly = disableSyncOnly;
    }

    public String getExcludedUsers() {
        return this.excludedUsers;
    }

    public void setExcludedUsers(String users) {
        this.excludedUsers = users;
    }

    public String getExcludedFiles() {
        return this.excludedFiles;
    }

    public void setExcludedFiles(String files) {
        this.excludedFiles = files;
    }

    public boolean isPollOnlyOnMaster() {
        return this.pollOnlyOnMaster;
    }

    public void setPollOnlyOnMaster(boolean pollOnlyOnMaster) {
        this.pollOnlyOnMaster = pollOnlyOnMaster;
    }

    public boolean isDontUpdateServer() {
        return this.dontUpdateServer;
    }

    public void setDontUpdateServer(boolean dontUpdateServer) {
        this.dontUpdateServer = dontUpdateServer;
    }

    public boolean getExcludedFilesCaseSensitivity() {
        return this.excludedFilesCaseSensitivity;
    }

    public void setExcludedFilesCaseSensitivity(boolean excludedFilesCaseSensitivity) {
        this.excludedFilesCaseSensitivity = excludedFilesCaseSensitivity;
    }

    public void setWipeRepoBeforeBuild(boolean wipeRepoBeforeBuild) {
        this.wipeRepoBeforeBuild = wipeRepoBeforeBuild;
    }

    public boolean isQuickCleanBeforeBuild() {
        return this.quickCleanBeforeBuild;
    }

    public boolean isRestoreChangedDeletedFiles() {
        return this.restoreChangedDeletedFiles;
    }

    public void setRestoreChangedDeletedFiles(boolean restoreChangedDeletedFiles) {
        this.restoreChangedDeletedFiles = restoreChangedDeletedFiles;
    }

    public List<String> getAllLineEndChoices() {
        List<String> allChoices = ((PerforceSCMDescriptor)this.getDescriptor()).getAllLineEndChoices();
        ArrayList<String> choices = new ArrayList<String>();
        choices.add(this.lineEndValue);
        for (String choice : allChoices) {
            if (choice.equals(this.lineEndValue)) continue;
            choices.add(choice);
        }
        return choices;
    }

    public String getFirstChange() {
        if (this.firstChange <= 0) {
            return "";
        }
        return Integer.valueOf(this.firstChange).toString();
    }

    public String getFileLimit() {
        if (this.fileLimit <= 0) {
            return "";
        }
        return Integer.valueOf(this.fileLimit).toString();
    }

    public void setFileLimit(int fileLimit) {
        this.fileLimit = fileLimit;
    }

    public boolean processWorkspaceBeforeDeletion(AbstractProject<?, ?> project, FilePath workspace, Node node) {
        Logger perforceLogger = Logger.getLogger(PerforceSCM.class.getName());
        perforceLogger.info("Workspace '" + workspace.getRemote() + "' is being deleted; flushing workspace to revision 0.");
        LogTaskListener loglistener = new LogTaskListener(perforceLogger, Level.INFO);
        PrintStream log = loglistener.getLogger();
        StreamTaskListener listener = new StreamTaskListener(log);
        Launcher launcher = node.createLauncher((TaskListener)listener);
        Depot depot = this.getDepot(launcher, workspace, project, null, node);
        try {
            Workspace p4workspace = this.getPerforceWorkspace(project, PerforceSCM.substituteParameters(this.projectPath, this.getDefaultSubstitutions(project)), depot, node, null, null, workspace, (TaskListener)listener, true, false);
            this.flushWorkspaceTo0(depot, p4workspace, log);
        }
        catch (Exception ex) {
            Logger.getLogger(PerforceSCM.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        return true;
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    public boolean isSlaveClientNameStatic() {
        Hashtable<String, String> testSub1 = new Hashtable<String, String>();
        testSub1.put("hostname", "HOSTNAME1");
        testSub1.put("nodename", "NODENAME1");
        testSub1.put("hash", "HASH1");
        testSub1.put("basename", this.p4Client);
        String result1 = PerforceSCM.substituteParameters(this.getSlaveClientNameFormat(), testSub1);
        Hashtable<String, String> testSub2 = new Hashtable<String, String>();
        testSub2.put("hostname", "HOSTNAME2");
        testSub2.put("nodename", "NODENAME2");
        testSub2.put("hash", "HASH2");
        testSub2.put("basename", this.p4Client);
        String result2 = PerforceSCM.substituteParameters(this.getSlaveClientNameFormat(), testSub2);
        return result1.equals(result2);
    }

    public boolean supportsPolling() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class PerforceSCMDescriptor
    extends SCMDescriptor<PerforceSCM> {
        public PerforceSCMDescriptor() {
            super(PerforceSCM.class, PerforceRepositoryBrowser.class);
            this.load();
        }

        public String getDisplayName() {
            return "Perforce";
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            PerforceSCM newInstance = (PerforceSCM)super.newInstance(req, formData);
            String depotType = req.getParameter("p4.depotType");
            boolean useStreamDepot = depotType.equals("stream");
            boolean useClientSpec = depotType.equals("file");
            newInstance.setUseStreamDepot(useStreamDepot);
            if (useStreamDepot) {
                newInstance.setP4Stream(req.getParameter("p4Stream"));
            } else {
                newInstance.setUseClientSpec(useClientSpec);
                if (useClientSpec) {
                    newInstance.setClientSpec(req.getParameter("clientSpec"));
                } else {
                    newInstance.setProjectPath(req.getParameter("projectPath"));
                }
            }
            newInstance.setUseViewMask(req.getParameter("p4.useViewMask") != null);
            newInstance.setViewMask(Util.fixEmptyAndTrim((String)req.getParameter("p4.viewMask")));
            newInstance.setUseViewMaskForPolling(req.getParameter("p4.useViewMaskForPolling") != null);
            newInstance.setUseViewMaskForSyncing(req.getParameter("p4.useViewMaskForSyncing") != null);
            String cleanType = req.getParameter("p4.cleanType");
            boolean useWipe = false;
            boolean useQuickClean = false;
            if (cleanType != null && req.getParameter("p4.cleanWorkspace") != null) {
                useWipe = cleanType.equals("wipe");
                useQuickClean = cleanType.equals("quick");
            }
            newInstance.setWipeBeforeBuild(useWipe);
            newInstance.setQuickCleanBeforeBuild(useQuickClean);
            String wipeRepo = req.getParameter("p4.wipeRepoBeforeBuild");
            newInstance.setWipeRepoBeforeBuild(wipeRepo != null);
            newInstance.setRestoreChangedDeletedFiles(req.getParameter("p4.restoreChangedDeletedFiles") != null);
            return newInstance;
        }

        public List<PerforceToolInstallation> getP4Tools() {
            PerforceToolInstallation[] p4ToolInstallations = ((PerforceToolInstallation.DescriptorImpl)Hudson.getInstance().getDescriptorByType(PerforceToolInstallation.DescriptorImpl.class)).getInstallations();
            return Arrays.asList(p4ToolInstallations);
        }

        public String isValidProjectPath(String path) {
            if (!path.startsWith("//")) {
                return "Path must start with '//' (Example: //depot/ProjectName/...)";
            }
            if (!path.endsWith("/...") && !path.contains("@")) {
                return "Path must end with Perforce wildcard: '/...'  (Example: //depot/ProjectName/...)";
            }
            return null;
        }

        protected Depot getDepotFromRequest(StaplerRequest request) {
            PerforceToolInstallation[] installations;
            String port = Util.fixNull((String)request.getParameter("port")).trim();
            String tool = Util.fixNull((String)request.getParameter("tool")).trim();
            String user = Util.fixNull((String)request.getParameter("user")).trim();
            String pass = Util.fixNull((String)request.getParameter("pass")).trim();
            if (port.length() == 0 || tool.length() == 0) {
                return null;
            }
            Depot depot = new Depot();
            depot.setUser(user);
            PerforcePasswordEncryptor encryptor = new PerforcePasswordEncryptor();
            if (encryptor.appearsToBeAnEncryptedPassword(pass)) {
                depot.setPassword(encryptor.decryptString(pass));
            } else {
                depot.setPassword(pass);
            }
            depot.setPort(port);
            String exe = "";
            for (PerforceToolInstallation i : installations = ((PerforceToolInstallation.DescriptorImpl)Hudson.getInstance().getDescriptorByType(PerforceToolInstallation.DescriptorImpl.class)).getInstallations()) {
                if (!i.getName().equals(tool)) continue;
                exe = i.getP4Exe();
            }
            depot.setExecutable(exe);
            try {
                Counter counter = depot.getCounters().getCounter("change");
                if (counter != null) {
                    return depot;
                }
            }
            catch (PerforceException e) {
                // empty catch block
            }
            return null;
        }

        public FormValidation doValidatePerforceLogin(StaplerRequest req) {
            Depot depot = this.getDepotFromRequest(req);
            if (depot != null) {
                try {
                    depot.getStatus().isValid();
                }
                catch (PerforceException e) {
                    return FormValidation.error((String)e.getMessage());
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doValidateP4Client(StaplerRequest req) {
            Depot depot = this.getDepotFromRequest(req);
            if (depot == null) {
                return FormValidation.error((String)"Unable to check workspace against depot");
            }
            String workspace = Util.fixEmptyAndTrim((String)req.getParameter("client"));
            if (workspace == null) {
                return FormValidation.error((String)"You must enter a workspaces name");
            }
            try {
                Workspace p4Workspace = depot.getWorkspaces().getWorkspace(workspace, "");
                if (p4Workspace.getAccess() == null || p4Workspace.getAccess().equals("")) {
                    return FormValidation.warning((String)"Workspace does not exist. If \"Let Hudson/Jenkins Manage Workspace View\" is check the workspace will be automatically created.");
                }
            }
            catch (PerforceException e) {
                return FormValidation.error((String)"Error accessing perforce while checking workspace");
            }
            return FormValidation.ok();
        }

        public FormValidation doValidateP4Label(StaplerRequest req, @QueryParameter String label) throws IOException, ServletException {
            if ((label = Util.fixEmptyAndTrim((String)label)) == null) {
                return FormValidation.ok();
            }
            Depot depot = this.getDepotFromRequest(req);
            if (depot != null) {
                try {
                    com.tek42.perforce.model.Label p4Label = depot.getLabels().getLabel(label);
                    if (p4Label.getAccess() == null || p4Label.getAccess().equals("")) {
                        return FormValidation.error((String)"Label does not exist");
                    }
                }
                catch (PerforceException e) {
                    return FormValidation.error((String)"Error accessing perforce while checking label");
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doValidateP4Counter(StaplerRequest req, @QueryParameter String counter) {
            if ((counter = Util.fixEmptyAndTrim((String)counter)) == null) {
                return FormValidation.ok();
            }
            Depot depot = this.getDepotFromRequest(req);
            if (depot != null) {
                try {
                    Counters counters = depot.getCounters();
                    Counter p4Counter = counters.getCounter(counter);
                    counters.saveCounter(p4Counter);
                }
                catch (PerforceException e) {
                    return FormValidation.error((String)("Error accessing perforce while checking counter: " + e.getLocalizedMessage()));
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doValidateP4UpstreamProject(StaplerRequest req, @QueryParameter String project) throws IOException, ServletException {
            if ((project = Util.fixEmptyAndTrim((String)project)) == null) {
                return FormValidation.ok();
            }
            Job job = (Job)Hudson.getInstance().getItemByFullName(project, Job.class);
            if (job == null) {
                return FormValidation.error((String)Messages.BuildTrigger_NoSuchProject((Object)project, (Object)AbstractProject.findNearest((String)project).getName()));
            }
            Run upStreamRun = job.getLastSuccessfulBuild();
            int lastUpStreamChange = PerforceSCM.getLastChangeNoFirstChange(upStreamRun);
            if (lastUpStreamChange < 1) {
                FormValidation.warning((String)"No Perforce change found in this project");
            }
            return FormValidation.ok();
        }

        public FormValidation doValidateClientSpec(StaplerRequest req) throws IOException, ServletException {
            Depot depot = this.getDepotFromRequest(req);
            if (depot == null) {
                return FormValidation.error((String)"Unable to check ClientSpec against depot");
            }
            String clientspec = Util.fixEmptyAndTrim((String)req.getParameter("clientSpec"));
            if (clientspec == null) {
                return FormValidation.error((String)"You must enter a path to a ClientSpec file");
            }
            if (!DEPOT_ONLY.matcher(clientspec).matches() && !DEPOT_ONLY_QUOTED.matcher(clientspec).matches()) {
                return FormValidation.error((String)("Invalid depot path:" + clientspec));
            }
            String workspace = Util.fixEmptyAndTrim((String)req.getParameter("client"));
            try {
                if (!depot.getStatus().exists(clientspec)) {
                    return FormValidation.error((String)"ClientSpec does not exist");
                }
                Workspace p4Workspace = depot.getWorkspaces().getWorkspace(workspace, "");
                if (p4Workspace.getAccess() != null && !p4Workspace.getAccess().equals("") && p4Workspace.getStream() != null && !p4Workspace.getStream().equals("")) {
                    return FormValidation.warning((String)("Workspace '" + workspace + "' already exists and is associated with a stream. " + "If Jenkins is allowed to manage the workspace view, this workspace will be switched to a local workspace."));
                }
            }
            catch (PerforceException e) {
                return FormValidation.error((String)("Error accessing perforce while checking ClientSpec: " + e.getLocalizedMessage()));
            }
            return FormValidation.ok();
        }

        public FormValidation doValidateStream(StaplerRequest req) throws IOException, ServletException {
            Depot depot = this.getDepotFromRequest(req);
            if (depot == null) {
                return FormValidation.error((String)"Unable to check stream against depot");
            }
            String stream = Util.fixEmptyAndTrim((String)req.getParameter("stream"));
            if (stream == null) {
                return FormValidation.error((String)"You must enter a stream");
            }
            if (!stream.endsWith("/...")) {
                stream = stream + "/...";
            }
            if (!DEPOT_ONLY.matcher(stream).matches() && !DEPOT_ONLY_QUOTED.matcher(stream).matches()) {
                return FormValidation.error((String)("Invalid depot path:" + stream));
            }
            String workspace = Util.fixEmptyAndTrim((String)req.getParameter("client"));
            try {
                if (!depot.getStatus().exists(stream)) {
                    return FormValidation.error((String)"Stream does not exist");
                }
                Workspace p4Workspace = depot.getWorkspaces().getWorkspace(workspace, "");
                if (p4Workspace.getAccess() != null && !p4Workspace.getAccess().equals("") && (p4Workspace.getStream() == null || p4Workspace.getStream().equals(""))) {
                    return FormValidation.warning((String)("Workspace '" + workspace + "' already exists and is not associated with a stream. " + "If Jenkins is allowed to manage the workspace view, this workspace will be switched to a stream workspace."));
                }
            }
            catch (PerforceException e) {
                return FormValidation.error((String)("Error accessing perforce while checking stream: " + e.getLocalizedMessage()));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckProjectPath(@QueryParameter String value) throws IOException, ServletException {
            String view = Util.fixEmptyAndTrim((String)value);
            if (view != null) {
                for (String mapping : view.replace("\r", "").split("\n")) {
                    if (DEPOT_ONLY.matcher(mapping).matches() || DEPOT_AND_WORKSPACE.matcher(mapping).matches() || DEPOT_ONLY_QUOTED.matcher(mapping).matches() || DEPOT_AND_WORKSPACE_QUOTED.matcher(mapping).matches() || DEPOT_AND_QUOTED_WORKSPACE.matcher(mapping).matches() || QUOTED_DEPOT_AND_WORKSPACE.matcher(mapping).matches() || COMMENT.matcher(mapping).matches()) continue;
                    return FormValidation.error((String)("Invalid mapping:" + mapping));
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckViewMask(StaplerRequest req) {
            String view = Util.fixEmptyAndTrim((String)req.getParameter("viewMask"));
            if (view != null) {
                for (String path : view.replace("\r", "").split("\n")) {
                    if (path.startsWith("-") || path.startsWith("\"-")) {
                        return FormValidation.error((String)("'-' not yet supported in view mask:" + path));
                    }
                    if (DEPOT_ONLY.matcher(path).matches() || DEPOT_ONLY_QUOTED.matcher(path).matches()) continue;
                    return FormValidation.error((String)("Invalid depot path:" + path));
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckChangeList(StaplerRequest req) {
            Depot depot = this.getDepotFromRequest(req);
            String change = Util.fixNull((String)req.getParameter("change")).trim();
            if (change.length() == 0) {
                return FormValidation.ok();
            }
            if (depot != null) {
                try {
                    int number = Integer.parseInt(change);
                    Changelist changelist = depot.getChanges().getChangelist(number, -1);
                    if (changelist.getChangeNumber() != number) {
                        throw new PerforceException("broken");
                    }
                }
                catch (Exception e) {
                    return FormValidation.error((String)("Changelist: " + change + " does not exist."));
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doValidateExcludedUsers(StaplerRequest req) {
            String excludedUsers = Util.fixNull((String)req.getParameter("excludedUsers")).trim();
            List<String> users = Arrays.asList(excludedUsers.split("\n"));
            for (String regex : users) {
                if ((regex = regex.trim()).equals("")) continue;
                try {
                    regex = regex.replaceAll("\\$\\{[^\\}]*\\}", "SOMEVARIABLE");
                    Pattern.compile(regex);
                }
                catch (PatternSyntaxException pse) {
                    return FormValidation.error((String)("Invalid regular express [" + regex + "]: " + pse.getMessage()));
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doValidateExcludedFiles(StaplerRequest req) {
            String excludedFiles = Util.fixNull((String)req.getParameter("excludedFiles")).trim();
            Boolean excludedFilesCaseSensitivity = Boolean.valueOf(Util.fixNull((String)req.getParameter("excludedFilesCaseSensitivity")).trim());
            List<String> files = Arrays.asList(excludedFiles.split("\n"));
            for (String file : files) {
                if ((file = file.trim()).equals("")) continue;
                if (!DEPOT_ONLY.matcher(file).matches() && !DEPOT_ONLY_QUOTED.matcher(file).matches()) {
                    return FormValidation.error((String)("Invalid file spec [" + file + "]: Not a perforce file spec."));
                }
                try {
                    file = file.replaceAll("\\$\\{[^\\}]*\\}", "SOMEVARIABLE");
                    PerforceSCM.doesFilenameMatchP4Pattern("somefile", file, excludedFilesCaseSensitivity);
                }
                catch (PatternSyntaxException pse) {
                    return FormValidation.error((String)("Invalid file spec [" + file + "]: " + pse.getMessage()));
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doValidateForceSync(StaplerRequest req) {
            Boolean forceSync = Boolean.valueOf(Util.fixNull((String)req.getParameter("forceSync")).trim());
            Boolean alwaysForceSync = Boolean.valueOf(Util.fixNull((String)req.getParameter("alwaysForceSync")).trim());
            Boolean dontUpdateServer = Boolean.valueOf(Util.fixNull((String)req.getParameter("dontUpdateServer")).trim());
            if ((forceSync.booleanValue() || alwaysForceSync.booleanValue()) && dontUpdateServer.booleanValue()) {
                return FormValidation.error((String)"Don't Update Server Database (-p) option is incompatible with force syncing! Either disable -p, or disable force syncing.");
            }
            return FormValidation.ok();
        }

        public List<String> getAllLineEndChoices() {
            List<String> allChoices = Arrays.asList("local", "unix", "mac", "win", "share");
            ArrayList<String> choices = new ArrayList<String>();
            for (String choice : allChoices) {
                choices.add(choice);
            }
            return choices;
        }

        public String getAppName() {
            return Hudson.getInstance().getDisplayName();
        }

        @Extension
        public static class ItemListenerImpl
        extends ItemListener {
            public void onRenamed(Item item, String oldName, String newName) {
                for (Project p : Hudson.getInstance().getProjects()) {
                    SCM scm = p.getScm();
                    if (!(scm instanceof PerforceSCM)) continue;
                    PerforceSCM p4scm = (PerforceSCM)scm;
                    if (!oldName.equals(p4scm.p4UpstreamProject)) continue;
                    p4scm.p4UpstreamProject = newName;
                    try {
                        p.save();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to persist project setting during rename from " + oldName + " to " + newName, e);
                    }
                }
            }
        }
    }

    private static class WipeWorkspaceExcludeFilter
    implements FileFilter,
    Serializable {
        private List<String> excluded = new ArrayList<String>();

        public WipeWorkspaceExcludeFilter(String ... args) {
            for (String arg : args) {
                this.excluded.add(arg);
            }
        }

        public void exclude(String arg) {
            this.excluded.add(arg);
        }

        public boolean accept(File arg0) {
            for (String exclude : this.excluded) {
                if (!arg0.getName().equals(exclude)) continue;
                return false;
            }
            return true;
        }
    }
}

