/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce;

import com.tek42.perforce.PerforceException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PerforceSCMHelper {
    private static final Logger LOGGER = Logger.getLogger(PerforceSCMHelper.class.getName());
    private static final String DEPOT_ROOT = "//";
    private static final String EXCLUSION_VIEW_PREFIX = "-";

    private PerforceSCMHelper() {
    }

    static String computePathFromViews(Collection<String> views) {
        StringBuilder path = new StringBuilder("");
        for (String view : views) {
            StringTokenizer columns = new StringTokenizer(view, " ");
            String leftColumn = columns.nextToken().trim();
            if (leftColumn.indexOf("-//") != -1) continue;
            leftColumn = leftColumn.substring(leftColumn.indexOf(DEPOT_ROOT));
            path.append(leftColumn + " ");
        }
        return path.toString();
    }

    static boolean projectPathIsValidForMultiviews(String projectPath) {
        return projectPath.equals("//...") || projectPath.indexOf(64) > -1;
    }

    public static int readInt(byte[] bytes, int offset) {
        int result = 0;
        for (int i = offset; i < offset + 4; ++i) {
            result += (bytes[i] & 0xFF) << 8 * (i - offset);
        }
        return result;
    }

    private static Map<String, String> readPythonDictionary(byte[] dict) {
        int counter = 0;
        HashMap<String, String> map = new HashMap<String, String>();
        if (dict[0] == 123 && dict[1] == 115) {
            counter = 1;
            while (counter < dict.length && dict[counter] != 48) {
                String value;
                if (dict[counter] != 115) {
                    return null;
                }
                String key = PerforceSCMHelper.readPythonString(dict, ++counter);
                if (dict[counter += key.length() + 4] == 115) {
                    value = PerforceSCMHelper.readPythonString(dict, ++counter);
                    counter += value.length() + 4;
                } else if (dict[counter] == 105) {
                    value = Integer.toString(PerforceSCMHelper.readInt(dict, ++counter));
                    counter += 4;
                } else {
                    return null;
                }
                map.put(key, value);
            }
        } else {
            return null;
        }
        return map;
    }

    private static String readPythonString(byte[] bytes, int offset) {
        int length = PerforceSCMHelper.readInt(bytes, offset);
        String result = new String(bytes, offset + 4, length);
        return result;
    }

    public static WhereMapping parseWhereMapping(byte[] whereOutput) throws PerforceException {
        Map<String, String> map = PerforceSCMHelper.readPythonDictionary(whereOutput);
        if (map == null) {
            throw new PerforceException("Could not parse Where map.");
        }
        if (map.get("code").equals("error")) {
            LOGGER.log(Level.FINE, "P4 Where Parsing Error: " + map.get("data"));
            if (map.get("data") != null && !map.get("data").contains("not in client view")) {
                throw new PerforceException("P4 Where Parsing Error: " + map.get("data"));
            }
        }
        String depot = map.get("depotFile");
        String workspace = map.get("clientFile");
        String filesystem = map.get("path");
        return new WhereMapping(depot, workspace, filesystem);
    }

    public static class WhereMapping {
        private String depot;
        private String workspace;
        private String filesystem;

        public WhereMapping(String depot, String workspace, String filesystem) {
            this.depot = depot;
            this.workspace = workspace;
            this.filesystem = filesystem;
        }

        public String getDepotPath() {
            return this.depot;
        }

        public String getFilesystemPath() {
            return this.filesystem;
        }

        public String getWorkspacePath() {
            return this.workspace;
        }
    }
}

