/*
 * Decompiled with CFR 0.152.
 */
package com.tek42.perforce.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractViewsSupport
implements Serializable {
    protected List<String> views = new ArrayList<String>();
    protected boolean dirty = false;

    public boolean isDirty() {
        return this.dirty;
    }

    public final void markDirty() {
        this.dirty = true;
    }

    public final void clearDirty() {
        this.dirty = false;
    }

    public List<String> getViews() {
        return this.views;
    }

    public String getViewsAsString() {
        StringBuilder sb = new StringBuilder();
        for (String view : this.views) {
            sb.append(view + "\n");
        }
        return sb.toString();
    }

    public String getTrimmedViewsAsString() {
        StringBuilder sb = new StringBuilder();
        for (String view : this.views) {
            sb.append(view.trim() + "\n");
        }
        return sb.toString();
    }

    public void addView(String view) {
        this.views.add(view);
        this.markDirty();
    }

    public void clearViews() {
        this.views.clear();
        this.markDirty();
    }
}

