/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce;

import com.tek42.perforce.PerforceException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.perforce.HudsonP4Executor;
import hudson.plugins.perforce.HudsonPipedOutputStream;
import hudson.remoting.FastPipedInputStream;
import hudson.remoting.FastPipedOutputStream;
import hudson.util.StreamTaskListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HudsonP4DefaultExecutor
implements HudsonP4Executor {
    private BufferedReader reader;
    private BufferedWriter writer;
    private Launcher hudsonLauncher;
    private String[] env;
    private FilePath filePath;

    HudsonP4DefaultExecutor(Launcher hudsonLauncher, Map<String, String> envMap, FilePath filePath) {
        this.hudsonLauncher = hudsonLauncher;
        this.env = this.convertEnvMaptoArray(envMap);
        this.filePath = filePath;
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void exec(String[] cmd) throws PerforceException {
        try {
            if (null == this.hudsonLauncher) {
                this.hudsonLauncher = Hudson.getInstance().createLauncher((TaskListener)new StreamTaskListener(System.out));
            }
            HudsonPipedOutputStream hudsonOut = new HudsonPipedOutputStream();
            FastPipedInputStream p4in = new FastPipedInputStream((FastPipedOutputStream)hudsonOut);
            this.reader = new BufferedReader(new InputStreamReader((InputStream)p4in));
            FastPipedInputStream hudsonIn = new FastPipedInputStream();
            FastPipedOutputStream p4out = new FastPipedOutputStream(hudsonIn);
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)p4out));
            Proc process = this.hudsonLauncher.launch().cmds(cmd).envs(this.env).stdin((InputStream)hudsonIn).stdout((OutputStream)((Object)hudsonOut)).pwd(this.filePath).start();
            hudsonOut.closeOnProcess(process);
        }
        catch (IOException e) {
            this.closeBuffers();
            throw new PerforceException("Could not run perforce command.", e);
        }
    }

    private String[] convertEnvMaptoArray(Map<String, String> envMap) {
        Set<String> keySet = envMap.keySet();
        String[] keys = keySet.toArray(new String[0]);
        String[] result = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            result[i] = keys[i] + "=" + envMap.get(keys[i]);
        }
        return result;
    }

    @Override
    public BufferedReader getReader() {
        return this.reader;
    }

    @Override
    public BufferedWriter getWriter() {
        return this.writer;
    }

    private void closeBuffers() {
        try {
            this.reader.close();
        }
        catch (IOException ignoredException) {
            // empty catch block
        }
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

