/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce.browsers;

import com.tek42.perforce.model.Changelist;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.plugins.perforce.PerforceChangeLogEntry;
import hudson.plugins.perforce.PerforceRepositoryBrowser;
import hudson.plugins.perforce.browsers.QueryBuilder;
import hudson.scm.RepositoryBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public final class FishEyePerforce
extends PerforceRepositoryBrowser {
    public final URL url;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public FishEyePerforce(URL url) {
        this.url = FishEyePerforce.normalizeToEndWithSlash((URL)url);
    }

    public URL getDiffLink(Changelist.FileEntry file) throws IOException {
        if (file.getAction() != Changelist.FileEntry.Action.EDIT && file.getAction() != Changelist.FileEntry.Action.INTEGRATE) {
            return null;
        }
        Changelist change = file.getChangelist();
        int r = 0;
        r = change != null ? new Integer(change.getChangeNumber()).intValue() : new Integer(file.getRevision()).intValue();
        if (r <= 1) {
            return null;
        }
        return new URL(this.url, FishEyePerforce.trimHeadSlash((String)FishEyePerforce.trimHeadSlash((String)file.getFilename())) + new QueryBuilder(this.url.getQuery()).add("r1=").add("r2=" + r));
    }

    public URL getFileLink(Changelist.FileEntry file) throws IOException {
        return new URL(this.url, FishEyePerforce.trimHeadSlash((String)FishEyePerforce.trimHeadSlash((String)file.getFilename())) + new QueryBuilder(this.url.getQuery()));
    }

    public URL getChangeSetLink(PerforceChangeLogEntry change) throws IOException {
        return new URL(this.url, "../../changelog/" + this.getProjectName() + "/?cs=" + change.getChange().getChangeNumber());
    }

    private String getProjectName() {
        String p = this.url.getPath();
        if (p.endsWith("/")) {
            p = p.substring(0, p.length() - 1);
        }
        int idx = p.lastIndexOf(47);
        return p.substring(idx + 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        private static final Pattern URL_PATTERN = Pattern.compile(".+/browse/[^/]+/");

        public String getDisplayName() {
            return "FishEye";
        }

        public FormValidation doCheck(final @QueryParameter String value) throws IOException, ServletException {
            return new FormValidation.URLCheck(){

                protected FormValidation check() throws IOException, ServletException {
                    String url = Util.fixEmpty((String)value);
                    if (url == null) {
                        return FormValidation.ok();
                    }
                    if (!url.endsWith("/")) {
                        url = url + '/';
                    }
                    if (!URL_PATTERN.matcher(url).matches()) {
                        return FormValidation.errorWithMarkup((String)"The URL should end like <tt>.../browse/foobar/</tt>");
                    }
                    try {
                        if (!this.findText(this.open(new URL(url)), "FishEye")) {
                            return FormValidation.error((String)"This is a valid URL but it doesn't look like FishEye");
                        }
                    }
                    catch (IOException e) {
                        this.handleIOException(url, e);
                    }
                    return FormValidation.ok();
                }
            }.check();
        }

        public FishEyePerforce newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (FishEyePerforce)((Object)req.bindParameters(FishEyePerforce.class, "fisheye.perforce."));
        }
    }
}

