/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce;

import com.tek42.perforce.Depot;
import com.tek42.perforce.PerforceException;
import com.tek42.perforce.model.Changelist;
import com.tek42.perforce.model.Counter;
import com.tek42.perforce.model.Workspace;
import com.tek42.perforce.parse.Counters;
import com.tek42.perforce.parse.Workspaces;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.perforce.HudsonP4ExecutorFactory;
import hudson.plugins.perforce.PerforceChangeLogParser;
import hudson.plugins.perforce.PerforceChangeLogSet;
import hudson.plugins.perforce.PerforcePasswordEncryptor;
import hudson.plugins.perforce.PerforceRepositoryBrowser;
import hudson.plugins.perforce.PerforceSCMHelper;
import hudson.plugins.perforce.PerforceTagAction;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.util.FormValidation;
import hudson.util.LogTaskListener;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerforceSCM
extends SCM {
    String p4User;
    String p4Passwd;
    String p4Port;
    String p4Client;
    String projectPath;
    String projectOptions;
    String p4Label;
    String p4Counter;
    String p4Exe = "C:\\Program Files\\Perforce\\p4.exe";
    String p4SysDrive = "C:";
    String p4SysRoot = "C:\\WINDOWS";
    PerforceRepositoryBrowser browser;
    private static final Logger LOGGER = Logger.getLogger(PerforceSCM.class.getName());
    private static final int MAX_CHANGESETS_ON_FIRST_BUILD = 50;
    transient int lastChange;
    boolean forceSync = false;
    boolean alwaysForceSync = false;
    boolean disableAutoSync = false;
    boolean disableSyncOnly = false;
    @Deprecated
    boolean useOldClientName = false;
    boolean updateView = true;
    @Deprecated
    boolean dontRenameClient = true;
    boolean updateCounterValue = false;
    boolean dontUpdateClient = false;
    boolean exposeP4Passwd = false;
    boolean wipeBeforeBuild = false;
    boolean wipeRepoBeforeBuild = false;
    int firstChange = -1;
    String excludedUsers;
    String excludedFiles;
    private String p4Ticket = null;
    String slaveClientNameFormat = null;
    private transient String changelogFilename = null;
    private String lineEndValue = "local";
    private boolean useViewMask = false;
    private String viewMask = null;
    private boolean useViewMaskForPolling = true;
    private boolean useViewMaskForSyncing = false;
    private boolean pollOnlyOnMaster = false;
    private String p4Charset = null;
    private String p4CommandCharset = null;
    private static final Pattern COMMENT = Pattern.compile("^\\s*$|^#.*$");
    private static final Pattern DEPOT_ONLY = Pattern.compile("^\\s*[+-]?//\\S+?(/\\S+)$");
    private static final Pattern DEPOT_ONLY_QUOTED = Pattern.compile("^\\s*\"[+-]?//\\S+?(/[^\"]+)\"$");
    private static final Pattern DEPOT_AND_WORKSPACE = Pattern.compile("^\\s*([+-]?//\\S+?/\\S+)\\s+//\\S+?(/\\S+)$");
    private static final Pattern DEPOT_AND_WORKSPACE_QUOTED = Pattern.compile("^\\s*\"([+-]?//\\S+?/[^\"]+)\"\\s+\"//\\S+?(/[^\"]+)\"$");
    private static final Pattern DEPOT_AND_QUOTED_WORKSPACE = Pattern.compile("^\\s*([+-]?//\\S+?/\\S+)\\s+\"//\\S+?(/[^\"]+)\"$");

    @DataBoundConstructor
    public PerforceSCM(String p4User, String p4Passwd, String p4Client, String p4Port, String projectPath, String projectOptions, String p4Exe, String p4SysRoot, String p4SysDrive, String p4Label, String p4Counter, String lineEndValue, String p4Charset, String p4CommandCharset, boolean updateCounterValue, boolean forceSync, boolean alwaysForceSync, boolean updateView, boolean disableAutoSync, boolean disableSyncOnly, boolean wipeBeforeBuild, boolean wipeRepoBeforeBuild, boolean dontUpdateClient, boolean exposeP4Passwd, boolean pollOnlyOnMaster, String slaveClientNameFormat, int firstChange, PerforceRepositoryBrowser browser, String excludedUsers, String excludedFiles) {
        this.p4User = p4User;
        this.setP4Passwd(p4Passwd);
        this.exposeP4Passwd = exposeP4Passwd;
        this.p4Client = p4Client;
        this.p4Port = p4Port;
        this.pollOnlyOnMaster = pollOnlyOnMaster;
        this.projectOptions = projectOptions != null ? projectOptions : "noallwrite clobber nocompress unlocked nomodtime rmdir";
        Matcher m = Pattern.compile("(@\\S+)\\s*").matcher(projectPath);
        if (m.find()) {
            p4Label = m.group(1);
            projectPath = projectPath.substring(0, m.start(1)) + projectPath.substring(m.end(1));
        }
        if (this.p4Label != null && p4Label != null) {
            Logger.getLogger(PerforceSCM.class.getName()).warning("Label found in views and in label field.  Using: " + p4Label);
        }
        this.p4Label = Util.fixEmptyAndTrim((String)p4Label);
        this.p4Counter = Util.fixEmptyAndTrim((String)p4Counter);
        this.updateCounterValue = updateCounterValue;
        this.projectPath = Util.fixEmptyAndTrim((String)projectPath);
        if (p4Exe != null) {
            this.p4Exe = Util.fixEmptyAndTrim((String)p4Exe);
        }
        if (p4SysRoot != null && p4SysRoot.length() != 0) {
            this.p4SysRoot = Util.fixEmptyAndTrim((String)p4SysRoot);
        }
        if (p4SysDrive != null && p4SysDrive.length() != 0) {
            this.p4SysDrive = Util.fixEmptyAndTrim((String)p4SysDrive);
        }
        String systemDrive = null;
        String systemRoot = null;
        if (Hudson.isWindows()) {
            try {
                EnvVars envVars = Computer.currentComputer().getEnvironment();
                systemDrive = (String)envVars.get((Object)"SystemDrive");
                systemRoot = (String)envVars.get((Object)"SystemRoot");
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        if (p4SysRoot != null && p4SysRoot.length() != 0) {
            this.p4SysRoot = Util.fixEmptyAndTrim((String)p4SysRoot);
        } else if (systemRoot != null && !systemRoot.trim().equals("")) {
            this.p4SysRoot = Util.fixEmptyAndTrim((String)systemRoot);
        }
        if (p4SysDrive != null && p4SysDrive.length() != 0) {
            this.p4SysDrive = Util.fixEmptyAndTrim((String)p4SysDrive);
        } else if (systemDrive != null && !systemDrive.trim().equals("")) {
            this.p4SysDrive = Util.fixEmptyAndTrim((String)systemDrive);
        }
        this.lineEndValue = lineEndValue;
        this.forceSync = forceSync;
        this.alwaysForceSync = alwaysForceSync;
        this.disableAutoSync = disableAutoSync;
        this.disableSyncOnly = disableSyncOnly;
        this.browser = browser;
        this.wipeBeforeBuild = wipeBeforeBuild;
        this.wipeRepoBeforeBuild = wipeRepoBeforeBuild;
        this.updateView = updateView;
        this.dontUpdateClient = dontUpdateClient;
        this.slaveClientNameFormat = slaveClientNameFormat;
        this.firstChange = firstChange;
        this.dontRenameClient = false;
        this.useOldClientName = false;
        this.p4Charset = Util.fixEmptyAndTrim((String)p4Charset);
        this.p4CommandCharset = Util.fixEmptyAndTrim((String)p4CommandCharset);
        this.excludedUsers = Util.fixEmptyAndTrim((String)excludedUsers);
        this.excludedFiles = Util.fixEmptyAndTrim((String)excludedFiles);
    }

    protected Depot getDepot(Launcher launcher, FilePath workspace, AbstractProject project) {
        HudsonP4ExecutorFactory p4Factory = new HudsonP4ExecutorFactory(launcher, workspace);
        Depot depot = new Depot(p4Factory);
        depot.setUser(this.p4User);
        PerforcePasswordEncryptor encryptor = new PerforcePasswordEncryptor();
        depot.setPassword(encryptor.decryptString(this.p4Passwd));
        depot.setPort(this.p4Port);
        if (project != null) {
            depot.setClient(PerforceSCM.substituteParameters(this.p4Client, this.getDefaultSubstitutions(project)));
        } else {
            depot.setClient(this.p4Client);
        }
        depot.setExecutable(this.p4Exe);
        depot.setSystemDrive(this.p4SysDrive);
        depot.setSystemRoot(this.p4SysRoot);
        depot.setCharset(this.p4Charset);
        depot.setCommandCharset(this.p4CommandCharset);
        return depot;
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        env.put("P4PORT", this.p4Port);
        env.put("P4USER", this.p4User);
        if (this.exposeP4Passwd) {
            if (this.p4Ticket != null) {
                env.put("P4TICKET", this.p4Ticket);
            }
            PerforcePasswordEncryptor encryptor = new PerforcePasswordEncryptor();
            env.put("P4PASSWD", encryptor.decryptString(this.p4Passwd));
        }
        env.put("P4CLIENT", this.getEffectiveClientName(build));
        PerforceTagAction pta = this.getMostRecentTagAction((Run)build);
        if (pta != null) {
            if (pta.getChangeNumber() > 0) {
                int lastChange = pta.getChangeNumber();
                env.put("P4_CHANGELIST", Integer.toString(lastChange));
            } else if (pta.getTag() != null) {
                String label = pta.getTag();
                env.put("P4_LABEL", label);
            }
        }
        if (this.changelogFilename != null) {
            env.put("HUDSON_CHANGELOG_FILE", this.changelogFilename);
        }
    }

    private Hashtable<String, String> getDefaultSubstitutions(AbstractProject project) {
        Hashtable<String, String> subst = new Hashtable<String, String>();
        subst.put("JOB_NAME", project.getFullName());
        ParametersDefinitionProperty pdp = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
        if (pdp != null) {
            for (ParameterDefinition pd : pdp.getParameterDefinitions()) {
                try {
                    ParameterValue defaultValue = pd.getDefaultParameterValue();
                    if (defaultValue == null) continue;
                    String name = defaultValue.getName();
                    String value = (String)defaultValue.createVariableResolver(null).resolve(name);
                    subst.put(name, value);
                }
                catch (Exception e) {}
            }
        }
        return subst;
    }

    private String getLocalPathName(FilePath path, boolean isUnix) throws IOException, InterruptedException {
        return PerforceSCM.processPathName(path.getRemote(), isUnix);
    }

    public static String processPathName(String path, boolean isUnix) {
        String pathName = path;
        pathName = pathName.replaceAll("\\\\+", "\\\\");
        pathName = pathName.replaceAll("/\\./", "/");
        pathName = pathName.replaceAll("\\\\\\.\\\\", "\\\\");
        pathName = pathName.replaceAll("/+", "/");
        pathName = isUnix ? pathName.replaceAll("\\\\", "/") : pathName.replaceAll("/", "\\\\");
        return pathName;
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        PrintStream log = listener.getLogger();
        this.changelogFilename = changelogFile.getAbsolutePath();
        boolean wipeBeforeBuild = this.wipeBeforeBuild;
        boolean wipeRepoBeforeBuild = this.wipeRepoBeforeBuild;
        boolean forceSync = this.forceSync;
        if (build.getBuildVariables() != null) {
            Object p4force;
            Object p4repoclean;
            Object p4clean = build.getBuildVariables().get("P4CLEANWORKSPACE");
            if (p4clean != null) {
                String p4cleanString = p4clean.toString();
                wipeBeforeBuild = p4cleanString.toUpperCase().equals("TRUE") || p4cleanString.equals("1");
            }
            if ((p4repoclean = build.getBuildVariables().get("P4CLEANREPOINWORKSPACE")) != null) {
                String p4repocleanString = p4repoclean.toString();
                wipeRepoBeforeBuild = p4repocleanString.toUpperCase().equals("TRUE") || p4repocleanString.equals("1");
            }
            if ((p4force = build.getBuildVariables().get("P4FORCESYNC")) != null) {
                String p4forceString = p4force.toString();
                forceSync = p4forceString.toUpperCase().equals("TRUE") || p4forceString.equals("1");
            }
        }
        if (wipeBeforeBuild) {
            if (wipeRepoBeforeBuild) {
                log.println("Clearing workspace...");
                log.println("Clear workspace includes .repository ...");
                if (this.processWorkspaceBeforeDeletion(build.getProject(), workspace, build.getBuiltOn())) {
                    workspace.deleteContents();
                    log.println("Cleared workspace.");
                } else {
                    log.println("Could not clear workspace. See hudson.perforce.PerforceSCM logger for details.");
                }
                forceSync = true;
            } else {
                if (this.processWorkspaceBeforeDeletion(build.getProject(), workspace, build.getBuiltOn())) {
                    List workspaceDirs = workspace.list((FileFilter)new WipeWorkspaceFilter());
                    for (FilePath dir : workspaceDirs) {
                        dir.deleteRecursive();
                    }
                    log.println("Cleared workspace.");
                    log.println("Note: .repository direcotry in workspace (if exists) is skipped ...");
                } else {
                    log.println("Could not clear workspace. See hudson.perforce.PerforceSCM logger for details.");
                }
                forceSync = true;
            }
        }
        String projectPath = PerforceSCM.substituteParameters(this.projectPath, build);
        String p4Label = PerforceSCM.substituteParameters(this.p4Label, build);
        String viewMask = PerforceSCM.substituteParameters(this.viewMask, build);
        Depot depot = this.getDepot(launcher, workspace, build.getProject());
        if ((build instanceof MatrixBuild || build instanceof MatrixRun) && !this.alwaysForceSync && !wipeBeforeBuild) {
            log.println("This is a matrix build; It is HIGHLY recommended that you enable the 'Always Force Sync' or 'Clean Workspace' options. Failing to do so will likely result in child builds not being synced properly.");
        }
        try {
            Workspace p4workspace = this.getPerforceWorkspace(build.getProject(), projectPath, depot, build.getBuiltOn(), build, launcher, workspace, (TaskListener)listener, false);
            this.saveWorkspaceIfDirty(depot, p4workspace, log);
            if (!this.updateView) {
                projectPath = p4workspace.getTrimmedViewsAsString();
            }
            String p4WorkspacePath = "//" + p4workspace.getName() + "/...";
            int lastChange = this.getLastChange(build.getPreviousBuild());
            log.println("Last build changeset: " + lastChange);
            int newestChange = lastChange;
            if (!this.disableAutoSync) {
                List<Changelist> changes;
                if (p4Label != null) {
                    changes = new ArrayList<Changelist>(0);
                } else {
                    String counterName = this.p4Counter != null && !this.updateCounterValue ? this.p4Counter : "change";
                    Counter counter = depot.getCounters().getCounter(counterName);
                    newestChange = counter.getValue();
                    if (lastChange == 0 && (lastChange = newestChange - 50) < 0) {
                        lastChange = 0;
                    }
                    if (lastChange >= newestChange) {
                        changes = new ArrayList(0);
                    } else {
                        List<Integer> changeNumbersTo = this.useViewMaskForSyncing && this.useViewMask ? depot.getChanges().getChangeNumbersInRange(p4workspace, lastChange + 1, newestChange, viewMask) : depot.getChanges().getChangeNumbersInRange(p4workspace, lastChange + 1, newestChange);
                        changes = depot.getChanges().getChangelistsFromNumbers(changeNumbersTo);
                    }
                }
                if (changes.size() > 0) {
                    PerforceChangeLogSet.saveToChangeLog(new FileOutputStream(changelogFile), changes);
                    newestChange = ((Changelist)changes.get(0)).getChangeNumber();
                } else {
                    this.createEmptyChangeLog(changelogFile, listener, "changelog");
                }
                if (!this.disableSyncOnly) {
                    StringBuilder sbMessage = new StringBuilder("Sync'ing workspace to ");
                    StringBuilder sbSyncPath = new StringBuilder(p4WorkspacePath);
                    StringBuilder sbSyncPathSuffix = new StringBuilder();
                    sbSyncPathSuffix.append("@");
                    if (p4Label != null) {
                        sbMessage.append("label ");
                        sbMessage.append(p4Label);
                        sbSyncPathSuffix.append(p4Label);
                    } else {
                        sbMessage.append("changelist ");
                        sbMessage.append(newestChange);
                        sbSyncPathSuffix.append(newestChange);
                    }
                    sbSyncPath.append((CharSequence)sbSyncPathSuffix);
                    if (forceSync || this.alwaysForceSync) {
                        sbMessage.append(" (forcing sync of unchanged files).");
                    } else {
                        sbMessage.append(".");
                    }
                    log.println(sbMessage.toString());
                    String syncPath = sbSyncPath.toString();
                    long startTime = System.currentTimeMillis();
                    if (this.useViewMaskForSyncing && this.useViewMask) {
                        for (String path : viewMask.replaceAll("\r", "").split("\n")) {
                            StringBuilder sbMaskPath = new StringBuilder(path);
                            sbMaskPath.append((CharSequence)sbSyncPathSuffix);
                            String maskPath = sbMaskPath.toString();
                            depot.getWorkspaces().syncTo(maskPath, forceSync || this.alwaysForceSync);
                        }
                    } else {
                        depot.getWorkspaces().syncTo(syncPath, forceSync || this.alwaysForceSync);
                    }
                    long endTime = System.currentTimeMillis();
                    long duration = endTime - startTime;
                    log.println("Sync complete, took " + duration + " ms");
                }
            }
            boolean doSaveProject = false;
            if (this.forceSync || this.firstChange != -1) {
                this.forceSync = false;
                this.firstChange = -1;
                doSaveProject = true;
            }
            if (!this.updateView && !projectPath.equals(this.projectPath)) {
                this.projectPath = projectPath;
                doSaveProject = true;
            }
            if (doSaveProject) {
                build.getParent().save();
            }
            if (p4Label != null) {
                build.addAction((Action)new PerforceTagAction(build, depot, p4Label, projectPath));
            } else {
                build.addAction((Action)new PerforceTagAction(build, depot, newestChange, projectPath));
            }
            if (this.p4Counter != null && this.updateCounterValue) {
                Counter counter = new Counter();
                counter.setName(this.p4Counter);
                counter.setValue(newestChange);
                log.println("Updating counter " + this.p4Counter + " to " + newestChange);
                depot.getCounters().saveCounter(counter);
            }
            this.p4Ticket = depot.getP4Ticket();
            return true;
        }
        catch (PerforceException e) {
            log.print("Caught exception communicating with perforce. " + e.getMessage());
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            e.printStackTrace(pw);
            pw.flush();
            log.print(sw.toString());
            throw new AbortException("Unable to communicate with perforce. " + e.getMessage());
        }
        catch (InterruptedException e) {
            throw new IOException("Unable to get hostname from slave. " + e.getMessage());
        }
    }

    private String getChangesPaths(Workspace p4workspace) {
        return PerforceSCMHelper.computePathFromViews(p4workspace.getViews());
    }

    public PerforceRepositoryBrowser getBrowser() {
        return this.browser;
    }

    public ChangeLogParser createChangeLogParser() {
        return new PerforceChangeLogParser();
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        PrintStream logger = listener.getLogger();
        logger.println("Looking for changes...");
        Hashtable<String, String> subst = this.getDefaultSubstitutions(project);
        try {
            Depot depot;
            Node buildNode = project.getLastBuiltOn();
            if (this.pollOnlyOnMaster) {
                buildNode = null;
            } else {
                buildNode = project.getLastBuiltOn();
                if (!this.isNodeOnline(buildNode)) {
                    buildNode = null;
                }
                if (buildNode == null && !this.pollOnlyOnMaster) {
                    buildNode = this.getOnlineConfiguredNode(project);
                }
                if (this.pollOnlyOnMaster) {
                    buildNode = null;
                }
            }
            if (buildNode == null) {
                depot = this.getDepot(launcher, workspace, project);
                logger.println("Using master");
            } else {
                depot = this.getDepot(buildNode.createLauncher(listener), buildNode.getRootPath(), project);
                logger.println("Using node: " + buildNode.getDisplayName());
            }
            Workspace p4workspace = this.getPerforceWorkspace(project, PerforceSCM.substituteParameters(this.projectPath, subst), depot, buildNode, null, launcher, workspace, listener, false);
            this.saveWorkspaceIfDirty(depot, p4workspace, logger);
            Boolean needToBuild = this.needToBuild(p4workspace, project, depot, logger);
            if (needToBuild == null) {
                needToBuild = this.wouldSyncChangeWorkspace(project, depot, logger);
            }
            if (needToBuild == Boolean.FALSE) {
                return false;
            }
            logger.println("Triggering a build.");
            return true;
        }
        catch (PerforceException e) {
            System.out.println("Problem: " + e.getMessage());
            logger.println("Caught Exception communicating with perforce." + e.getMessage());
            e.printStackTrace();
            throw new IOException("Unable to communicate with perforce.  Check log file for: " + e.getMessage());
        }
    }

    private Node getOnlineConfiguredNode(AbstractProject project) {
        Node buildNode = null;
        for (Node node : Hudson.getInstance().getNodes()) {
            Label l = project.getAssignedLabel();
            if (l != null && !l.contains(node) || l == null && node.getMode() == Node.Mode.EXCLUSIVE || !this.isNodeOnline(node)) continue;
            buildNode = node;
            break;
        }
        return buildNode;
    }

    private boolean isNodeOnline(Node node) {
        return node != null && node.toComputer() != null && node.toComputer().isOnline();
    }

    private Boolean needToBuild(Workspace p4workspace, AbstractProject project, Depot depot, PrintStream logger) throws IOException, InterruptedException, PerforceException {
        Run lastBuild = project.getLastBuild();
        if (lastBuild == null) {
            logger.println("No previous build exists.");
            return Boolean.FALSE;
        }
        PerforceTagAction action = (PerforceTagAction)lastBuild.getAction(PerforceTagAction.class);
        if (action == null) {
            logger.println("Previous build doesn't have Perforce info.");
            return null;
        }
        int lastChangeNumber = action.getChangeNumber();
        String lastLabelName = action.getTag();
        if (lastChangeNumber <= 0 && lastLabelName != null) {
            logger.println("Previous build was based on label " + lastLabelName);
            if (this.p4Label == null) {
                logger.println("Job configuration changed to build from head, not a label.");
                return Boolean.TRUE;
            }
            if (!lastLabelName.equals(this.p4Label)) {
                logger.println("Job configuration changed to build from label " + this.p4Label + ", not from head");
                return Boolean.TRUE;
            }
            logger.println("Assuming that the workspace and label definitions have not changed.");
            return Boolean.FALSE;
        }
        if (lastChangeNumber > 0) {
            List<Integer> changeNumbers;
            int highestSelectedChangeNumber;
            logger.println("Last sync'd change was " + lastChangeNumber);
            if (this.p4Label != null) {
                logger.println("Job configuration changed to build from label " + this.p4Label + ", not from head.");
                return Boolean.TRUE;
            }
            if (this.p4Counter != null && !this.updateCounterValue) {
                Counter counter = depot.getCounters().getCounter(this.p4Counter);
                highestSelectedChangeNumber = counter.getValue();
                logger.println("Latest submitted change selected by named counter is " + highestSelectedChangeNumber);
                String root = "//" + p4workspace.getName() + "/...";
                changeNumbers = depot.getChanges().getChangeNumbersInRange(p4workspace, lastChangeNumber + 1, highestSelectedChangeNumber, root);
            } else {
                Counter counter = depot.getCounters().getCounter("change");
                Integer newestChange = counter.getValue();
                if (this.useViewMaskForPolling && this.useViewMask) {
                    changeNumbers = depot.getChanges().getChangeNumbersInRange(p4workspace, lastChangeNumber + 1, newestChange, PerforceSCM.substituteParameters(this.viewMask, this.getDefaultSubstitutions(project)));
                } else {
                    String root = "//" + p4workspace.getName() + "/...";
                    changeNumbers = depot.getChanges().getChangeNumbersInRange(p4workspace, lastChangeNumber + 1, newestChange, root);
                }
                if (changeNumbers.isEmpty()) {
                    logger.println("No changes found.");
                    return Boolean.FALSE;
                }
                highestSelectedChangeNumber = changeNumbers.get(0);
                logger.println("Latest submitted change selected by workspace is " + highestSelectedChangeNumber);
            }
            if (lastChangeNumber >= highestSelectedChangeNumber) {
                logger.println("Assuming that the workspace definition has not changed.");
                return Boolean.FALSE;
            }
            for (int changeNumber : changeNumbers) {
                if (this.isChangelistExcluded(depot.getChanges().getChangelist(changeNumber), logger)) {
                    logger.println("Changelist " + changeNumber + " is composed of file(s) and/or user(s) that are excluded.");
                    continue;
                }
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    private boolean isChangelistExcluded(Changelist changelist, PrintStream logger) {
        if (changelist == null) {
            return false;
        }
        if (this.excludedUsers != null && !this.excludedUsers.trim().equals("")) {
            List<String> users = Arrays.asList(this.excludedUsers.split("\n"));
            if (users.contains(changelist.getUser())) {
                logger.println("Excluded User [" + changelist.getUser() + "] found in changelist.");
                return true;
            }
            for (String regex : users) {
                try {
                    Matcher matcher = Pattern.compile(regex).matcher(changelist.getUser());
                    if (!matcher.find()) continue;
                    logger.println("Excluded User [" + changelist.getUser() + "] found in changelist.");
                    return true;
                }
                catch (PatternSyntaxException pse) {
                    break;
                }
            }
        }
        if (this.excludedFiles != null && !this.excludedFiles.trim().equals("")) {
            List<String> files = Arrays.asList(this.excludedFiles.split("\n"));
            StringBuffer buff = null;
            Object matcher = null;
            if (files.size() > 0 && changelist.getFiles().size() > 0) {
                for (Changelist.FileEntry f : changelist.getFiles()) {
                    if (!PerforceSCM.doesFilenameMatchAnyP4Pattern(f.getFilename(), files)) {
                        return false;
                    }
                    if (buff == null) {
                        buff = new StringBuffer("Exclude file(s) found:\n");
                    }
                    buff.append("\t" + f.getFilename());
                }
                logger.println(buff.toString());
                return true;
            }
        }
        return false;
    }

    private static boolean doesFilenameMatchAnyP4Pattern(String filename, List<String> patternStrings) {
        for (String patternString : patternStrings) {
            if (patternString.trim().equals("") || !PerforceSCM.doesFilenameMatchP4Pattern(filename, patternString)) continue;
            return true;
        }
        return false;
    }

    public static boolean doesFilenameMatchP4Pattern(String filename, String patternString) throws PatternSyntaxException {
        patternString = patternString.trim();
        filename = filename.trim();
        patternString = patternString.replaceAll("\\*", "[^/]*");
        Pattern pattern = Pattern.compile(patternString = patternString.replaceAll("\\.\\.\\.", ".*"));
        Matcher matcher = pattern.matcher(filename);
        return matcher.matches();
    }

    private boolean wouldSyncChangeWorkspace(AbstractProject project, Depot depot, PrintStream logger) throws IOException, InterruptedException, PerforceException {
        Workspaces workspaces = depot.getWorkspaces();
        String result = workspaces.syncDryRun().toString();
        if (result.startsWith("File(s) up-to-date.")) {
            logger.println("Workspace up-to-date.");
            return false;
        }
        logger.println("Workspace not up-to-date.");
        return true;
    }

    public int getLastChange(Run build) {
        if (this.firstChange > 0) {
            return this.firstChange;
        }
        PerforceTagAction action = this.getMostRecentTagAction(build);
        if (action == null) {
            return 0;
        }
        return action.getChangeNumber();
    }

    private PerforceTagAction getMostRecentTagAction(Run build) {
        if (build == null) {
            return null;
        }
        PerforceTagAction action = (PerforceTagAction)build.getAction(PerforceTagAction.class);
        if (action != null) {
            return action;
        }
        return this.getMostRecentTagAction(build.getPreviousBuild());
    }

    private Workspace getPerforceWorkspace(AbstractProject project, String projectPath, Depot depot, Node buildNode, AbstractBuild build, Launcher launcher, FilePath workspace, TaskListener listener, boolean dontChangeRoot) throws IOException, InterruptedException, PerforceException {
        List<String> mappingPairs;
        PrintStream log = listener.getLogger();
        String p4Client = build != null ? this.getEffectiveClientName(build) : this.getDefaultEffectiveClientName(project, buildNode, workspace);
        if (!this.nodeIsRemote(buildNode)) {
            log.print("Using master perforce client: ");
            log.println(p4Client);
        } else if (this.dontRenameClient) {
            log.print("Using shared perforce client: ");
            log.println(p4Client);
        } else {
            log.println("Using remote perforce client: " + p4Client);
        }
        depot.setClient(p4Client);
        Workspace p4workspace = depot.getWorkspaces().getWorkspace(p4Client);
        assert (p4workspace != null);
        boolean creatingNewWorkspace = p4workspace.isNew();
        if (!this.updateView && creatingNewWorkspace) {
            log.println("*** Perforce client workspace '" + p4Client + "' doesn't exist.");
            log.println("*** Please create it, or allow hudson to manage clients on it's own.");
            log.println("*** If the client name mentioned above is not what you expected, ");
            log.println("*** check your 'Client name format for slaves' advanced config option.");
            throw new AbortException("Error accessing perforce workspace.");
        }
        p4workspace.setName(p4Client);
        if (this.projectOptions != null) {
            p4workspace.setOptions(this.projectOptions);
        }
        if (this.lineEndValue != null && this.getAllLineEndChoices().contains(this.lineEndValue)) {
            p4workspace.setLineEnd(this.lineEndValue);
        }
        boolean isunix = true;
        if (launcher != null) {
            isunix = launcher.isUnix();
        }
        String localPath = p4workspace.getRoot();
        if (workspace != null) {
            localPath = this.getLocalPathName(workspace, isunix);
        }
        if (!(localPath.equals(p4workspace.getRoot()) || dontChangeRoot || this.dontUpdateClient)) {
            log.println("Changing P4 Client Root to: " + localPath);
            this.forceSync = true;
            p4workspace.setRoot(localPath);
        }
        if ((this.updateView || creatingNewWorkspace) && !PerforceSCM.equalsProjectPath(mappingPairs = PerforceSCM.parseProjectPath(projectPath, p4Client), p4workspace.getViews())) {
            log.println("Changing P4 Client View from:\n" + p4workspace.getViewsAsString());
            log.println("Changing P4 Client View to: ");
            p4workspace.clearViews();
            int i = 0;
            while (i < mappingPairs.size()) {
                String depotPath = mappingPairs.get(i++);
                String clientPath = mappingPairs.get(i++);
                p4workspace.addView(" " + depotPath + " " + clientPath);
                log.println("  " + depotPath + " " + clientPath);
            }
        }
        p4workspace.setHost("");
        return p4workspace;
    }

    private String getEffectiveClientName(AbstractBuild build) {
        Node buildNode = build.getBuiltOn();
        FilePath workspace = build.getWorkspace();
        String p4Client = this.p4Client;
        p4Client = PerforceSCM.substituteParameters(p4Client, build);
        try {
            p4Client = this.getEffectiveClientName(p4Client, buildNode);
        }
        catch (Exception e) {
            new StreamTaskListener(System.out).getLogger().println("Could not get effective client name: " + e.getMessage());
        }
        return p4Client;
    }

    private String getDefaultEffectiveClientName(AbstractProject project, Node buildNode, FilePath workspace) throws IOException, InterruptedException {
        String basename = PerforceSCM.substituteParameters(this.p4Client, this.getDefaultSubstitutions(project));
        return this.getEffectiveClientName(basename, buildNode);
    }

    private String getEffectiveClientName(String basename, Node buildNode) throws IOException, InterruptedException {
        String p4Client = basename;
        if (this.nodeIsRemote(buildNode) && !this.getSlaveClientNameFormat().equals("")) {
            String host = null;
            Computer c = buildNode.toComputer();
            if (c != null) {
                host = c.getHostName();
            }
            if (host == null) {
                LOGGER.log(Level.WARNING, "Could not get hostname for slave " + buildNode.getDisplayName());
                host = "UNKNOWNHOST";
            }
            if (host.contains(".")) {
                host = String.valueOf(host.subSequence(0, host.indexOf(46)));
            }
            String hash = String.valueOf(buildNode.getNodeName().hashCode());
            Hashtable<String, String> substitutions = new Hashtable<String, String>();
            substitutions.put("hostname", host);
            substitutions.put("hash", hash);
            substitutions.put("basename", basename);
            p4Client = PerforceSCM.substituteParameters(this.getSlaveClientNameFormat(), substitutions);
        }
        return p4Client;
    }

    public String getSlaveClientNameFormat() {
        if (this.slaveClientNameFormat == null || this.slaveClientNameFormat.equals("")) {
            this.slaveClientNameFormat = this.dontRenameClient ? "${basename}" : (this.useOldClientName ? "${basename}-${hostname}" : "${basename}-${hash}");
        }
        return this.slaveClientNameFormat;
    }

    private boolean nodeIsRemote(Node buildNode) {
        return buildNode != null && buildNode.getNodeName().length() != 0;
    }

    private void saveWorkspaceIfDirty(Depot depot, Workspace p4workspace, PrintStream log) throws PerforceException {
        if (this.dontUpdateClient) {
            log.println("'Don't update client' is set. Not saving the client changes.");
            return;
        }
        if (p4workspace.isNew()) {
            log.println("Saving new client " + p4workspace.getName());
            depot.getWorkspaces().saveWorkspace(p4workspace);
        } else if (p4workspace.isDirty()) {
            log.println("Saving modified client " + p4workspace.getName());
            depot.getWorkspaces().saveWorkspace(p4workspace);
        }
    }

    static List<String> parseProjectPath(String projectPath, String p4Client) {
        ArrayList<String> parsed = new ArrayList<String>();
        for (String line : projectPath.split("\n")) {
            Matcher depotOnly = DEPOT_ONLY.matcher(line);
            if (depotOnly.find()) {
                parsed.add(line.trim());
                parsed.add("//" + p4Client + depotOnly.group(1));
                continue;
            }
            Matcher depotOnlyQuoted = DEPOT_ONLY_QUOTED.matcher(line);
            if (depotOnlyQuoted.find()) {
                parsed.add(line.trim());
                parsed.add("\"//" + p4Client + depotOnlyQuoted.group(1) + "\"");
                continue;
            }
            Matcher depotAndWorkspace = DEPOT_AND_WORKSPACE.matcher(line);
            if (depotAndWorkspace.find()) {
                parsed.add(depotAndWorkspace.group(1));
                parsed.add("//" + p4Client + depotAndWorkspace.group(2));
                continue;
            }
            Matcher depotAndWorkspaceQuoted = DEPOT_AND_WORKSPACE_QUOTED.matcher(line);
            if (depotAndWorkspaceQuoted.find()) {
                parsed.add("\"" + depotAndWorkspaceQuoted.group(1) + "\"");
                parsed.add("\"//" + p4Client + depotAndWorkspaceQuoted.group(2) + "\"");
                continue;
            }
            Matcher depotAndQuotedWorkspace = DEPOT_AND_QUOTED_WORKSPACE.matcher(line);
            if (!depotAndQuotedWorkspace.find()) continue;
            parsed.add(depotAndQuotedWorkspace.group(1));
            parsed.add("\"//" + p4Client + depotAndQuotedWorkspace.group(2) + "\"");
        }
        return parsed;
    }

    static String substituteParameters(String string, AbstractBuild build) {
        Hashtable<String, String> subst = new Hashtable<String, String>();
        subst.put("JOB_NAME", build.getProject().getFullName());
        String hudsonName = Hudson.getInstance().getDisplayName().toLowerCase();
        subst.put("BUILD_TAG", hudsonName + "-" + build.getProject().getName() + "-" + String.valueOf(build.getNumber()));
        subst.put("BUILD_ID", build.getId());
        subst.put("BUILD_NUMBER", String.valueOf(build.getNumber()));
        String result = PerforceSCM.substituteParameters(string, build.getBuildVariables());
        result = PerforceSCM.substituteParameters(result, subst);
        return result;
    }

    static String substituteParameters(String string, Map<String, String> subst) {
        if (string == null) {
            return null;
        }
        String newString = string;
        for (Map.Entry<String, String> entry : subst.entrySet()) {
            newString = newString.replace("${" + entry.getKey() + "}", entry.getValue());
        }
        return newString;
    }

    static boolean equalsProjectPath(List<String> pairs, List<String> lines) {
        Iterator<String> pi = pairs.iterator();
        for (String line : lines) {
            if (!pi.hasNext()) {
                return false;
            }
            String p1 = pi.next();
            String p2 = pi.next();
            if (line.trim().equals(p1.trim() + " " + p2.trim())) continue;
            return false;
        }
        return !pi.hasNext();
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public void setProjectPath(String projectPath) {
        this.projectPath = projectPath;
    }

    public String getP4User() {
        return this.p4User;
    }

    public void setP4User(String user) {
        this.p4User = user;
    }

    public String getP4Passwd() {
        return this.p4Passwd;
    }

    public void setP4Passwd(String passwd) {
        PerforcePasswordEncryptor encryptor = new PerforcePasswordEncryptor();
        this.p4Passwd = encryptor.appearsToBeAnEncryptedPassword(passwd) ? passwd : encryptor.encryptString(passwd);
    }

    public String getP4Port() {
        return this.p4Port;
    }

    public void setP4Port(String port) {
        this.p4Port = port;
    }

    public String getP4Client() {
        return this.p4Client;
    }

    public void setP4Client(String client) {
        this.p4Client = client;
    }

    public String getP4SysDrive() {
        return this.p4SysDrive;
    }

    public void setP4SysDrive(String sysDrive) {
        this.p4SysDrive = sysDrive;
    }

    public String getP4SysRoot() {
        return this.p4SysRoot;
    }

    public void setP4SysRoot(String sysRoot) {
        this.p4SysRoot = sysRoot;
    }

    public String getP4Exe() {
        return this.p4Exe;
    }

    public void setP4Exe(String exe) {
        this.p4Exe = exe;
    }

    public String getP4Label() {
        return this.p4Label;
    }

    public void setP4Label(String label) {
        this.p4Label = label;
    }

    public String getP4Counter() {
        return this.p4Counter;
    }

    public void setP4Counter(String counter) {
        this.p4Counter = counter;
    }

    public boolean isUpdateCounterValue() {
        return this.updateCounterValue;
    }

    public void setUpdateCounterValue(boolean updateCounterValue) {
        this.updateCounterValue = updateCounterValue;
    }

    public boolean isExposeP4Passwd() {
        return this.exposeP4Passwd;
    }

    public void setExposeP4Passwd(boolean exposeP4Passwd) {
        this.exposeP4Passwd = exposeP4Passwd;
    }

    public String getProjectOptions() {
        return this.projectOptions;
    }

    public void setProjectOptions(String projectOptions) {
        this.projectOptions = projectOptions;
    }

    public void setUpdateView(boolean update) {
        this.updateView = update;
    }

    public boolean isUpdateView() {
        return this.updateView;
    }

    public boolean isForceSync() {
        return this.forceSync;
    }

    public boolean isAlwaysForceSync() {
        return this.alwaysForceSync;
    }

    public boolean isDisableAutoSync() {
        return this.disableAutoSync;
    }

    public boolean isUseOldClientName() {
        return this.useOldClientName;
    }

    public void setForceSync(boolean force) {
        this.forceSync = force;
    }

    public void setAlwaysForceSync(boolean force) {
        this.alwaysForceSync = force;
    }

    public void setDisableAutoSync(boolean disable) {
        this.disableAutoSync = disable;
    }

    public void setUseOldClientName(boolean use) {
        this.useOldClientName = use;
    }

    public boolean isUseLabel() {
        return this.p4Label != null;
    }

    public void setDontRenameClient(boolean dontRenameClient) {
        this.dontRenameClient = dontRenameClient;
    }

    public boolean isDontRenameClient() {
        return this.dontRenameClient;
    }

    public boolean isWipeBeforeBuild() {
        return this.wipeBeforeBuild;
    }

    public boolean isWipeRepoBeforeBuild() {
        return this.wipeRepoBeforeBuild;
    }

    public void setSlaveClientNameFormat(String clientFormat) {
        this.slaveClientNameFormat = clientFormat;
    }

    public void setWipeBeforeBuild(boolean wipeBeforeBuild) {
        this.wipeBeforeBuild = wipeBeforeBuild;
    }

    public boolean isDontUpdateClient() {
        return this.dontUpdateClient;
    }

    public void setDontUpdateClient(boolean dontUpdateClient) {
        this.dontUpdateClient = dontUpdateClient;
    }

    public boolean isUseViewMaskForPolling() {
        return this.useViewMaskForPolling;
    }

    public void setUseViewMaskForPolling(boolean useViewMaskForPolling) {
        this.useViewMaskForPolling = useViewMaskForPolling;
    }

    public boolean isUseViewMaskForSyncing() {
        return this.useViewMaskForSyncing;
    }

    public void setUseViewMaskForSyncing(boolean useViewMaskForSyncing) {
        this.useViewMaskForSyncing = useViewMaskForSyncing;
    }

    public String getViewMask() {
        return this.viewMask;
    }

    public void setViewMask(String viewMask) {
        this.viewMask = viewMask;
    }

    public boolean isUseViewMask() {
        return this.useViewMask;
    }

    public void setUseViewMask(boolean useViewMask) {
        this.useViewMask = useViewMask;
    }

    public String getP4Charset() {
        return this.p4Charset;
    }

    public void setP4Charset(String p4Charset) {
        this.p4Charset = p4Charset;
    }

    public String getP4CommandCharset() {
        return this.p4CommandCharset;
    }

    public void setP4CommandCharset(String p4CommandCharset) {
        this.p4CommandCharset = p4CommandCharset;
    }

    public String getLineEndValue() {
        return this.lineEndValue;
    }

    public void setLineEndValue(String lineEndValue) {
        this.lineEndValue = lineEndValue;
    }

    public boolean isDisableSyncOnly() {
        return this.disableSyncOnly;
    }

    public void setDisableSyncOnly(boolean disableSyncOnly) {
        this.disableSyncOnly = disableSyncOnly;
    }

    public String getExcludedUsers() {
        return this.excludedUsers;
    }

    public void setExcludedUsers(String users) {
        this.excludedUsers = users;
    }

    public String getExcludedFiles() {
        return this.excludedFiles;
    }

    public void setExcludedFiles(String files) {
        this.excludedFiles = files;
    }

    public boolean isPollOnlyOnMaster() {
        return this.pollOnlyOnMaster;
    }

    public void setPollOnlyOnMaster(boolean pollOnlyOnMaster) {
        this.pollOnlyOnMaster = pollOnlyOnMaster;
    }

    public List<String> getAllLineEndChoices() {
        List<String> allChoices = ((PerforceSCMDescriptor)this.getDescriptor()).getAllLineEndChoices();
        ArrayList<String> choices = new ArrayList<String>();
        choices.add(this.lineEndValue);
        for (String choice : allChoices) {
            if (choice.equals(this.lineEndValue)) continue;
            choices.add(choice);
        }
        return choices;
    }

    public String getFirstChange() {
        if (this.firstChange <= 0) {
            return "";
        }
        return Integer.valueOf(this.firstChange).toString();
    }

    public boolean processWorkspaceBeforeDeletion(AbstractProject<?, ?> project, FilePath workspace, Node node) {
        Logger perforceLogger = Logger.getLogger(PerforceSCM.class.getName());
        perforceLogger.info("Workspace is being deleted; enabling one-time force sync.");
        LogTaskListener loglistener = new LogTaskListener(perforceLogger, Level.INFO);
        PrintStream log = loglistener.getLogger();
        StreamTaskListener listener = new StreamTaskListener(log);
        Launcher launcher = node.createLauncher((TaskListener)listener);
        Depot depot = this.getDepot(launcher, workspace, project);
        try {
            Workspace p4workspace = this.getPerforceWorkspace(project, PerforceSCM.substituteParameters(this.projectPath, this.getDefaultSubstitutions(project)), depot, node, null, null, workspace, (TaskListener)listener, this.dontRenameClient);
            this.saveWorkspaceIfDirty(depot, p4workspace, log);
            depot.getWorkspaces().flushTo("//" + p4workspace.getName() + "/...#0");
        }
        catch (Exception ex) {
            Logger.getLogger(PerforceSCM.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        return true;
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    public boolean isSlaveClientNameStatic() {
        Hashtable<String, String> testSub1 = new Hashtable<String, String>();
        testSub1.put("hostname", "HOSTNAME1");
        testSub1.put("hash", "HASH1");
        testSub1.put("basename", this.p4Client);
        String result1 = PerforceSCM.substituteParameters(this.getSlaveClientNameFormat(), testSub1);
        Hashtable<String, String> testSub2 = new Hashtable<String, String>();
        testSub2.put("hostname", "HOSTNAME2");
        testSub2.put("hash", "HASH2");
        testSub2.put("basename", this.p4Client);
        String result2 = PerforceSCM.substituteParameters(this.getSlaveClientNameFormat(), testSub2);
        return result1.equals(result2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GetHostname
    implements FilePath.FileCallable<String> {
        private static final long serialVersionUID = 1L;

        private GetHostname() {
        }

        public String invoke(File f, VirtualChannel channel) throws IOException {
            return InetAddress.getLocalHost().getHostName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PerforceSCMDescriptor
    extends SCMDescriptor<PerforceSCM> {
        public PerforceSCMDescriptor() {
            super(PerforceSCM.class, PerforceRepositoryBrowser.class);
            this.load();
        }

        public String getDisplayName() {
            return "Perforce";
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            PerforceSCM newInstance = (PerforceSCM)super.newInstance(req, formData);
            newInstance.setUseViewMask(req.getParameter("p4.useViewMask") != null);
            newInstance.setViewMask(Util.fixEmptyAndTrim((String)req.getParameter("p4.viewMask")));
            newInstance.setUseViewMaskForPolling(req.getParameter("p4.useViewMaskForPolling") != null);
            newInstance.setUseViewMaskForSyncing(req.getParameter("p4.useViewMaskForSyncing") != null);
            return newInstance;
        }

        public String isValidProjectPath(String path) {
            if (!path.startsWith("//")) {
                return "Path must start with '//' (Example: //depot/ProjectName/...)";
            }
            if (!path.endsWith("/...") && !path.contains("@")) {
                return "Path must end with Perforce wildcard: '/...'  (Example: //depot/ProjectName/...)";
            }
            return null;
        }

        protected Depot getDepotFromRequest(StaplerRequest request) {
            String port = Util.fixNull((String)request.getParameter("port")).trim();
            String exe = Util.fixNull((String)request.getParameter("exe")).trim();
            String user = Util.fixNull((String)request.getParameter("user")).trim();
            String pass = Util.fixNull((String)request.getParameter("pass")).trim();
            if (port.length() == 0 || exe.length() == 0) {
                return null;
            }
            Depot depot = new Depot();
            depot.setUser(user);
            PerforcePasswordEncryptor encryptor = new PerforcePasswordEncryptor();
            if (encryptor.appearsToBeAnEncryptedPassword(pass)) {
                depot.setPassword(encryptor.decryptString(pass));
            } else {
                depot.setPassword(pass);
            }
            depot.setPort(port);
            depot.setExecutable(exe);
            try {
                Counter counter = depot.getCounters().getCounter("change");
                if (counter != null) {
                    return depot;
                }
            }
            catch (PerforceException e) {
                // empty catch block
            }
            return null;
        }

        public FormValidation doValidatePerforceLogin(StaplerRequest req) {
            Depot depot = this.getDepotFromRequest(req);
            if (depot != null) {
                try {
                    depot.getStatus().isValid();
                }
                catch (PerforceException e) {
                    return FormValidation.error((String)e.getMessage());
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doValidateP4Client(StaplerRequest req) {
            Depot depot = this.getDepotFromRequest(req);
            if (depot == null) {
                return FormValidation.error((String)"Unable to check workspace against depot");
            }
            String workspace = Util.fixEmptyAndTrim((String)req.getParameter("client"));
            if (workspace == null) {
                return FormValidation.error((String)"You must enter a workspaces name");
            }
            try {
                Workspace p4Workspace = depot.getWorkspaces().getWorkspace(workspace);
                if (p4Workspace.getAccess() == null || p4Workspace.getAccess().equals("")) {
                    return FormValidation.warning((String)"Workspace does not exist. If \"Let Hudson Manage Workspace View\" is check the workspace will be automatically created.");
                }
            }
            catch (PerforceException e) {
                return FormValidation.error((String)"Error accessing perforce while checking workspace");
            }
            return FormValidation.ok();
        }

        public FormValidation doValidateP4Label(StaplerRequest req, @QueryParameter String label) throws IOException, ServletException {
            if ((label = Util.fixEmptyAndTrim((String)label)) == null) {
                return FormValidation.ok();
            }
            Depot depot = this.getDepotFromRequest(req);
            if (depot != null) {
                try {
                    com.tek42.perforce.model.Label p4Label = depot.getLabels().getLabel(label);
                    if (p4Label.getAccess() == null || p4Label.getAccess().equals("")) {
                        return FormValidation.error((String)"Label does not exist");
                    }
                }
                catch (PerforceException e) {
                    return FormValidation.error((String)"Error accessing perforce while checking label");
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doValidateP4Counter(StaplerRequest req, @QueryParameter String counter) throws IOException, ServletException {
            if ((counter = Util.fixEmptyAndTrim((String)counter)) == null) {
                return FormValidation.ok();
            }
            Depot depot = this.getDepotFromRequest(req);
            if (depot != null) {
                try {
                    Counters counters = depot.getCounters();
                    Counter p4Counter = counters.getCounter(counter);
                    counters.saveCounter(p4Counter);
                }
                catch (PerforceException e) {
                    return FormValidation.error((String)("Error accessing perforce while checking counter: " + e.getLocalizedMessage()));
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckProjectPath(@QueryParameter String value) throws IOException, ServletException {
            String view = Util.fixEmptyAndTrim((String)value);
            if (view != null) {
                for (String mapping : view.replace("\r", "").split("\n")) {
                    if (DEPOT_ONLY.matcher(mapping).matches() || DEPOT_AND_WORKSPACE.matcher(mapping).matches() || DEPOT_ONLY_QUOTED.matcher(mapping).matches() || DEPOT_AND_WORKSPACE_QUOTED.matcher(mapping).matches() || DEPOT_AND_QUOTED_WORKSPACE.matcher(mapping).matches() || COMMENT.matcher(mapping).matches()) continue;
                    return FormValidation.error((String)("Invalid mapping:" + mapping));
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckViewMask(StaplerRequest req) {
            String view = Util.fixEmptyAndTrim((String)req.getParameter("viewMask"));
            if (view != null) {
                for (String path : view.replace("\r", "").split("\n")) {
                    if (path.startsWith("-") || path.startsWith("\"-")) {
                        return FormValidation.error((String)("'-' not yet supported in view mask:" + path));
                    }
                    if (DEPOT_ONLY.matcher(path).matches() || DEPOT_ONLY_QUOTED.matcher(path).matches()) continue;
                    return FormValidation.error((String)("Invalid depot path:" + path));
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckChangeList(StaplerRequest req) {
            Depot depot = this.getDepotFromRequest(req);
            String change = Util.fixNull((String)req.getParameter("change")).trim();
            if (change.length() == 0) {
                return FormValidation.ok();
            }
            if (depot != null) {
                try {
                    int number = Integer.parseInt(change);
                    Changelist changelist = depot.getChanges().getChangelist(number);
                    if (changelist.getChangeNumber() != number) {
                        throw new PerforceException("broken");
                    }
                }
                catch (Exception e) {
                    return FormValidation.error((String)("Changelist: " + change + " does not exist."));
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doValidateExcludedUsers(StaplerRequest req) {
            String excludedUsers = Util.fixNull((String)req.getParameter("excludedUsers")).trim();
            List<String> users = Arrays.asList(excludedUsers.split("\n"));
            for (String regex : users) {
                if ((regex = regex.trim()).equals("")) continue;
                try {
                    Pattern.compile(regex);
                }
                catch (PatternSyntaxException pse) {
                    return FormValidation.error((String)("Invalid regular express [" + regex + "]: " + pse.getMessage()));
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doValidateExcludedFiles(StaplerRequest req) {
            String excludedFiles = Util.fixNull((String)req.getParameter("excludedFiles")).trim();
            List<String> files = Arrays.asList(excludedFiles.split("\n"));
            for (String file : files) {
                if ((file = file.trim()).equals("")) continue;
                if (!DEPOT_ONLY.matcher(file).matches() && !DEPOT_ONLY_QUOTED.matcher(file).matches()) {
                    return FormValidation.error((String)("Invalid file spec [" + file + "]: Not a perforce file spec."));
                }
                try {
                    PerforceSCM.doesFilenameMatchP4Pattern("somefile", file);
                }
                catch (PatternSyntaxException pse) {
                    return FormValidation.error((String)("Invalid file spec [" + file + "]: " + pse.getMessage()));
                }
            }
            return FormValidation.ok();
        }

        public List<String> getAllLineEndChoices() {
            List<String> allChoices = Arrays.asList("local", "unix", "mac", "win", "share");
            ArrayList<String> choices = new ArrayList<String>();
            for (String choice : allChoices) {
                choices.add(choice);
            }
            return choices;
        }

        public String getAppName() {
            return Hudson.getInstance().getDisplayName();
        }
    }

    private static class WipeWorkspaceFilter
    implements FileFilter,
    Serializable {
        private WipeWorkspaceFilter() {
        }

        public boolean accept(File arg0) {
            return !arg0.getName().equals(".repository");
        }
    }
}

