/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.api;

import com.perforce.api.CommitException;
import com.perforce.api.Debug;
import com.perforce.api.Env;
import com.perforce.api.HashDecay;
import com.perforce.api.Mapping;
import com.perforce.api.P4Process;
import com.perforce.api.PerforceException;
import com.perforce.api.Utils;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class Label
extends Mapping {
    private static HashDecay labels = null;

    public Label() {
        this.getCache();
    }

    public Label(String name) {
        this();
        this.setName(name);
    }

    private static synchronized HashDecay setCache() {
        if (null == labels) {
            labels = new HashDecay(1200000L);
            labels.start();
        }
        return labels;
    }

    public HashDecay getCache() {
        return Label.setCache();
    }

    public static Enumeration lookupLabels(String prefix) {
        return Label.lookupMappings(labels, prefix);
    }

    public static Enumeration lookupLabels(Env env, String prefix) {
        Label.loadLabels(env);
        return Label.lookupMappings(labels, prefix);
    }

    public static void loadLabels() {
        Label.loadLabels(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLabels(Env env) {
        String[] cmd = new String[]{"p4", "labels"};
        Label.setCache();
        try {
            String l;
            P4Process p = new P4Process(env);
            p.exec(cmd);
            while (null != (l = p.readLine())) {
                Label b;
                StringTokenizer st;
                if (!l.startsWith("Label") || 6 > (st = new StringTokenizer(l)).countTokens()) continue;
                st.nextToken();
                String name = st.nextToken();
                HashDecay hashDecay = labels;
                synchronized (hashDecay) {
                    b = (Label)labels.get(name);
                    if (null != b) {
                        b.refreshUpdateTime();
                        continue;
                    }
                    b = new Label(name);
                    b.setEnv(env);
                }
                st.nextToken();
                st.nextToken("'");
                b.setDescription(st.nextToken());
                labels.put((Object)b.getName(), b);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Enumeration getLabelNames(Env env) {
        Label.loadLabels(env);
        return labels.keys();
    }

    public static Enumeration getLabels() {
        return Label.getLabels(null);
    }

    public static Enumeration getLabels(Env env) {
        return Utils.getEnumeration(Label.getLabelIterator(env));
    }

    public static Iterator getLabelIterator(Env env) {
        Label.loadLabels(env);
        Enumeration en = labels.elements();
        TreeSet ts = new TreeSet();
        while (en.hasMoreElements()) {
            ts.add(en.nextElement());
        }
        return ts.iterator();
    }

    public static synchronized Label getLabel(String name) {
        return Label.getLabel(null, name, true);
    }

    public static synchronized Label getLabel(Env env, String name, boolean force) {
        if (null == name || name.trim().equals("")) {
            return null;
        }
        Label b = (Label)Label.setCache().get(name);
        if (null == b) {
            b = new Label(name);
        }
        if (null != env) {
            b.setEnv(env);
        }
        b.sync();
        labels.put((Object)name, b);
        return b;
    }

    public void store() throws CommitException {
        this.commit();
    }

    public void commit() throws CommitException {
        String[] cmd = new String[]{"p4", "label", "-i"};
        try {
            String l;
            P4Process p = new P4Process(this.getEnv());
            p.exec(cmd);
            while (null != (l = p.readLine())) {
                p.println("Label: " + this.getName());
                p.println("Owner: " + this.getOwner());
                if (null != this.getDescription()) {
                    p.println("Description:\n" + this.getDescription());
                }
                p.println("View:");
                Enumeration en = this.getViews();
                while (en.hasMoreElements()) {
                    p.println((String)en.nextElement());
                }
                p.println("");
                p.flush();
                p.outClose();
                while (null != (l = p.readLine())) {
                }
                p.close();
            }
        }
        catch (Exception ex) {
            throw new CommitException(ex.getMessage());
        }
    }

    public void sync() {
        this.sync(this.getName());
    }

    public void sync(String name) {
        if (!this.outOfSync(300000L)) {
            return;
        }
        this.setName(name);
        String description = "";
        String[] cmd = new String[]{"p4", "label", "-o", "name"};
        cmd[3] = name;
        try {
            String l;
            P4Process p = new P4Process(this.getEnv());
            p.exec(cmd);
            while (null != (l = p.readLine())) {
                if (l.startsWith("#")) continue;
                if (l.startsWith("Label:")) {
                    this.setName(l.substring(8).trim());
                    continue;
                }
                if (l.startsWith("Owner:")) {
                    this.setOwner(l.substring(7).trim());
                    continue;
                }
                if (l.startsWith("Description:")) {
                    while (null != (l = p.readLine()) && l.startsWith("\t")) {
                        description = description + l + "\n";
                    }
                    this.setDescription(description);
                    continue;
                }
                if (!l.startsWith("View:")) continue;
                while (null != (l = p.readLine()) && (l.startsWith("\t") || l.startsWith(" ") || l.startsWith("//"))) {
                    this.addView(l);
                }
            }
            p.close();
            this.inSync();
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer("<label name=\"");
        sb.append(this.getName());
        sb.append("\" owner=\"");
        sb.append(this.getOwner());
        sb.append("\">");
        sb.append(super.toXML());
        sb.append("</label>");
        return sb.toString();
    }

    public static void main(String[] args) {
        String propfile = "/etc/p4.conf";
        Env environ = null;
        Enumeration labels = null;
        Label lbl = null;
        Debug.setDebugLevel(99);
        if (0 < args.length) {
            propfile = args[0];
        }
        try {
            environ = new Env(propfile);
        }
        catch (PerforceException ex) {
            System.out.println("Could not load properties from " + propfile + ": " + ex);
            System.exit(-1);
        }
        System.out.println(environ);
        labels = Label.getLabels(environ);
        while (labels.hasMoreElements()) {
            lbl = (Label)labels.nextElement();
            System.out.println(lbl.getName());
        }
        Utils.cleanUp();
    }
}

