/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce;

import com.tek42.perforce.model.Changelist;
import hudson.model.User;
import hudson.plugins.perforce.PerforceChangeLogSet;
import hudson.scm.ChangeLogSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerforceChangeLogEntry
extends ChangeLogSet.Entry {
    Changelist change;

    public PerforceChangeLogEntry(PerforceChangeLogSet parent) {
        this.setParent(parent);
    }

    @Exported
    public User getAuthor() {
        return User.get((String)this.change.getUser());
    }

    @Exported
    public Collection<String> getAffectedPaths() {
        ArrayList<String> paths = new ArrayList<String>(this.change.getFiles().size());
        for (Changelist.FileEntry entry : this.change.getFiles()) {
            paths.add(entry.getFilename());
        }
        return paths;
    }

    @Exported
    public String getMsg() {
        return this.change.getDescription();
    }

    @Exported
    public String getChangeNumber() {
        return new Integer(this.getChange().getChangeNumber()).toString();
    }

    @Exported
    public String getChangeTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(this.getChange().getDate());
    }

    public Changelist getChange() {
        return this.change;
    }

    public void setChange(Changelist change) {
        this.change = change;
    }
}

