/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce;

import com.tek42.perforce.model.User;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.perforce.PerforceSCM;
import hudson.tasks.MailAddressResolver;
import hudson.util.StreamTaskListener;

public class PerforceMailResolver
extends MailAddressResolver {
    public String findMailAddressFor(hudson.model.User u) {
        for (AbstractProject p : u.getProjects()) {
            if (p.isDisabled() || !(p.getScm() instanceof PerforceSCM)) continue;
            PerforceSCM pscm = (PerforceSCM)p.getScm();
            StreamTaskListener listener = new StreamTaskListener(System.out);
            Node node = p.getLastBuiltOn();
            if (node.getChannel() == null) continue;
            for (int tries = 0; tries < 5; ++tries) {
                FilePath workspace = p.getLastBuiltOn().getRootPath();
                Launcher launcher = p.getLastBuiltOn().createLauncher((TaskListener)listener);
                User pu = null;
                try {
                    listener.getLogger().println("Trying to get email address from perforce for " + u.getId());
                    pu = pscm.getDepot(launcher, workspace).getUsers().getUser(u.getId());
                }
                catch (Exception e) {
                    listener.getLogger().println("Could not get email address from Perforce: " + e.getMessage());
                    e.printStackTrace(listener.getLogger());
                }
                if (pu != null && pu.getEmail() != null && !pu.getEmail().equals("")) {
                    listener.getLogger().println("Got email (" + pu.getEmail() + ") from perforce for " + u.getId());
                    return pu.getEmail();
                }
                try {
                    Thread.sleep(tries * 300);
                    continue;
                }
                catch (InterruptedException e) {
                    return null;
                }
            }
        }
        return null;
    }
}

