/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce;

import com.tek42.perforce.PerforceException;
import com.tek42.perforce.process.Executor;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.perforce.HudsonPipedOutputStream;
import hudson.util.StreamTaskListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HudsonP4Executor
implements Executor {
    private BufferedReader reader;
    private BufferedWriter writer;
    private Launcher hudsonLauncher;
    private String[] env;
    private FilePath filePath;

    HudsonP4Executor(Launcher hudsonLauncher, Map<String, String> envMap, FilePath filePath) {
        this.hudsonLauncher = hudsonLauncher;
        this.env = this.convertEnvMaptoArray(envMap);
        this.filePath = filePath;
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void exec(String[] cmd) throws PerforceException {
        try {
            if (null == this.hudsonLauncher) {
                this.hudsonLauncher = Hudson.getInstance().createLauncher((TaskListener)new StreamTaskListener(System.out));
            }
            HudsonPipedOutputStream hudsonOut = new HudsonPipedOutputStream();
            PipedInputStream p4in = new PipedInputStream(hudsonOut);
            this.reader = new BufferedReader(new InputStreamReader(p4in));
            PipedInputStream hudsonIn = new PipedInputStream();
            PipedOutputStream p4out = new PipedOutputStream(hudsonIn);
            this.writer = new BufferedWriter(new OutputStreamWriter(p4out));
            Proc process = this.hudsonLauncher.launch().cmds(cmd).envs(this.env).stdin((InputStream)hudsonIn).stdout((OutputStream)hudsonOut).pwd(this.filePath).start();
            hudsonOut.closeOnProcess(process);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String[] convertEnvMaptoArray(Map<String, String> envMap) {
        Set<String> keySet = envMap.keySet();
        String[] keys = keySet.toArray(new String[0]);
        String[] result = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            result[i] = keys[i] + "=" + envMap.get(keys[i]);
        }
        return result;
    }

    @Override
    public BufferedReader getReader() {
        return this.reader;
    }

    @Override
    public BufferedWriter getWriter() {
        return this.writer;
    }
}

