/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce;

import com.tek42.perforce.Depot;
import com.tek42.perforce.PerforceException;
import com.tek42.perforce.model.Changelist;
import com.tek42.perforce.model.Workspace;
import com.tek42.perforce.process.ExecutorFactory;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.perforce.HudsonP4ExecutorFactory;
import hudson.plugins.perforce.PerforceChangeLogParser;
import hudson.plugins.perforce.PerforceChangeLogSet;
import hudson.plugins.perforce.PerforceRepositoryBrowser;
import hudson.plugins.perforce.PerforceSCMHelper;
import hudson.plugins.perforce.PerforceTagAction;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.util.FormFieldValidator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerforceSCM
extends SCM {
    String p4User;
    String p4Passwd;
    String p4Port;
    String p4Client;
    String nodeSuffix;
    String projectPath;
    String p4Exe = "C:\\Program Files\\Perforce\\p4.exe";
    String p4SysDrive = "C:";
    String p4SysRoot = "C:\\WINDOWS";
    transient Depot depot;
    PerforceRepositoryBrowser browser;
    transient int lastChange;
    boolean forceSync = false;
    boolean updateView = true;
    int firstChange = -1;

    @DataBoundConstructor
    public PerforceSCM(String p4User, String p4Passwd, String p4Client, String p4Port, String projectPath, String p4Exe, String p4SysRoot, String p4SysDrive, boolean forceSync, boolean updateView, int firstChange, PerforceRepositoryBrowser browser) {
        this.p4User = p4User;
        this.p4Passwd = p4Passwd;
        this.p4Client = p4Client;
        this.p4Port = p4Port;
        this.projectPath = projectPath;
        if (p4Exe != null) {
            this.p4Exe = p4Exe;
        }
        if (p4SysRoot != null) {
            this.p4SysRoot = p4SysRoot;
        }
        if (p4SysDrive != null) {
            this.p4SysDrive = p4SysDrive;
        }
        this.forceSync = forceSync;
        this.browser = browser;
        this.updateView = updateView;
        this.firstChange = firstChange;
    }

    protected Depot getDepot(Launcher launcher, FilePath workspace) {
        HudsonP4ExecutorFactory p4Factory = new HudsonP4ExecutorFactory(launcher, workspace);
        this.depot = new Depot((ExecutorFactory)p4Factory);
        this.depot.setUser(this.p4User);
        this.depot.setPassword(this.p4Passwd);
        this.depot.setPort(this.p4Port);
        this.depot.setClient(this.p4Client + this.nodeSuffix);
        this.depot.setExecutable(this.p4Exe);
        this.depot.setSystemDrive(this.p4SysDrive);
        this.depot.setSystemRoot(this.p4SysRoot);
        return this.depot;
    }

    protected Depot getDepot() {
        return this.depot;
    }

    private void readObject(ObjectInputStream is) {
        try {
            is.defaultReadObject();
            this.depot = new Depot();
            this.depot.setUser(this.p4User);
            this.depot.setPassword(this.p4Passwd);
            this.depot.setPort(this.p4Port);
            this.depot.setClient(this.p4Client);
            this.depot.setExecutable(this.p4Exe);
            this.depot.setSystemDrive(this.p4SysDrive);
            this.depot.setSystemRoot(this.p4SysRoot);
        }
        catch (IOException exception) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        int lastChange = this.getLastChange((Run)build);
        env.put("P4_CHANGELIST", Integer.toString(lastChange));
    }

    private String getLocalPathName(FilePath path, boolean isUnix) throws IOException, InterruptedException {
        String uriString = path.toURI().toString();
        uriString = uriString.replaceAll("file:/", "");
        uriString = uriString.replaceAll("/./", "/");
        uriString = URLDecoder.decode(uriString, "UTF-8");
        uriString = isUnix ? "/" + uriString : uriString.replaceAll("/", "\\\\");
        return uriString;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        try {
            listener.getLogger().println("Performing sync with Perforce for: " + this.projectPath);
            boolean creatingNewWorkspace = false;
            this.nodeSuffix = null;
            if (build.getBuiltOnStr() != null) {
                String host = (String)workspace.act((FilePath.FileCallable)new GetHostname());
                this.nodeSuffix = host.contains(".") ? "-" + host.subSequence(0, host.indexOf(46)) : "-" + host;
                listener.getLogger().println("Changing client to " + this.p4Client + this.nodeSuffix);
                creatingNewWorkspace = true;
            }
            Workspace p4workspace = this.getDepot(launcher, workspace).getWorkspaces().getWorkspace(this.p4Client + this.nodeSuffix);
            p4workspace.setName(this.p4Client + this.nodeSuffix);
            assert (p4workspace != null);
            creatingNewWorkspace = p4workspace.getAccess() == null || p4workspace.getAccess().length() == 0;
            boolean usingLabel = this.projectPath.contains("@");
            String localPath = this.getLocalPathName(workspace, launcher.isUnix());
            listener.getLogger().println("Changing P4 Client Root to: " + localPath);
            p4workspace.setRoot(localPath);
            if (this.updateView || creatingNewWorkspace) {
                String view = this.projectPath + " //" + p4workspace.getName() + "/...";
                listener.getLogger().println("Changing P4 Client View to: " + view);
                p4workspace.clearViews();
                p4workspace.addView(view);
            }
            p4workspace.setHost("");
            if (!this.updateView && p4workspace.getViews().size() > 1 && !PerforceSCMHelper.projectPathIsValidForMultiviews(this.projectPath)) {
                throw new PerforceException("Unless you are using a label, the only project path currently supported when you have multiple workspace views is '//...'. Please revise your project path or P4 workspace accordingly.");
            }
            this.depot.getWorkspaces().saveWorkspace(p4workspace);
            int lastChange = this.getLastChange(build.getPreviousBuild());
            listener.getLogger().println("Last sync'd change: " + lastChange);
            List changes = usingLabel ? new ArrayList(0) : this.depot.getChanges().getChangelistsFromNumbers(this.depot.getChanges().getChangeNumbersTo(this.getChangesPaths(p4workspace), lastChange + 1));
            if (changes.size() > 0) {
                lastChange = ((Changelist)changes.get(0)).getChangeNumber();
                PerforceChangeLogSet.saveToChangeLog(new FileOutputStream(changelogFile), changes);
            } else if (usingLabel) {
                this.createEmptyChangeLog(changelogFile, listener, "changelog");
            } else if (!this.forceSync) {
                listener.getLogger().println("No changes since last build.  Syncing workspace.");
                this.depot.getWorkspaces().syncTo(this.projectPath + "@" + lastChange, this.forceSync);
                return this.createEmptyChangeLog(changelogFile, listener, "changelog");
            }
            long startTime = System.currentTimeMillis();
            listener.getLogger().println("Sync'ing workspace to depot.");
            if (this.forceSync) {
                listener.getLogger().println("ForceSync flag is set, forcing: p4 sync " + this.projectPath);
            }
            if (this.projectPath.contains("@")) {
                listener.getLogger().println("Label found in projectPath, NOT sync'ing to the head.");
                this.depot.getWorkspaces().syncTo(this.projectPath, this.forceSync);
            } else {
                this.depot.getWorkspaces().syncTo(this.projectPath + "@" + lastChange, this.forceSync);
            }
            this.forceSync = false;
            this.firstChange = -1;
            listener.getLogger().println("Sync complete, took " + (System.currentTimeMillis() - startTime) + " MS");
            if (!usingLabel) {
                build.addAction((Action)new PerforceTagAction(build, this.depot, lastChange, this.projectPath));
            }
            build.getParent().save();
            return true;
        }
        catch (PerforceException e) {
            listener.getLogger().print("Caught Exception communicating with perforce. " + e.getMessage());
            e.printStackTrace();
            throw new IOException("Unable to communicate with perforce. " + e.getMessage());
        }
        catch (InterruptedException e) {
            throw new IOException("Unable to get hostname from slave. " + e.getMessage());
        }
    }

    private String getChangesPaths(Workspace p4workspace) {
        String changesPath = p4workspace.getViews().size() > 1 ? PerforceSCMHelper.computePathFromViews(p4workspace.getViews()) : this.projectPath;
        return changesPath;
    }

    public PerforceRepositoryBrowser getBrowser() {
        return this.browser;
    }

    public ChangeLogParser createChangeLogParser() {
        return new PerforceChangeLogParser();
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        try {
            int lastChange = this.getLastChange(project.getLastBuild());
            listener.getLogger().println("Looking for changes...");
            Workspace p4workspace = this.getDepot(launcher, workspace).getWorkspaces().getWorkspace(this.p4Client);
            List changes = this.depot.getChanges().getChangeNumbersTo(this.getChangesPaths(p4workspace), lastChange + 1);
            listener.getLogger().println("Last sync'd change is : " + lastChange);
            if (changes.size() > 0) {
                listener.getLogger().println("New changes detected, triggering a build.");
                return true;
            }
            listener.getLogger().println("We have nothing to do.");
            return false;
        }
        catch (PerforceException e) {
            System.out.println("Problem: " + e.getMessage());
            listener.getLogger().println("Caught Exception communicating with perforce." + e.getMessage());
            e.printStackTrace();
            throw new IOException("Unable to communicate with perforce.  Check log file for: " + e.getMessage());
        }
    }

    public int getLastChange(Run build) {
        if (this.firstChange > 0) {
            return this.firstChange;
        }
        if (build == null) {
            return 0;
        }
        PerforceTagAction action = (PerforceTagAction)build.getAction(PerforceTagAction.class);
        if (action == null) {
            return this.getLastChange(build.getPreviousBuild());
        }
        return action.getChangeNumber();
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public void setProjectPath(String projectPath) {
        this.projectPath = projectPath;
    }

    public String getP4User() {
        return this.p4User;
    }

    public void setP4User(String user) {
        this.p4User = user;
    }

    public String getP4Passwd() {
        return this.p4Passwd;
    }

    public void setP4Passwd(String passwd) {
        this.p4Passwd = passwd;
    }

    public String getP4Port() {
        return this.p4Port;
    }

    public void setP4Port(String port) {
        this.p4Port = port;
    }

    public String getP4Client() {
        return this.p4Client;
    }

    public void setP4Client(String client) {
        this.p4Client = client;
    }

    public String getP4SysDrive() {
        return this.p4SysDrive;
    }

    public void setP4SysDrive(String sysDrive) {
        this.p4SysDrive = sysDrive;
    }

    public String getP4SysRoot() {
        return this.p4SysRoot;
    }

    public void setP4SysRoot(String sysRoot) {
        this.p4SysRoot = sysRoot;
    }

    public String getP4Exe() {
        return this.p4Exe;
    }

    public void setP4Exe(String exe) {
        this.p4Exe = exe;
    }

    public void setUpdateView(boolean update) {
        this.updateView = update;
    }

    public boolean isUpdateView() {
        return this.updateView;
    }

    public boolean isForceSync() {
        return this.forceSync;
    }

    public void setForceSync(boolean force) {
        this.forceSync = force;
    }

    public String getFirstChange() {
        if (this.firstChange < 0) {
            return "";
        }
        return new Integer(this.firstChange).toString();
    }

    public boolean processWorkspaceBeforeDeletion(AbstractProject<?, ?> project, FilePath workspace, Node node) {
        Logger.getLogger(PerforceSCM.class.getName()).info("Veto workspace cleanup");
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GetHostname
    implements FilePath.FileCallable<String> {
        private static final long serialVersionUID = 1L;

        private GetHostname() {
        }

        public String invoke(File f, VirtualChannel channel) throws IOException {
            return InetAddress.getLocalHost().getHostName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PerforceSCMDescriptor
    extends SCMDescriptor<PerforceSCM> {
        public PerforceSCMDescriptor() {
            super(PerforceSCM.class, PerforceRepositoryBrowser.class);
            this.load();
        }

        public String getDisplayName() {
            return "Perforce";
        }

        public String isValidProjectPath(String path) {
            if (!path.startsWith("//")) {
                return "Path must start with '//' (Example: //depot/ProjectName/...)";
            }
            if (!path.endsWith("/...") && !path.contains("@")) {
                return "Path must end with Perforce wildcard: '/...'  (Example: //depot/ProjectName/...)";
            }
            return null;
        }

        protected Depot getDepotFromRequest(StaplerRequest request) {
            String port = Util.fixNull((String)request.getParameter("port")).trim();
            String exe = Util.fixNull((String)request.getParameter("exe")).trim();
            String user = Util.fixNull((String)request.getParameter("user")).trim();
            String pass = Util.fixNull((String)request.getParameter("pass")).trim();
            if (port.length() == 0 || exe.length() == 0 || user.length() == 0 || pass.length() == 0) {
                return null;
            }
            Depot depot = new Depot();
            depot.setUser(user);
            depot.setPassword(pass);
            depot.setPort(port);
            depot.setExecutable(exe);
            return depot;
        }

        public void doValidatePerforceLogin(StaplerRequest request, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(request, rsp, false){

                protected void check() throws IOException, ServletException {
                    Depot depot = PerforceSCMDescriptor.this.getDepotFromRequest(this.request);
                    if (depot != null) {
                        try {
                            depot.getStatus().isValid();
                        }
                        catch (PerforceException e) {
                            this.error(e.getMessage());
                        }
                    }
                    this.ok();
                }
            }.check();
        }

        public void doValidateWorkspace(StaplerRequest request, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(request, rsp, false){

                protected void check() throws IOException, ServletException {
                    Depot depot = PerforceSCMDescriptor.this.getDepotFromRequest(this.request);
                    String workspace = this.request.getParameter("workspace");
                    if (depot != null) {
                        try {
                            depot.getWorkspaces().getWorkspace(workspace);
                        }
                        catch (PerforceException e) {
                            this.error(e.getMessage());
                        }
                    }
                    this.ok();
                }
            }.check();
        }

        public void doCheckProjectPath(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    String path = Util.fixNull((String)this.request.getParameter("value")).trim();
                    if (path.length() == 0) {
                        this.ok();
                        return;
                    }
                    this.error(PerforceSCMDescriptor.this.isValidProjectPath(path));
                }
            }.check();
        }

        public void doCheckChangeList(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    Depot depot = PerforceSCMDescriptor.this.getDepotFromRequest(this.request);
                    String change = Util.fixNull((String)this.request.getParameter("change")).trim();
                    if (change.length() == 0) {
                        this.ok();
                        return;
                    }
                    if (depot != null) {
                        try {
                            int number = new Integer(change);
                            Changelist changelist = depot.getChanges().getChangelist(number);
                            if (changelist.getChangeNumber() != number) {
                                throw new PerforceException("broken");
                            }
                        }
                        catch (Exception e) {
                            this.error("Changelist: " + change + " does not exist.");
                        }
                    }
                    this.ok();
                }
            }.check();
        }
    }
}

