/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mstest;

import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.mstest.MSTestReportConverter;
import hudson.plugins.mstest.MSTestTransformer;
import hudson.plugins.mstest.Messages;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.TestResultProjectAction;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.xml.transform.TransformerException;
import net.sf.json.JSONObject;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSTestPublisher
extends Recorder
implements Serializable {
    private String testResultsFile;

    public MSTestPublisher(String testResultsFile) {
        this.testResultsFile = testResultsFile;
    }

    public String getTestResultsTrxFile() {
        return this.testResultsFile;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        TestResultProjectAction action = (TestResultProjectAction)project.getAction(TestResultProjectAction.class);
        if (action == null) {
            return new TestResultProjectAction(project);
        }
        return null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        boolean result = true;
        try {
            listener.getLogger().println("Processing tests results in file " + this.testResultsFile);
            MSTestTransformer transformer = new MSTestTransformer(this.testResultsFile, new MSTestReportConverter(), listener);
            result = (Boolean)build.getWorkspace().act((FilePath.FileCallable)transformer);
            if (result) {
                result = this.recordTestResult("temporary-junit-reports/TEST-*.xml", build, listener);
                build.getWorkspace().child("temporary-junit-reports").deleteRecursive();
            }
        }
        catch (TransformerException te) {
            throw new AbortException("Could not read the XSL XML file. Please report this issue to the plugin author");
        }
        return result;
    }

    private boolean recordTestResult(String junitFilePattern, AbstractBuild<?, ?> build, BuildListener listener) throws InterruptedException, IOException {
        TestResultAction action;
        TestResultAction existingAction = (TestResultAction)build.getAction(TestResultAction.class);
        try {
            long buildTime = build.getTimestamp().getTimeInMillis();
            TestResult existingTestResults = null;
            if (existingAction != null) {
                existingTestResults = existingAction.getResult();
            }
            TestResult result = this.getTestResult(junitFilePattern, build, existingTestResults, buildTime);
            if (existingAction == null) {
                action = new TestResultAction(build, result, listener);
            } else {
                action = existingAction;
                action.setResult(result, listener);
            }
            if (result.getPassCount() == 0 && result.getFailCount() == 0) {
                new AbortException("None of the test reports contained any result");
            }
        }
        catch (AbortException e) {
            if (build.getResult() == Result.FAILURE) {
                return true;
            }
            listener.getLogger().println(e.getMessage());
            build.setResult(Result.FAILURE);
            return true;
        }
        if (existingAction == null) {
            build.getActions().add(action);
        }
        if (action.getResult().getFailCount() > 0) {
            build.setResult(Result.UNSTABLE);
        }
        return true;
    }

    private TestResult getTestResult(final String junitFilePattern, AbstractBuild<?, ?> build, final TestResult existingTestResults, final long buildTime) throws IOException, InterruptedException {
        TestResult result = (TestResult)build.getWorkspace().act((FilePath.FileCallable)new FilePath.FileCallable<TestResult>(){

            public TestResult invoke(File ws, VirtualChannel channel) throws IOException {
                FileSet fs = Util.createFileSet((File)ws, (String)junitFilePattern);
                DirectoryScanner ds = fs.getDirectoryScanner();
                String[] files = ds.getIncludedFiles();
                if (files.length == 0) {
                    throw new AbortException("No test report files were found. Configuration error?");
                }
                if (existingTestResults == null) {
                    return new TestResult(buildTime, ds);
                }
                existingTestResults.parse(buildTime, ds);
                return existingTestResults;
            }
        });
        return result;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(MSTestPublisher.class);
        }

        public String getDisplayName() {
            return Messages.MsTest_Publisher_Name();
        }

        public String getHelpFile() {
            return "/plugin/mstest/help.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new MSTestPublisher(req.getParameter("mstest_reports.pattern"));
        }
    }
}

