/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.listeners.ItemListener;
import hudson.plugins.jobConfigHistory.ConfigHistoryListenerHelper;
import hudson.plugins.jobConfigHistory.JobConfigHistory;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension
public final class JobConfigHistoryJobListener
extends ItemListener {
    private static final Logger LOG = Logger.getLogger(JobConfigHistoryJobListener.class.getName());

    public void onCreated(Item item) {
        LOG.finest("In onCreated for " + item);
        if (item instanceof AbstractProject) {
            ConfigHistoryListenerHelper.CREATED.createNewHistoryEntry(((AbstractProject)item).getConfigFile());
        } else {
            LOG.finest("onCreated: not an AbstractProject, skipping history save");
        }
        LOG.finest("onCreated for " + item + " done.");
    }

    public void onRenamed(Item item, String oldName, String newName) {
        String onRenameDesc = " old name: " + oldName + ", new name: " + newName;
        LOG.finest("In onRenamed for " + item + onRenameDesc);
        if (item instanceof AbstractProject) {
            File currentHistoryDir;
            File historyParentDir;
            File oldHistoryDir;
            ConfigHistoryListenerHelper.RENAMED.createNewHistoryEntry(((AbstractProject)item).getConfigFile());
            JobConfigHistory plugin = (JobConfigHistory)Hudson.getInstance().getPlugin(JobConfigHistory.class);
            if (plugin.getConfiguredHistoryRootDir() != null && (oldHistoryDir = new File(historyParentDir = (currentHistoryDir = plugin.getHistoryDir(((AbstractProject)item).getConfigFile())).getParentFile(), oldName)).exists()) {
                FilePath fp = new FilePath(oldHistoryDir);
                try {
                    fp.copyRecursiveTo(new FilePath(currentHistoryDir));
                    fp.deleteRecursive();
                    LOG.finest("completed move of old history files on rename." + onRenameDesc);
                }
                catch (IOException e) {
                    String ioExceptionStr = "unable to move old history on rename." + onRenameDesc;
                    LOG.log(Level.SEVERE, ioExceptionStr, e);
                }
                catch (InterruptedException e) {
                    String irExceptionStr = "interrupted while moving old history on rename." + onRenameDesc;
                    LOG.log(Level.WARNING, irExceptionStr, e);
                }
            }
        }
        LOG.finest("Completed onRename for" + item + " done.");
    }

    public void onDeleted(Item item) {
        JobConfigHistory plugin;
        LOG.finest("In onDeleted for " + item);
        if (item instanceof AbstractProject && (plugin = (JobConfigHistory)Hudson.getInstance().getPlugin(JobConfigHistory.class)).getConfiguredHistoryRootDir() != null) {
            ConfigHistoryListenerHelper.DELETED.createNewHistoryEntry(((AbstractProject)item).getConfigFile());
            File currentHistoryDir = plugin.getHistoryDir(((AbstractProject)item).getConfigFile());
            SimpleDateFormat buildDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
            String timestamp = buildDateFormat.format(new Date());
            String deletedHistoryName = currentHistoryDir.getName() + "_deleted_" + timestamp;
            File deletedHistoryDir = new File(currentHistoryDir.getParentFile(), deletedHistoryName);
            if (!currentHistoryDir.renameTo(deletedHistoryDir)) {
                LOG.warning("unable to rename deleted history dir to: " + deletedHistoryDir);
            }
        }
        LOG.finest("onDeleted for " + item + " done.");
    }
}

