/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.plugins.im.IMChat;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessageListener;
import hudson.plugins.jabber.im.transport.JabberIMConnection;
import hudson.plugins.jabber.im.transport.JabberMUCMessageListenerAdapter;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.Occupant;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.util.XmppStringUtils;

public class JabberMultiUserChat
implements IMChat {
    private final MultiUserChat chat;
    private final JabberIMConnection connection;
    private final boolean commandsAccepted;

    public JabberMultiUserChat(MultiUserChat chat, JabberIMConnection connection, boolean commandsAccepted) {
        this.chat = chat;
        this.connection = connection;
        this.commandsAccepted = commandsAccepted;
    }

    public void sendMessage(String msg) throws IMException {
        try {
            this.chat.sendMessage(msg);
        }
        catch (InterruptedException | SmackException.NotConnectedException e) {
            throw new IMException((Exception)e);
        }
    }

    public String getNickName(String sender) {
        String resource = XmppStringUtils.parseResource((String)sender);
        if (resource != null) {
            return resource;
        }
        return sender;
    }

    public String getIMId(String senderId) {
        EntityFullJid senderJid = JidCreate.entityFullFromOrThrowUnchecked((CharSequence)senderId);
        Occupant occ = this.chat.getOccupant(senderJid);
        if (occ != null) {
            return occ.getJid().toString();
        }
        return null;
    }

    public void addMessageListener(IMMessageListener listener) {
        this.chat.addMessageListener((MessageListener)new JabberMUCMessageListenerAdapter(listener, this.connection, this.chat));
    }

    public void removeMessageListener(IMMessageListener listener) {
    }

    public boolean isMultiUserChat() {
        return true;
    }

    public boolean isCommandsAccepted() {
        return this.commandsAccepted;
    }
}

