/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.plugins.im.DefaultIMMessageTarget;
import hudson.plugins.im.GroupChatIMMessageTarget;
import hudson.plugins.im.IMMessageTarget;
import hudson.plugins.im.IMMessageTargetConversionException;
import hudson.plugins.im.IMMessageTargetConverter;
import hudson.plugins.jabber.im.transport.JabberPublisher;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.springframework.util.Assert;

public class JabberIMMessageTargetConverter
implements IMMessageTargetConverter {
    private void checkValidity(String target) throws IMMessageTargetConversionException {
        int i = target.indexOf(64);
        if (i == -1) {
            throw new IMMessageTargetConversionException("Invalid input for target: '" + target + "'.\nDoesn't contain a @.");
        }
        if (target.indexOf(64, i + 1) != -1) {
            throw new IMMessageTargetConversionException("Invalid input for target: '" + target + "'.\nContains more than on @.");
        }
    }

    public IMMessageTarget fromString(String targetAsString) throws IMMessageTargetConversionException {
        String f = targetAsString.trim();
        if (f.length() > 0) {
            GroupChatIMMessageTarget target;
            if (f.startsWith("*")) {
                if (!(f = f.substring(1)).contains("@")) {
                    f = f + "@conference." + JabberPublisher.DESCRIPTOR.getHost();
                }
                target = new GroupChatIMMessageTarget(f, null, false);
            } else if (f.contains("@conference.")) {
                target = new GroupChatIMMessageTarget(f, null, false);
            } else {
                if (!f.contains("@")) {
                    f = f + "@" + JabberPublisher.DESCRIPTOR.getHost();
                }
                target = new DefaultIMMessageTarget(f);
            }
            this.checkValidity(f);
            return target;
        }
        return null;
    }

    public List<IMMessageTarget> allFromString(Collection<String> targetsAsString) throws IMMessageTargetConversionException {
        LinkedList<IMMessageTarget> finalTargets = new LinkedList<IMMessageTarget>();
        for (String target : targetsAsString) {
            finalTargets.add(this.fromString(target));
        }
        return finalTargets;
    }

    public String toString(IMMessageTarget target) {
        Assert.notNull((Object)target, (String)"Parameter 'target' must not be null.");
        return target.toString();
    }
}

