/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.plugins.im.IMConnection;
import hudson.plugins.im.IMConnectionProvider;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMPublisherDescriptor;
import hudson.plugins.jabber.im.transport.JabberIMConnection;
import hudson.plugins.jabber.im.transport.JabberPublisherDescriptor;
import java.util.logging.Level;
import java.util.logging.Logger;

final class JabberIMConnectionProvider
extends IMConnectionProvider {
    private static final IMConnectionProvider INSTANCE = new JabberIMConnectionProvider();
    private static final Logger LOGGER = Logger.getLogger(JabberIMConnectionProvider.class.getName());

    static final synchronized IMConnectionProvider getInstance() {
        return INSTANCE;
    }

    static final synchronized void setDesc(IMPublisherDescriptor desc) throws IMException {
        INSTANCE.setDescriptor(desc);
        INSTANCE.releaseConnection();
    }

    private JabberIMConnectionProvider() {
        this.init();
    }

    public synchronized IMConnection createConnection() throws IMException {
        JabberIMConnection imConnection;
        this.releaseConnection();
        if (this.getDescriptor() == null) {
            throw new IMException("Descriptor not set");
        }
        LOGGER.info("Creating XMPP JabberIMConnection");
        try {
            imConnection = new JabberIMConnection((JabberPublisherDescriptor)this.getDescriptor(), this.getAuthenticationHolder());
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.WARNING, "exception", e);
            throw e;
        }
        if (imConnection.connect()) {
            return imConnection;
        }
        throw new IMException("Connection failed");
    }
}

