/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.Util;
import hudson.plugins.im.AbstractIMConnection;
import hudson.plugins.im.AuthenticationHolder;
import hudson.plugins.im.GroupChatIMMessageTarget;
import hudson.plugins.im.IMChat;
import hudson.plugins.im.IMConnectionListener;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessage;
import hudson.plugins.im.IMMessageTarget;
import hudson.plugins.im.IMPresence;
import hudson.plugins.im.IMPublisherDescriptor;
import hudson.plugins.im.bot.Bot;
import hudson.plugins.im.tools.ExceptionHelper;
import hudson.plugins.jabber.im.transport.JabberChat;
import hudson.plugins.jabber.im.transport.JabberConnectionDebugger;
import hudson.plugins.jabber.im.transport.JabberMessage;
import hudson.plugins.jabber.im.transport.JabberMultiUserChat;
import hudson.plugins.jabber.im.transport.JabberPublisherDescriptor;
import hudson.util.DaemonThreadFactory;
import hudson.util.NamingThreadFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.security.sasl.SaslException;
import org.apache.commons.io.IOUtils;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.ReconnectionManager;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.chat.Chat;
import org.jivesoftware.smack.chat.ChatManager;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.debugger.SmackDebuggerFactory;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.parsing.ExceptionLoggingCallback;
import org.jivesoftware.smack.parsing.ParsingExceptionCallback;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jivesoftware.smack.util.TLSUtils;
import org.jivesoftware.smackx.delay.packet.DelayInformation;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.jivesoftware.smackx.nick.packet.Nick;
import org.jivesoftware.smackx.ping.packet.Ping;
import org.jivesoftware.smackx.vcardtemp.VCardManager;
import org.jivesoftware.smackx.vcardtemp.packet.VCard;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;
import org.springframework.util.Assert;

class JabberIMConnection
extends AbstractIMConnection {
    private static final Logger LOGGER = Logger.getLogger(JabberIMConnection.class.getName());
    private volatile XMPPTCPConnection connection;
    private final Map<BareJid, WeakReference<MultiUserChat>> groupChatCache = new HashMap<BareJid, WeakReference<MultiUserChat>>();
    private final Map<EntityJid, WeakReference<Chat>> chatCache = new HashMap<EntityJid, WeakReference<Chat>>();
    private final Set<Bot> bots = new HashSet<Bot>();
    private final String passwd;
    private final String botCommandPrefix;
    private final String nick;
    @Nullable
    private final Resourcepart resource;
    @Nullable
    private final Resourcepart groupChatNick;
    private final String hostnameOverride;
    private final int port;
    private final List<IMMessageTarget> groupChats;
    private IMPresence impresence;
    private String imStatusMessage;
    private final JabberPublisherDescriptor desc;
    private final AuthenticationHolder authentication;
    private Roster roster;
    private final ProxyInfo.ProxyType proxytype;
    private final String proxyhost;
    private final String proxyuser;
    private final String proxypass;
    private final int proxyport;
    private final boolean acceptAllCerts;
    private Runnable keepAliveCommand;
    private ScheduledExecutorService scheduler;
    private final Map<IMConnectionListener, ConnectionListener> listeners = new ConcurrentHashMap<IMConnectionListener, ConnectionListener>();

    JabberIMConnection(JabberPublisherDescriptor desc, AuthenticationHolder authentication) throws IMException {
        super((IMPublisherDescriptor)desc);
        EntityJid myJid;
        Assert.notNull((Object)((Object)desc), (String)"Parameter 'desc' must not be null.");
        try {
            myJid = JidCreate.entityFromUnescaped((String)desc.getJabberId());
        }
        catch (XmppStringprepException e) {
            throw new IMException((Exception)((Object)e));
        }
        this.desc = desc;
        this.authentication = authentication;
        this.hostnameOverride = desc.getHostname();
        this.port = desc.getPort();
        this.nick = desc.getNickname();
        this.resource = myJid.getResourceOrNull();
        this.passwd = desc.getPassword();
        this.proxytype = desc.getProxyType();
        this.proxyhost = desc.getProxyHost();
        this.proxyport = desc.getProxyPort();
        this.proxyuser = desc.getProxyUser();
        this.proxypass = desc.getProxyPass();
        try {
            this.groupChatNick = Resourcepart.from((String)desc.getNickname());
        }
        catch (XmppStringprepException e) {
            throw new IMException((Exception)((Object)e));
        }
        this.botCommandPrefix = desc.getCommandPrefix();
        this.groupChats = desc.getDefaultTargets();
        this.impresence = desc.isExposePresence() ? IMPresence.AVAILABLE : IMPresence.UNAVAILABLE;
        this.acceptAllCerts = desc.isAcceptAllCerts();
    }

    public boolean connect() {
        this.lock();
        try {
            LOGGER.info("Trying to connect XMPP connection");
            if (this.connection != null && this.connection.isConnected()) {
                LOGGER.fine("XMPP connection already established");
                boolean bl = true;
                return bl;
            }
            LOGGER.fine("creating new XMPP connection");
            boolean connectingSucceeded = this.createConnection();
            if (connectingSucceeded) {
                this.initNewConnection();
            } else {
                this.disconnect();
            }
            boolean bl = connectingSucceeded;
            return bl;
        }
        catch (Exception e) {
            LOGGER.warning(ExceptionHelper.dump((Throwable)e));
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    private void disconnect() {
        if (this.connection != null && this.connection.isConnected()) {
            try {
                this.connection.disconnect();
            }
            catch (Exception e) {
                LOGGER.info("Exception while disconnecting: " + e.getMessage());
            }
        }
    }

    private void initNewConnection() {
        LOGGER.info("Connected to XMPP on " + this.connection.getHost() + ":" + this.connection.getPort() + "/" + this.connection.getXMPPServiceDomain() + (this.connection.isSecureConnection() ? " using secure connection" : "") + (this.connection.isUsingCompression() ? " using compression" : ""));
        this.sendPresence();
        this.groupChatCache.clear();
        for (IMMessageTarget chat : this.groupChats) {
            GroupChatIMMessageTarget groupChat = (GroupChatIMMessageTarget)chat;
            try {
                this.getOrCreateGroupChat(groupChat);
                LOGGER.info("Joined groupchat " + groupChat.getName());
            }
            catch (IMException e) {
                LOGGER.warning("Unable to connect to groupchat '" + groupChat.getName() + "'. Did you append @conference or so to the name?\nException: " + ExceptionHelper.dump((Throwable)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.lock();
        try {
            try {
                for (WeakReference<MultiUserChat> entry : this.groupChatCache.values()) {
                    MultiUserChat chat = (MultiUserChat)entry.get();
                    if (chat == null || !chat.isJoined()) continue;
                    chat.leave();
                }
                this.groupChatCache.clear();
                this.chatCache.clear();
                if (this.scheduler != null) {
                    this.scheduler.shutdownNow();
                    this.scheduler = null;
                }
                if (this.connection.isConnected()) {
                    this.connection.disconnect();
                }
            }
            catch (Exception e) {
                LOGGER.fine(e.toString());
            }
            finally {
                this.connection = null;
            }
        }
        finally {
            this.unlock();
        }
    }

    private boolean createConnection() throws XMPPException, SaslException, SmackException, IOException, NoSuchAlgorithmException, KeyManagementException, InterruptedException {
        XMPPTCPConnection connection;
        if (this.connection != null) {
            try {
                this.connection.disconnect();
            }
            catch (Exception ignore) {
                LOGGER.info("Caught an exception while disconnecting before reconnect: " + ignore.getMessage());
            }
        }
        ProxyInfo pi = null;
        if (this.proxytype != null) {
            switch (this.proxytype) {
                case HTTP: {
                    pi = ProxyInfo.forHttpProxy((String)this.proxyhost, (int)this.proxyport, (String)this.proxyuser, (String)this.proxypass);
                    break;
                }
                case SOCKS4: {
                    pi = ProxyInfo.forSocks4Proxy((String)this.proxyhost, (int)this.proxyport, (String)this.proxyuser, (String)this.proxypass);
                    break;
                }
                case SOCKS5: {
                    pi = ProxyInfo.forSocks5Proxy((String)this.proxyhost, (int)this.proxyport, (String)this.proxyuser, (String)this.proxypass);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        String serviceName = this.desc.getServiceName();
        XMPPTCPConnectionConfiguration.Builder cfg = XMPPTCPConnectionConfiguration.builder();
        if (pi != null) {
            cfg.setProxyInfo(pi);
        }
        if (serviceName == null) {
            ((XMPPTCPConnectionConfiguration.Builder)cfg.setHost((CharSequence)this.hostnameOverride)).setPort(this.port);
        } else if (this.hostnameOverride == null) {
            cfg.setXmppDomain(serviceName);
        } else {
            ((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)cfg.setHost((CharSequence)this.hostnameOverride)).setPort(this.port)).setXmppDomain(serviceName);
        }
        cfg.setDebuggerFactory(new SmackDebuggerFactory(){

            public SmackDebugger create(XMPPConnection connection) {
                return new JabberConnectionDebugger(connection);
            }
        });
        if (this.acceptAllCerts) {
            TLSUtils.acceptAllCertificates((ConnectionConfiguration.Builder)cfg);
            cfg.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }
            });
        }
        XMPPTCPConnectionConfiguration conf = cfg.build();
        this.connection = connection = new XMPPTCPConnection(conf);
        LOGGER.info("Trying to connect to XMPP on /" + connection.getXMPPServiceDomain() + (conf.isCompressionEnabled() ? " using compression" : "") + (pi != null ? " via proxy " + pi.getProxyType() + " " + pi.getProxyAddress() + ":" + pi.getProxyPort() : ""));
        boolean retryWithLegacySSL = false;
        Throwable originalException = null;
        try {
            this.connection.connect();
            if (!this.connection.isConnected()) {
                retryWithLegacySSL = true;
            }
        }
        catch (XMPPException e) {
            retryWithLegacySSL = true;
            originalException = e;
        }
        catch (SmackException.NoResponseException e) {
            retryWithLegacySSL = true;
            originalException = e;
        }
        catch (SmackException e) {
            LOGGER.warning(ExceptionHelper.dump((Throwable)e));
        }
        catch (IOException e) {
            LOGGER.warning(ExceptionHelper.dump((Throwable)e));
        }
        if (retryWithLegacySSL) {
            this.retryConnectionWithLegacySSL(cfg, (Exception)originalException);
        }
        if (this.connection.isConnected()) {
            this.connection.login((CharSequence)this.desc.getUserName(), this.passwd, this.resource);
            this.setupSubscriptionMode();
            this.createVCardIfNeeded();
            this.installServerTypeHacks();
            this.listenForPrivateChats();
        }
        return this.connection.isAuthenticated();
    }

    private void installServerTypeHacks() {
        if (this.connection.getXMPPServiceDomain().toString().contains("hipchat")) {
            this.addConnectionKeepAlivePings(60);
        } else {
            this.addConnectionKeepAlivePings(300);
        }
    }

    private void addConnectionKeepAlivePings(int keepAlivePeriodInSeconds) {
        if (this.scheduler == null) {
            this.scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamingThreadFactory((ThreadFactory)new DaemonThreadFactory(), JabberIMConnection.class.getSimpleName()));
        }
        if (this.keepAliveCommand != null) {
            return;
        }
        this.keepAliveCommand = new Runnable(){

            @Override
            public void run() {
                try {
                    if (!JabberIMConnection.this.tryLock(5L, TimeUnit.SECONDS)) {
                        return;
                    }
                    try {
                        JabberIMConnection.this.connection.sendStanza((Stanza)new Ping());
                    }
                    catch (SmackException.NotConnectedException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        JabberIMConnection.this.unlock();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        };
        this.scheduler.scheduleAtFixedRate(this.keepAliveCommand, keepAlivePeriodInSeconds, keepAlivePeriodInSeconds, TimeUnit.SECONDS);
    }

    private void retryConnectionWithLegacySSL(XMPPTCPConnectionConfiguration.Builder cfg, @Nullable Exception originalException) throws XMPPException, SmackException, InterruptedException {
        try {
            LOGGER.info("Retrying connection with legacy SSL");
            cfg.setSocketFactory(SSLSocketFactory.getDefault());
            this.connection = new XMPPTCPConnection(cfg.build());
            this.connection.connect();
        }
        catch (XMPPException e) {
            if (originalException != null) {
                LOGGER.warning("Retrying with legacy SSL failed: " + e.getMessage());
                throw new SmackException.SmackWrappedException("Exception of original (without legacy SSL) connection attempt", originalException);
            }
            throw new SmackException.SmackWrappedException((Exception)((Object)e));
        }
        catch (SmackException e) {
            LOGGER.warning(ExceptionHelper.dump((Throwable)e));
        }
        catch (IOException e) {
            LOGGER.warning(ExceptionHelper.dump((Throwable)e));
        }
    }

    private void setupSubscriptionMode() {
        this.roster = Roster.getInstanceFor((XMPPConnection)this.connection);
        Roster.SubscriptionMode mode = Roster.SubscriptionMode.valueOf((String)this.desc.getSubscriptionMode());
        switch (mode) {
            case accept_all: {
                LOGGER.info("Accepting all subscription requests");
                break;
            }
            case reject_all: {
                LOGGER.info("Rejecting all subscription requests");
                break;
            }
            case manual: {
                LOGGER.info("Subscription requests must be handled manually");
            }
        }
        this.roster.setSubscriptionMode(mode);
    }

    private void createVCardIfNeeded() {
        try {
            if (!this.vCardExists()) {
                this.createVCard();
            }
        }
        catch (InterruptedException | XMPPException e) {
            LOGGER.warning(ExceptionHelper.dump((Throwable)e));
        }
        catch (SmackException.NotConnectedException e) {
            LOGGER.warning(ExceptionHelper.dump((Throwable)e));
        }
        catch (SmackException.NoResponseException e) {
            LOGGER.warning(ExceptionHelper.dump((Throwable)e));
        }
    }

    private boolean vCardExists() throws XMPPException {
        try {
            VCard vcard = VCardManager.getInstanceFor((XMPPConnection)this.connection).loadVCard();
            return Util.fixEmpty((String)vcard.getNickName()) != null;
        }
        catch (XMPPException e) {
            XMPPException.XMPPErrorException ex;
            if (e instanceof XMPPException.XMPPErrorException && (ex = (XMPPException.XMPPErrorException)e).getStanzaError().getCondition().equals((Object)StanzaError.Condition.item_not_found)) {
                return false;
            }
            throw e;
        }
        catch (SmackException.NoResponseException | SmackException.NotConnectedException e) {
            LOGGER.warning(ExceptionHelper.dump((Throwable)e));
            return false;
        }
        catch (InterruptedException e) {
            LOGGER.fine(ExceptionHelper.dump((Throwable)e));
            return false;
        }
        catch (ClassCastException e) {
            LOGGER.warning(ExceptionHelper.dump((Throwable)e));
            return true;
        }
    }

    private void createVCard() throws XMPPException, SmackException.NotConnectedException, SmackException.NoResponseException, InterruptedException {
        VCard vCard = new VCard();
        vCard.setFirstName("Mr.");
        vCard.setLastName("Jenkins");
        vCard.setNickName(this.nick.toString());
        this.setAvatarImage(vCard);
        VCardManager.getInstanceFor((XMPPConnection)this.connection).saveVCard(vCard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAvatarImage(VCard vCard) {
        InputStream input = null;
        ByteArrayOutputStream output = null;
        try {
            input = JabberIMConnection.class.getResourceAsStream("headshot.png");
            output = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)input, (OutputStream)output);
            byte[] avatar = output.toByteArray();
            vCard.setAvatar(avatar, "image/png");
        }
        catch (IOException e) {
            try {
                LOGGER.warning(ExceptionHelper.dump((Throwable)e));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)input);
                IOUtils.closeQuietly(output);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)input);
            IOUtils.closeQuietly((OutputStream)output);
        }
        IOUtils.closeQuietly((InputStream)input);
        IOUtils.closeQuietly((OutputStream)output);
    }

    private void listenForPrivateChats() {
        StanzaFilter filter = MessageTypeFilter.CHAT;
        PrivateChatListener listener = new PrivateChatListener();
        this.connection.addSyncStanzaListener((StanzaListener)listener, filter);
    }

    private MultiUserChat getOrCreateGroupChat(GroupChatIMMessageTarget chat) throws IMException {
        EntityBareJid mucJid = JidCreate.entityBareFromUnescapedOrThrowUnchecked((CharSequence)chat.getName());
        WeakReference<MultiUserChat> ref = this.groupChatCache.get(mucJid);
        MultiUserChat groupChat = null;
        if (ref != null) {
            groupChat = (MultiUserChat)ref.get();
        }
        if (groupChat == null) {
            groupChat = MultiUserChatManager.getInstanceFor((XMPPConnection)this.connection).getMultiUserChat(mucJid);
            try {
                groupChat.join(this.groupChatNick, chat.getPassword());
            }
            catch (InterruptedException | SmackException | XMPPException e) {
                LOGGER.warning("Cannot join group chat '" + chat + "'. Exception:\n" + ExceptionHelper.dump((Throwable)e));
                throw new IMException((Exception)e);
            }
            try {
                while (groupChat.pollMessage() != null) {
                }
            }
            catch (MultiUserChatException.MucNotJoinedException e) {
                throw new IMException((Exception)((Object)e));
            }
            this.bots.add(new Bot((IMChat)new JabberMultiUserChat(groupChat, this, !chat.isNotificationOnly()), this.groupChatNick.toString(), this.desc.getHost(), this.botCommandPrefix, this.authentication));
            this.groupChatCache.put((BareJid)mucJid, new WeakReference<MultiUserChat>(groupChat));
        }
        return groupChat;
    }

    private Chat getOrCreatePrivateChat(Jid chatPartnerJid, Message msg) {
        Chat c;
        EntityJid chatPartner = chatPartnerJid.asEntityJidOrThrow();
        WeakReference<Chat> wr = this.chatCache.get(chatPartner);
        if (wr != null && (c = (Chat)wr.get()) != null) {
            return c;
        }
        Chat chat = ChatManager.getInstanceFor((XMPPConnection)this.connection).createChat(chatPartner, null);
        Bot bot = new Bot((IMChat)new JabberChat(chat, this), this.groupChatNick.toString(), this.desc.getHost(), this.botCommandPrefix, this.authentication);
        this.bots.add(bot);
        if (msg != null) {
            bot.onMessage((IMMessage)new JabberMessage(msg, this.isAuthorized(msg.getFrom().asBareJid())));
        }
        this.chatCache.put(chatPartner, new WeakReference<Chat>(chat));
        return chat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(IMMessageTarget target, String text) throws IMException {
        Assert.notNull((Object)target, (String)"Parameter 'target' must not be null.");
        Assert.notNull((Object)text, (String)"Parameter 'text' must not be null.");
        try {
            if (!this.tryLock(5L, TimeUnit.SECONDS)) {
                return;
            }
            try {
                if (target instanceof GroupChatIMMessageTarget) {
                    this.getOrCreateGroupChat((GroupChatIMMessageTarget)target).sendMessage(text);
                } else {
                    Jid targetJid = JidCreate.fromOrThrowUnchecked((CharSequence)target.toString());
                    Chat chat = this.getOrCreatePrivateChat(targetJid, null);
                    chat.sendMessage(text);
                }
            }
            catch (SmackException.NotConnectedException e) {
                LOGGER.warning(ExceptionHelper.dump((Throwable)e));
            }
            finally {
                this.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void setPresence(IMPresence impresence, String statusMessage) throws IMException {
        Assert.notNull((Object)impresence, (String)"Parameter 'impresence' must not be null.");
        if (this.desc.isExposePresence()) {
            this.impresence = impresence;
            this.imStatusMessage = statusMessage;
            this.sendPresence();
        }
    }

    private void sendPresence() {
        try {
            if (!this.tryLock(5L, TimeUnit.SECONDS)) {
                return;
            }
            try {
                if (!this.isConnected()) {
                    return;
                }
                PresenceBuilder presenceBuilder = this.connection.getStanzaFactory().buildPresenceStanza();
                switch (this.impresence) {
                    case AVAILABLE: {
                        presenceBuilder.setStatus(this.imStatusMessage).setPriority(1).setMode(Presence.Mode.available);
                        break;
                    }
                    case OCCUPIED: {
                        presenceBuilder.setStatus(this.imStatusMessage).setPriority(1).setMode(Presence.Mode.away);
                        break;
                    }
                    case DND: {
                        presenceBuilder.setStatus(this.imStatusMessage).setPriority(1).setMode(Presence.Mode.dnd);
                        break;
                    }
                    case UNAVAILABLE: {
                        presenceBuilder.ofType(Presence.Type.unavailable);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Don't know how to handle " + this.impresence);
                    }
                }
                presenceBuilder.addExtension((ExtensionElement)new Nick(this.nick));
                Presence presence = presenceBuilder.build();
                this.connection.sendStanza((Stanza)presence);
            }
            catch (SmackException.NotConnectedException e) {
                LOGGER.warning(ExceptionHelper.dump((Throwable)e));
            }
            finally {
                this.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean isConnected() {
        this.lock();
        try {
            boolean bl = this.connection != null && this.connection.isAuthenticated();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public boolean isAuthorized(BareJid bareAddress) {
        boolean authorized = this.groupChatCache.containsKey(bareAddress);
        if (!authorized) {
            RosterEntry entry = this.roster.getEntry(bareAddress);
            authorized = entry != null && (entry.getType() == RosterPacket.ItemType.both || entry.getType() == RosterPacket.ItemType.from);
        }
        return authorized;
    }

    public void addConnectionListener(final IMConnectionListener listener) {
        this.lock();
        try {
            ConnectionListener l = new ConnectionListener(){

                public void connectionClosedOnError(Exception e) {
                    listener.connectionBroken(e);
                }
            };
            this.listeners.put(listener, l);
            this.connection.addConnectionListener(l);
        }
        finally {
            this.unlock();
        }
    }

    public void removeConnectionListener(IMConnectionListener listener) {
        this.lock();
        try {
            ConnectionListener l = this.listeners.remove(listener);
            if (l != null) {
                this.connection.removeConnectionListener(l);
            } else {
                LOGGER.warning("Connection listener " + listener + " not found.");
            }
        }
        finally {
            this.unlock();
        }
    }

    static {
        SmackConfiguration.setDefaultReplyTimeout((int)20000);
        SmackConfiguration.setDefaultParsingExceptionCallback((ParsingExceptionCallback)new ExceptionLoggingCallback());
        ReconnectionManager.setEnabledPerDefault((boolean)false);
    }

    private final class PrivateChatListener
    implements StanzaListener {
        private PrivateChatListener() {
        }

        public void processStanza(Stanza packet) {
            if (packet instanceof Message) {
                Message m = (Message)packet;
                for (ExtensionElement ext : m.getExtensions()) {
                    if (!(ext instanceof DelayInformation)) continue;
                    return;
                }
                if (m.getBody() != null) {
                    LOGGER.fine("Message from " + m.getFrom() + " : " + m.getBody());
                    Jid chatPartner = m.getFrom();
                    JabberIMConnection.this.getOrCreatePrivateChat(chatPartner, m);
                }
            }
        }
    }
}

