/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jxmpp.jid.EntityFullJid;

public class JabberConnectionDebugger
extends SmackDebugger {
    private static final Logger LOGGER = Logger.getLogger(JabberConnectionDebugger.class.getName());
    private static final Level MIN_LOG_LEVEL = Level.FINE;
    private ConnectionListener connListener = new ConnectionListener(){

        public void connected(XMPPConnection connection) {
            if (LOGGER.isLoggable(MIN_LOG_LEVEL)) {
                LOGGER.fine("Connection " + connection + " established");
            }
        }

        public void authenticated(XMPPConnection connection, boolean resumed) {
            if (LOGGER.isLoggable(MIN_LOG_LEVEL)) {
                LOGGER.fine("Connection " + connection + " authenticated");
            }
        }

        public void connectionClosed() {
            if (LOGGER.isLoggable(MIN_LOG_LEVEL)) {
                LOGGER.fine("Connection closed");
            }
        }

        public void connectionClosedOnError(Exception e) {
            if (LOGGER.isLoggable(MIN_LOG_LEVEL)) {
                LOGGER.log(MIN_LOG_LEVEL, "Connection closed due to an exception", e);
            }
        }
    };

    public JabberConnectionDebugger(XMPPConnection connection) {
        super(connection);
        connection.addConnectionListener(this.connListener);
    }

    public void userHasLogged(EntityFullJid user) {
        if (LOGGER.isLoggable(MIN_LOG_LEVEL)) {
            boolean isAnonymous = "".equals(user.getLocalpart());
            String title = "User logged in (" + this.connection.hashCode() + "): " + (isAnonymous ? "" : user.asBareJid()) + "@" + this.connection.getXMPPServiceDomain() + ":" + this.connection.getPort();
            title = title + "/" + user.getResourcepart();
            LOGGER.fine(title);
        }
    }

    public void onIncomingStreamElement(TopLevelStreamElement streamElement) {
        if (LOGGER.isLoggable(MIN_LOG_LEVEL)) {
            LOGGER.log(MIN_LOG_LEVEL, "RECV: " + streamElement.toXML());
        }
    }

    public void onOutgoingStreamElement(TopLevelStreamElement streamElement) {
        if (LOGGER.isLoggable(MIN_LOG_LEVEL)) {
            LOGGER.log(MIN_LOG_LEVEL, "SENT: " + streamElement.toXML());
        }
    }

    public void outgoingStreamSink(CharSequence outgoingCharSequence) {
    }

    public void incomingStreamSink(CharSequence incomingCharSequence) {
    }
}

