/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.plugins.im.IMChat;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessageListener;
import hudson.plugins.jabber.im.transport.JabberIMConnection;
import hudson.plugins.jabber.im.transport.JabberMessageListenerAdapter;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.chat.Chat;
import org.jivesoftware.smack.chat.ChatMessageListener;
import org.jxmpp.util.XmppStringUtils;

public class JabberChat
implements IMChat {
    private final Chat chat;
    private final JabberIMConnection connection;

    public JabberChat(Chat chat, JabberIMConnection connection) {
        this.chat = chat;
        this.connection = connection;
    }

    public void sendMessage(String msg) throws IMException {
        try {
            this.chat.sendMessage(msg);
        }
        catch (InterruptedException | SmackException.NotConnectedException e) {
            throw new IMException((Exception)e);
        }
    }

    public String getNickName(String sender) {
        return XmppStringUtils.parseLocalpart((String)sender);
    }

    public String getIMId(String senderId) {
        return XmppStringUtils.parseLocalpart((String)senderId) + '@' + XmppStringUtils.parseDomain((String)senderId);
    }

    public void addMessageListener(IMMessageListener listener) {
        this.chat.addMessageListener((ChatMessageListener)new JabberMessageListenerAdapter(listener, this.connection, this.chat));
    }

    public void removeMessageListener(IMMessageListener listener) {
    }

    public boolean isMultiUserChat() {
        return false;
    }

    public boolean isCommandsAccepted() {
        return true;
    }
}

