/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.steps;

import com.google.common.collect.ImmutableSet;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.im.MatrixJobMultiplier;
import hudson.plugins.im.NotificationStrategy;
import hudson.plugins.im.build_notify.BuildToChatNotifier;
import hudson.plugins.im.build_notify.DefaultBuildToChatNotifier;
import hudson.plugins.jabber.im.transport.JabberIMMessageTargetConverter;
import hudson.plugins.jabber.im.transport.JabberPublisher;
import hudson.util.ListBoxModel;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class JabberNotifyStep
extends Step {
    private static final char TARGET_SEPARATOR_CHAR = ' ';
    private static final JabberIMMessageTargetConverter CONVERTER = new JabberIMMessageTargetConverter();
    private final String targets;
    private boolean notifySuspects;
    private boolean notifyCulprits;
    private boolean notifyFixers;
    private boolean notifyUpstreamCommitters;
    private String notificationStrategy = NotificationStrategy.ALL.getDisplayName();
    private BuildToChatNotifier buildToChatNotifier = new DefaultBuildToChatNotifier();
    private MatrixJobMultiplier matrixNotifier = MatrixJobMultiplier.ONLY_PARENT;
    private String extraMessage = "";

    public StepExecution start(StepContext context) throws Exception {
        return new JabberNotifyStepExecution(this, context);
    }

    @DataBoundConstructor
    public JabberNotifyStep(String targets) {
        this.targets = targets;
    }

    public String getTargets() {
        return this.targets;
    }

    public boolean isNotifySuspects() {
        return this.notifySuspects;
    }

    @DataBoundSetter
    public void setNotifySuspects(boolean notifySuspects) {
        this.notifySuspects = notifySuspects;
    }

    public boolean isNotifyCulprits() {
        return this.notifyCulprits;
    }

    @DataBoundSetter
    public void setNotifyCulprits(boolean notifyCulprits) {
        this.notifyCulprits = notifyCulprits;
    }

    public boolean isNotifyFixers() {
        return this.notifyFixers;
    }

    @DataBoundSetter
    public void setNotifyFixers(boolean notifyFixers) {
        this.notifyFixers = notifyFixers;
    }

    public boolean isNotifyUpstreamCommitters() {
        return this.notifyUpstreamCommitters;
    }

    @DataBoundSetter
    public void setNotifyUpstreamCommitters(boolean notifyUpstreamCommitters) {
        this.notifyUpstreamCommitters = notifyUpstreamCommitters;
    }

    public BuildToChatNotifier getBuildToChatNotifier() {
        return this.buildToChatNotifier;
    }

    @DataBoundSetter
    public void setBuildToChatNotifier(BuildToChatNotifier buildToChatNotifier) {
        this.buildToChatNotifier = buildToChatNotifier;
    }

    public MatrixJobMultiplier getMatrixNotifier() {
        return this.matrixNotifier;
    }

    @DataBoundSetter
    public void setMatrixNotifier(MatrixJobMultiplier matrixNotifier) {
        this.matrixNotifier = matrixNotifier;
    }

    public String getNotificationStrategy() {
        return this.notificationStrategy;
    }

    @DataBoundSetter
    public void setNotificationStrategy(String notificationStrategy) {
        this.notificationStrategy = notificationStrategy;
    }

    public String getExtraMessage() {
        return this.extraMessage;
    }

    @DataBoundSetter
    public void setExtraMessage(String extraMessage) {
        this.extraMessage = extraMessage;
    }

    @Extension(optional=true)
    public static final class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(FilePath.class, Run.class, Launcher.class, TaskListener.class);
        }

        public String getFunctionName() {
            return "jabberNotify";
        }

        public String getDisplayName() {
            return "Jabber Notification";
        }

        public ListBoxModel doFillNotificationStrategyItems() {
            ListBoxModel items = new ListBoxModel();
            for (NotificationStrategy strategy : NotificationStrategy.values()) {
                items.add(strategy.getDisplayName(), strategy.getDisplayName());
            }
            return items;
        }
    }

    private static class JabberNotifyStepExecution
    extends SynchronousNonBlockingStepExecution<Void> {
        private final transient JabberNotifyStep step;

        public JabberNotifyStepExecution(@Nonnull JabberNotifyStep step, @Nonnull StepContext context) {
            super(context);
            this.step = step;
        }

        protected Void run() throws Exception {
            List<String> targets = Arrays.asList(StringUtils.split((String)this.step.targets, (char)' '));
            JabberPublisher publisher = new JabberPublisher(CONVERTER.allFromString(targets), this.step.notificationStrategy, false, this.step.notifySuspects, this.step.notifyCulprits, this.step.notifyFixers, this.step.notifyUpstreamCommitters, this.step.buildToChatNotifier, this.step.matrixNotifier);
            publisher.setExtraMessage(this.step.extraMessage);
            publisher.perform((Run)this.getContext().get(Run.class), (FilePath)this.getContext().get(FilePath.class), (Launcher)this.getContext().get(Launcher.class), (TaskListener)this.getContext().get(TaskListener.class));
            return null;
        }
    }
}

