/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.hipchat.utils;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.common.AbstractIdCredentialsListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.HostnameSpecification;
import com.cloudbees.plugins.credentials.domains.SchemeSpecification;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.inject.Singleton;
import jenkins.model.Jenkins;
import jenkins.plugins.hipchat.HipChatNotifier;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.plaincredentials.impl.StringCredentialsImpl;

@Singleton
public class CredentialUtils {
    public StringCredentials resolveCredential(Item context, @CheckForNull String credentialId, String server) {
        return credentialId == null ? null : (StringCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, this.requirements(server)), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialId));
    }

    public ListBoxModel getAvailableCredentials(@CheckForNull Item item, String globalCredentialId, String server) {
        String currentValue = this.getCurrentlySelectedCredentialId(item, globalCredentialId);
        if (item == null && !Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER) || item != null && !item.hasPermission(Item.EXTENDED_READ)) {
            return new StandardListBoxModel().includeCurrentValue(currentValue);
        }
        AbstractIdCredentialsListBoxModel model = new StandardListBoxModel().includeEmptyValue();
        model = item == null ? model.includeAs(ACL.SYSTEM, (ItemGroup)Jenkins.getInstance(), StringCredentials.class, this.requirements(server)) : model.includeAs(ACL.SYSTEM, item, StringCredentials.class, this.requirements(server));
        if (currentValue != null) {
            model = model.includeCurrentValue(currentValue);
        }
        return model;
    }

    public void migrateGlobalCredential(HipChatNotifier.DescriptorImpl descriptor) throws IOException {
        List credentials = CredentialsProvider.lookupCredentials(StringCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, this.requirements(descriptor.getServer()));
        String room = Util.fixEmpty((String)descriptor.getRoom()) != null ? descriptor.getRoom() : "Global";
        String credentialId = this.storeCredential(descriptor, credentials, room, descriptor.getToken());
        descriptor.setToken(null);
        descriptor.setCredentialId(credentialId);
    }

    public void migrateJobCredential(HipChatNotifier.DescriptorImpl descriptor, Item item, HipChatNotifier notifier) throws IOException {
        List credentials = CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, this.requirements(descriptor.getServer()));
        String room = Util.fixEmpty((String)notifier.getRoom()) != null ? notifier.getRoom() : descriptor.getRoom();
        String credentialId = this.storeCredential(descriptor, credentials, room, notifier.getToken());
        notifier.setToken(null);
        notifier.setCredentialId(credentialId);
    }

    private String storeCredential(HipChatNotifier.DescriptorImpl descriptor, List<StringCredentials> credentials, String room, String token) throws IOException {
        String server = descriptor.getServer();
        ArrayList<String> takenIds = new ArrayList<String>();
        for (StringCredentials credential : credentials) {
            takenIds.add(credential.getId());
            if (!credential.getId().startsWith("HipChat-") || !token.equals(Secret.toString((Secret)credential.getSecret()))) continue;
            return credential.getId();
        }
        CredentialsStore store = (CredentialsStore)CredentialsProvider.lookupStores((ModelObject)Jenkins.getInstance()).iterator().next();
        String id = this.generateCredentialId(descriptor, takenIds, room);
        StringCredentialsImpl credential = new StringCredentialsImpl(CredentialsScope.GLOBAL, id, id, Secret.fromString((String)token));
        if (store.isDomainsModifiable()) {
            Domain domain = store.getDomainByName(server);
            if (domain == null) {
                ArrayList<Object> specs = new ArrayList<Object>();
                specs.add(new HostnameSpecification(server, null));
                specs.add(new SchemeSpecification("https"));
                domain = new Domain(server, null, specs);
                store.addDomain(domain, new Credentials[]{credential});
            } else {
                store.addCredentials(domain, (Credentials)credential);
            }
        } else {
            store.addCredentials(Domain.global(), (Credentials)credential);
        }
        return credential.getId();
    }

    private String getCurrentlySelectedCredentialId(Item item, String globalCredentialId) {
        if (item == null) {
            return globalCredentialId;
        }
        if (item instanceof AbstractProject) {
            HipChatNotifier notifier = (HipChatNotifier)((AbstractProject)item).getPublishersList().get(HipChatNotifier.class);
            return notifier == null ? null : notifier.getCredentialId();
        }
        return null;
    }

    private String generateCredentialId(HipChatNotifier.DescriptorImpl descriptor, List<String> takenIds, String room) {
        String id;
        room = Util.fixEmpty((String)room) == null ? UUID.randomUUID().toString() : room.split(",")[0];
        String candidate = id = "HipChat-" + (descriptor.isV2Enabled() ? room + "-Token" : "API-Token").replaceAll("[^a-zA-Z0-9_.-]", "_");
        int i = 2;
        while (takenIds.contains(candidate)) {
            candidate = id + "-" + i++;
        }
        return candidate;
    }

    private List<DomainRequirement> requirements(String server) {
        return URIRequirementBuilder.fromUri((String)("https://" + server)).build();
    }
}

