/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.hipchat.model.notifications;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import jenkins.plugins.hipchat.model.notifications.Card;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"from", "message_format", "color", "attach_to", "notify", "message", "card"})
public class Notification {
    @JsonProperty(value="from")
    private String from;
    @JsonProperty(value="message_format")
    private MessageFormat messageFormat = MessageFormat.fromValue("html");
    @JsonProperty(value="color")
    private Color color = Color.fromValue("yellow");
    @JsonProperty(value="attach_to")
    private String attachTo;
    @JsonProperty(value="notify")
    private boolean notify = false;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="card")
    private Card card;

    @JsonProperty(value="from")
    public String getFrom() {
        return this.from;
    }

    @JsonProperty(value="from")
    public void setFrom(String from) {
        this.from = from;
    }

    public Notification withFrom(String from) {
        this.from = from;
        return this;
    }

    @JsonProperty(value="message_format")
    public MessageFormat getMessageFormat() {
        return this.messageFormat;
    }

    @JsonProperty(value="message_format")
    public void setMessageFormat(MessageFormat messageFormat) {
        this.messageFormat = messageFormat;
    }

    public Notification withMessageFormat(MessageFormat messageFormat) {
        this.messageFormat = messageFormat;
        return this;
    }

    @JsonProperty(value="color")
    public Color getColor() {
        return this.color;
    }

    @JsonProperty(value="color")
    public void setColor(Color color) {
        this.color = color;
    }

    public Notification withColor(Color color) {
        this.color = color;
        return this;
    }

    @JsonProperty(value="attach_to")
    public String getAttachTo() {
        return this.attachTo;
    }

    @JsonProperty(value="attach_to")
    public void setAttachTo(String attachTo) {
        this.attachTo = attachTo;
    }

    public Notification withAttachTo(String attachTo) {
        this.attachTo = attachTo;
        return this;
    }

    @JsonProperty(value="notify")
    public boolean isNotify() {
        return this.notify;
    }

    @JsonProperty(value="notify")
    public void setNotify(boolean notify) {
        this.notify = notify;
    }

    public Notification withNotify(boolean notify) {
        this.notify = notify;
        return this;
    }

    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    public void setMessage(String message) {
        this.message = message;
    }

    public Notification withMessage(String message) {
        this.message = message;
        return this;
    }

    @JsonProperty(value="card")
    public Card getCard() {
        return this.card;
    }

    @JsonProperty(value="card")
    public void setCard(Card card) {
        this.card = card;
    }

    public Notification withCard(Card card) {
        this.card = card;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.from).append((Object)this.messageFormat).append((Object)this.color).append((Object)this.attachTo).append(this.notify).append((Object)this.message).append((Object)this.card).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Notification)) {
            return false;
        }
        Notification rhs = (Notification)other;
        return new EqualsBuilder().append((Object)this.from, (Object)rhs.from).append((Object)this.messageFormat, (Object)rhs.messageFormat).append((Object)this.color, (Object)rhs.color).append((Object)this.attachTo, (Object)rhs.attachTo).append(this.notify, rhs.notify).append((Object)this.message, (Object)rhs.message).append((Object)this.card, (Object)rhs.card).isEquals();
    }

    public static enum MessageFormat {
        HTML("html"),
        TEXT("text");

        private final String value;
        private static final Map<String, MessageFormat> CONSTANTS;

        private MessageFormat(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MessageFormat fromValue(String value) {
            MessageFormat constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, MessageFormat>();
            for (MessageFormat c : MessageFormat.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum Color {
        YELLOW("yellow"),
        GREEN("green"),
        RED("red"),
        PURPLE("purple"),
        GRAY("gray"),
        RANDOM("random");

        private final String value;
        private static final Map<String, Color> CONSTANTS;

        private Color(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Color fromValue(String value) {
            Color constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Color>();
            for (Color c : Color.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

