/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.hipchat.model.notifications;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"value", "format"})
public class Description {
    @JsonProperty(value="value")
    private String value;
    @JsonProperty(value="format")
    private Format format;

    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    public void setValue(String value) {
        this.value = value;
    }

    public Description withValue(String value) {
        this.value = value;
        return this;
    }

    @JsonProperty(value="format")
    public Format getFormat() {
        return this.format;
    }

    @JsonProperty(value="format")
    public void setFormat(Format format) {
        this.format = format;
    }

    public Description withFormat(Format format) {
        this.format = format;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.value).append((Object)this.format).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Description)) {
            return false;
        }
        Description rhs = (Description)other;
        return new EqualsBuilder().append((Object)this.value, (Object)rhs.value).append((Object)this.format, (Object)rhs.format).isEquals();
    }

    public static enum Format {
        HTML("html"),
        TEXT("text");

        private final String value;
        private static final Map<String, Format> CONSTANTS;

        private Format(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Format fromValue(String value) {
            Format constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Format>();
            for (Format c : Format.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

