/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.hipchat.model;

import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import jenkins.model.Jenkins;
import jenkins.plugins.hipchat.model.NotificationType;
import jenkins.plugins.hipchat.model.notifications.Icon;
import jenkins.plugins.hipchat.model.notifications.Notification;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class NotificationConfig
implements Describable<NotificationConfig> {
    private final boolean notifyEnabled;
    private final boolean textFormat;
    private final NotificationType notificationType;
    private final Notification.Color color;
    private final String icon;
    private final String messageTemplate;

    @DataBoundConstructor
    public NotificationConfig(boolean notifyEnabled, boolean textFormat, NotificationType notificationType, Notification.Color color, String icon, String messageTemplate) {
        this.notifyEnabled = notifyEnabled;
        this.textFormat = textFormat;
        this.notificationType = notificationType;
        this.color = color;
        this.icon = icon;
        this.messageTemplate = messageTemplate;
    }

    public boolean isNotifyEnabled() {
        return this.notifyEnabled;
    }

    public NotificationType getNotificationType() {
        return this.notificationType;
    }

    public boolean isTextFormat() {
        return this.textFormat;
    }

    public Notification.Color getColor() {
        return this.color;
    }

    public String getIcon() {
        return this.icon;
    }

    public Icon getIconObject() {
        return StringUtils.isEmpty((String)this.icon) ? null : new Icon().withUrl(this.icon);
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public NotificationConfig overrideMessageTemplate(String messageTemplate) {
        return new NotificationConfig(this.notifyEnabled, this.textFormat, this.notificationType, this.color, this.icon, messageTemplate);
    }

    public Descriptor<NotificationConfig> getDescriptor() {
        return Jenkins.getInstance().getDescriptorByType(DescriptorImpl.class);
    }

    public String toString() {
        return "Notification{notifyEnabled=" + this.notifyEnabled + ", notificationType=" + (Object)((Object)this.notificationType) + ", color=" + (Object)((Object)this.color) + ", icon=" + this.icon + ", messageTemplate=" + this.messageTemplate + '}';
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<NotificationConfig> {
        public String getDisplayName() {
            return "HipChat Notification";
        }
    }
}

