/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.hipchat.ext.tokens;

import com.google.common.collect.ListMultimap;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.test.AbstractTestResultAction;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;

@Extension
public class TestReportUrlMacro
extends TokenMacro {
    public boolean acceptsMacroName(String macroName) {
        return "TEST_REPORT_URL".equals(macroName);
    }

    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName, Map<String, String> arguments, ListMultimap<String, String> argumentMultimap) {
        return this.evaluate((Run<?, ?>)context, null, listener, macroName, arguments, argumentMultimap);
    }

    public String evaluate(Run<?, ?> run, FilePath workspace, TaskListener listener, String macroName, Map<String, String> arguments, ListMultimap<String, String> argumentMultimap) {
        AbstractTestResultAction testResults = (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
        if (testResults != null) {
            return "${BUILD_URL}" + testResults.getUrlName();
        }
        return "";
    }

    public boolean hasNestedContent() {
        return true;
    }

    public List<String> getAcceptedMacroNames() {
        return Collections.singletonList("TEST_REPORT_URL");
    }
}

