/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.fitnesse;

import hudson.Launcher;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;

final class StdConsole {
    private final ByteArrayOutputStream stdout;
    private final ByteArrayOutputStream stderr;
    private int stdOutMark;
    private int stdErrMark;

    public StdConsole() {
        this(new ByteArrayOutputStream(), new ByteArrayOutputStream());
    }

    public void provideStdOutAndStdErrFor(Launcher.ProcStarter procStarter) {
        procStarter.stdout((OutputStream)this.stdout).stderr((OutputStream)this.stderr);
    }

    public StdConsole(ByteArrayOutputStream stdout, ByteArrayOutputStream stderr) {
        this.stdout = stdout;
        this.stderr = stderr;
        this.stdOutMark = 0;
        this.stdErrMark = 0;
    }

    public void logOutput(PrintStream logger) {
        this.stdOutMark = this.logAndMark(logger, this.stdout, this.stdOutMark);
        this.stdErrMark = this.logAndMark(logger, this.stderr, this.stdErrMark);
    }

    private int logAndMark(PrintStream logger, ByteArrayOutputStream bytes, int mark) {
        int size = bytes.size();
        logger.println(new String(bytes.toByteArray(), mark, size - mark));
        return size;
    }

    public boolean noOutputOnStdOut() {
        return this.stdout.size() == 0;
    }

    public boolean outputOnStdErr() {
        return this.stderr.size() > 0;
    }

    public boolean stdErrStartsWith(String prefix) {
        byte[] eBytes;
        byte[] pBytes = prefix.getBytes();
        if (pBytes.length > (eBytes = this.stderr.toByteArray()).length) {
            return false;
        }
        for (int i = 0; i < pBytes.length; ++i) {
            if (pBytes[i] == eBytes[i]) continue;
            return false;
        }
        return true;
    }
}

