/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.fitnesse;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.fitnesse.FitnesseResults;
import hudson.plugins.fitnesse.FitnesseResultsAction;
import hudson.plugins.fitnesse.NativePageCounts;
import hudson.plugins.fitnesse.NativePageCountsParser;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.servlet.ServletException;
import javax.xml.transform.TransformerException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FitnesseResultsRecorder
extends Recorder {
    private final String fitnessePathToXmlResultsIn;

    @DataBoundConstructor
    public FitnesseResultsRecorder(String fitnessePathToXmlResultsIn) throws TransformerException {
        this.fitnessePathToXmlResultsIn = fitnessePathToXmlResultsIn;
    }

    public String getFitnessePathToXmlResultsIn() {
        return this.fitnessePathToXmlResultsIn;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        try {
            File resultsFile = new File(this.fitnessePathToXmlResultsIn);
            FitnesseResults results = this.getResults(listener, resultsFile);
            FitnesseResultsAction action = new FitnesseResultsAction(build, results);
            if (results.getBuildResult() != null) {
                build.setResult(results.getBuildResult());
            }
            build.addAction((Action)action);
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace(listener.getLogger());
            if (t instanceof InterruptedException) {
                throw (InterruptedException)t;
            }
            build.setResult(Result.FAILURE);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FitnesseResults getResults(BuildListener listener, File resultsFile) throws IOException, TransformerException {
        InputStream resultsInputStream = null;
        try {
            listener.getLogger().println("Reading results as " + Charset.defaultCharset().displayName() + " from " + resultsFile.getAbsolutePath());
            resultsInputStream = new BufferedInputStream(new FileInputStream(resultsFile));
            listener.getLogger().println("Parsing results... ");
            NativePageCountsParser pageCountsParser = new NativePageCountsParser();
            NativePageCounts pageCounts = pageCountsParser.parse(resultsInputStream);
            listener.getLogger().println("Got results: " + pageCounts.getSummary());
            FitnesseResults fitnesseResults = new FitnesseResults(pageCounts);
            return fitnesseResults;
        }
        finally {
            if (resultsInputStream != null) {
                try {
                    resultsInputStream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public FormValidation doCheckFitnessePathToXmlResultsIn(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please specify where to read fitnesse results from.");
            }
            File file = new File(value);
            if (!(file.exists() || file.getParent() != null && file.getParentFile().exists())) {
                return FormValidation.warning((String)"Path does not exist.");
            }
            if (!value.endsWith("xml")) {
                return FormValidation.warning((String)"Location does not end with 'xml': is that correct?");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Publish Fitnesse results report";
        }
    }
}

