/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.fitnesse;

import hudson.model.AbstractBuild;
import hudson.plugins.fitnesse.FitnesseResultsAction;
import hudson.plugins.fitnesse.NativePageCounts;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestObject;
import hudson.tasks.test.TestResult;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FitnesseResults
extends TestResult
implements Comparable<FitnesseResults> {
    private static final long serialVersionUID = 1L;
    private transient long durationInMillis = -1L;
    private transient List<FitnesseResults> failed = null;
    private transient List<FitnesseResults> skipped = null;
    private transient List<FitnesseResults> passed = null;
    private NativePageCounts.Counts pageCounts;
    private TestObject parent;
    private List<FitnesseResults> details = new ArrayList<FitnesseResults>();
    private AbstractBuild<?, ?> owner;

    public FitnesseResults(NativePageCounts.Counts pageCounts) {
        this.pageCounts = pageCounts;
    }

    FitnesseResults(NativePageCounts allCounts) {
        this(allCounts.getSummary());
        for (NativePageCounts.Counts detail : allCounts.getDetails()) {
            this.addDetail(new FitnesseResults(detail));
        }
    }

    void addDetail(FitnesseResults fitnesseResults) {
        this.details.add(fitnesseResults);
        fitnesseResults.setParent((TestObject)this);
    }

    public TestResult findCorrespondingResult(final String id) {
        if (id.equals(this.getId())) {
            return this;
        }
        List<FitnesseResults> match = this.filteredCopyOfDetails(new ResultsFilter(){

            public boolean include(FitnesseResults fitnesseResults) {
                return id.equals(fitnesseResults.getId());
            }
        });
        return match.size() == 0 ? null : match.get(0);
    }

    public void setOwner(AbstractBuild<?, ?> build) {
        this.owner = build;
    }

    public AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public void setParent(TestObject parentObject) {
        this.parent = parentObject;
    }

    public TestObject getParent() {
        return this.parent;
    }

    public String getName() {
        return this.pageCounts.page;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public int getFailCount() {
        return this.pageCounts.wrong;
    }

    public int getPassCount() {
        return this.pageCounts.right;
    }

    public int getSkipCount() {
        return this.pageCounts.ignored + this.pageCounts.exceptions;
    }

    public float getDuration() {
        if (this.durationInMillis == -1L) {
            this.calculateDurationInMillis();
        }
        return (float)this.durationInMillis / 1000.0f;
    }

    private void calculateDurationInMillis() {
        FitnesseResults earliest = null;
        FitnesseResults latest = null;
        for (FitnesseResults detail : this.details) {
            if (earliest == null) {
                earliest = detail;
            } else if (detail.isEarlierThan(earliest)) {
                earliest = detail;
            }
            if (latest == null) {
                latest = detail;
                continue;
            }
            if (!detail.isLaterThan(latest)) continue;
            latest = detail;
        }
        this.durationInMillis = latest.millisAfter(earliest);
    }

    public boolean isEarlierThan(FitnesseResults other) {
        try {
            return this.pageCounts.resultsDateAsDate().before(other.pageCounts.resultsDateAsDate());
        }
        catch (ParseException e) {
            return false;
        }
    }

    public boolean isLaterThan(FitnesseResults other) {
        try {
            return this.pageCounts.resultsDateAsDate().after(other.pageCounts.resultsDateAsDate());
        }
        catch (ParseException e) {
            return false;
        }
    }

    public long millisAfter(FitnesseResults other) {
        try {
            return this.pageCounts.resultsDateAsDate().getTime() - other.pageCounts.resultsDateAsDate().getTime();
        }
        catch (ParseException e) {
            return 0L;
        }
    }

    public String getHeadlineText() {
        return this.pageCounts.toString();
    }

    public AbstractTestResultAction<?> getTestResultAction() {
        if (super.getTestResultAction() == null) {
            return null;
        }
        FitnesseResultsAction action = (FitnesseResultsAction)this.getOwner().getAction(FitnesseResultsAction.class);
        return action;
    }

    @Override
    public int compareTo(FitnesseResults other) {
        return this.getDisplayName().compareTo(other.getDisplayName());
    }

    public Collection<FitnesseResults> getFailedTests() {
        if (this.failed == null) {
            this.failed = this.filteredCopyOfDetails(new ResultsFilter(){

                public boolean include(FitnesseResults results) {
                    return results.getFailCount() > 0;
                }
            });
        }
        return this.failed;
    }

    public Collection<FitnesseResults> getPassedTests() {
        if (this.passed == null) {
            this.passed = this.filteredCopyOfDetails(new ResultsFilter(){

                public boolean include(FitnesseResults results) {
                    return results.getPassCount() > 0 && results.getPassCount() == results.getTotalCount();
                }
            });
        }
        return this.passed;
    }

    public Collection<FitnesseResults> getSkippedTests() {
        if (this.skipped == null) {
            this.skipped = this.filteredCopyOfDetails(new ResultsFilter(){

                public boolean include(FitnesseResults results) {
                    return results.getTotalCount() == 0 || results.getFailCount() == 0 && results.getSkipCount() > 0;
                }
            });
        }
        return this.skipped;
    }

    private List<FitnesseResults> filteredCopyOfDetails(ResultsFilter countsFilter) {
        ArrayList<FitnesseResults> filteredCopy = new ArrayList<FitnesseResults>();
        for (FitnesseResults result : this.details) {
            if (!countsFilter.include(result)) continue;
            filteredCopy.add(result);
        }
        Collections.sort(filteredCopy);
        return filteredCopy;
    }

    static interface ResultsFilter {
        public boolean include(FitnesseResults var1);
    }
}

