/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.fitnesse;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.fitnesse.FitnesseBuilder;
import hudson.plugins.fitnesse.StdConsole;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FitnesseExecutor {
    private static final int SLEEP_MILLIS = 500;
    private static final int TIMEOUT_MILLIS = 9000;
    private final FitnesseBuilder builder;

    public FitnesseExecutor(FitnesseBuilder builder) {
        this.builder = builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        Proc fitnesseProc = null;
        StdConsole console = new StdConsole();
        try {
            if (this.builder.getFitnesseStart()) {
                listener.getLogger().println("Starting new Fitnesse instance...");
                fitnesseProc = this.startFitnesse(launcher, build.getEnvironment((TaskListener)listener), console);
                if (!this.procStarted(fitnesseProc, listener.getLogger(), console)) {
                    boolean bl = false;
                    this.killProc(listener.getLogger(), fitnesseProc);
                    console.logOutput(listener.getLogger());
                    return bl;
                }
                console.logOutput(listener.getLogger());
            }
            this.writeFitnesseResults(listener.getLogger(), this.builder.getFitnessePathToXmlResultsOut(), this.getHttpBytes(listener.getLogger(), this.getFitnessePageCmdURL()));
            if (console.outputOnStdErr()) {
                build.setResult(Result.UNSTABLE);
            }
            boolean bl = true;
            this.killProc(listener.getLogger(), fitnesseProc);
            console.logOutput(listener.getLogger());
            return bl;
        }
        catch (Throwable t) {
            try {
                t.printStackTrace(listener.getLogger());
                if (t instanceof InterruptedException) {
                    throw (InterruptedException)t;
                }
                boolean bl = false;
                this.killProc(listener.getLogger(), fitnesseProc);
                console.logOutput(listener.getLogger());
                return bl;
            }
            catch (Throwable throwable) {
                this.killProc(listener.getLogger(), fitnesseProc);
                console.logOutput(listener.getLogger());
                throw throwable;
            }
        }
    }

    private Proc startFitnesse(Launcher launcher, EnvVars envVars, StdConsole console) throws IOException {
        Launcher.ProcStarter procStarter = launcher.launch().cmds(this.getJavaCmd(envVars));
        console.provideStdOutAndStdErrFor(procStarter);
        return procStarter.start();
    }

    public ArrayList<String> getJavaCmd(EnvVars envVars) {
        String fitnesseJavaOpts;
        String java = "java";
        if (envVars.containsKey((Object)"JAVA_HOME")) {
            java = new File(new File((String)envVars.get((Object)"JAVA_HOME"), "bin"), java).getAbsolutePath();
        }
        String[] java_opts = "".equals(fitnesseJavaOpts = this.builder.getFitnesseJavaOpts()) ? new String[]{} : fitnesseJavaOpts.split(" ");
        String[] jar_opts = new String[]{"-jar", this.builder.getFitnessePathToJar()};
        String[] fitnesse_opts = new String[]{"-d", this.getFitnesseDir(), "-r", this.getFitnesseRoot(), "-p", Integer.toString(this.builder.getFitnessePort())};
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(java);
        if (java_opts.length > 0) {
            cmd.addAll(Arrays.asList(java_opts));
        }
        cmd.addAll(Arrays.asList(jar_opts));
        cmd.addAll(Arrays.asList(fitnesse_opts));
        return cmd;
    }

    public String getFitnesseDir() {
        return new File(this.builder.getFitnessePathToRoot()).getParentFile().getAbsolutePath();
    }

    public String getFitnesseRoot() {
        return new File(this.builder.getFitnessePathToRoot()).getName();
    }

    private boolean procStarted(Proc fitnesseProc, PrintStream log, StdConsole console) throws IOException, InterruptedException {
        if (fitnesseProc.isAlive()) {
            return this.procStarted(log, console, 9000L);
        }
        return false;
    }

    public boolean procStarted(PrintStream log, StdConsole console, long timeout) throws InterruptedException {
        long waitedAlready = 0L;
        do {
            if (waitedAlready > 0L) {
                log.print('.');
            }
            Thread.sleep(500L);
        } while (console.noOutputOnStdOut() && (waitedAlready += 500L) < timeout);
        if (!console.stdErrStartsWith("Unpacking") && console.noOutputOnStdOut()) {
            log.println("Waited " + waitedAlready + "ms for fitnesse to start.");
            return false;
        }
        return true;
    }

    private void killProc(PrintStream log, Proc proc) {
        if (proc != null) {
            try {
                proc.kill();
                for (int i = 0; i < 4; ++i) {
                    if (!proc.isAlive()) continue;
                    Thread.sleep(500L);
                }
            }
            catch (Exception e) {
                e.printStackTrace(log);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getHttpBytes(PrintStream log, URL pageCmdTarget) throws MalformedURLException, IOException {
        log.println("Connnecting to " + pageCmdTarget);
        HttpURLConnection connection = (HttpURLConnection)pageCmdTarget.openConnection();
        log.println("Connected: " + connection.getResponseCode() + "/" + connection.getResponseMessage());
        BufferedInputStream inputStream = null;
        try {
            int lastRead;
            inputStream = new BufferedInputStream(connection.getInputStream());
            ByteArrayOutputStream bucket = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((lastRead = ((InputStream)inputStream).read(buf)) > 0) {
                bucket.write(buf, 0, lastRead);
            }
            byte[] byArray = bucket.toByteArray();
            return byArray;
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Exception e) {}
            }
        }
    }

    public URL getFitnessePageCmdURL() throws MalformedURLException {
        return new URL("http", this.builder.getFitnesseStart() ? "localhost" : this.builder.getFitnesseHost(), this.builder.getFitnessePort(), this.getFitnessePageCmd());
    }

    public String getFitnessePageCmd() {
        String targetPageExpression = this.builder.getFitnesseTargetPage();
        if (targetPageExpression.contains("?")) {
            return "/" + targetPageExpression + "&format=xml";
        }
        int pos = targetPageExpression.indexOf(38);
        if (pos == -1) {
            pos = targetPageExpression.length();
        }
        return String.format("/%1$s?%2$s%3$s", targetPageExpression.substring(0, pos), this.builder.getFitnesseTargetIsSuite() ? "suite" : "test", targetPageExpression.substring(pos) + "&format=xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFitnesseResults(PrintStream log, String resultsFileName, byte[] results) throws IOException, InterruptedException {
        OutputStream resultsStream = null;
        try {
            resultsStream = new BufferedOutputStream(new FileOutputStream(resultsFileName));
            resultsStream.write(results);
            log.println("Xml results saved as " + Charset.defaultCharset().displayName() + " to " + resultsFileName);
        }
        finally {
            try {
                if (resultsStream != null) {
                    resultsStream.close();
                }
            }
            catch (Exception e) {}
        }
    }
}

