/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.fitnesse;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.plugins.fitnesse.FitnesseExecutor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FitnesseBuilder
extends Builder {
    public static final String START_FITNESSE = "fitnesseStart";
    public static final String FITNESSE_HOST = "fitnesseHost";
    public static final String FITNESSE_PORT = "fitnessePort";
    public static final String FITNESSE_PORT_REMOTE = "fitnessePortRemote";
    public static final String FITNESSE_PORT_LOCAL = "fitnessePortLocal";
    public static final String JAVA_OPTS = "fitnesseJavaOpts";
    public static final String PATH_TO_JAR = "fitnessePathToJar";
    public static final String PATH_TO_ROOT = "fitnessePathToRoot";
    public static final String TARGET_PAGE = "fitnesseTargetPage";
    public static final String TARGET_IS_SUITE = "fitnesseTargetIsSuite";
    public static final String PATH_TO_RESULTS = "fitnessePathToXmlResultsOut";
    private Map<String, String> options;

    @DataBoundConstructor
    public FitnesseBuilder(Map<String, String> options) {
        this.options = options;
    }

    private String getOption(String key, String valueIfKeyNotFound) {
        String value;
        if (this.options.containsKey(key) && (value = this.options.get(key)) != null && value != "") {
            return value;
        }
        return valueIfKeyNotFound;
    }

    public boolean getFitnesseStart() {
        return Boolean.parseBoolean(this.getOption(START_FITNESSE, "False"));
    }

    public String getFitnesseHost() {
        return this.getOption(FITNESSE_HOST, "unknown_host");
    }

    public String getFitnesseJavaOpts() {
        return this.getOption(JAVA_OPTS, "");
    }

    public int getFitnessePort() {
        return Integer.parseInt(this.getOption(FITNESSE_PORT_REMOTE, this.getOption(FITNESSE_PORT_LOCAL, this.getOption(FITNESSE_PORT, "-1"))));
    }

    public String getFitnessePathToJar() {
        return this.getOption(PATH_TO_JAR, "");
    }

    public String getFitnessePathToRoot() {
        return this.getOption(PATH_TO_ROOT, "");
    }

    public String getFitnesseTargetPage() {
        return this.getOption(TARGET_PAGE, "");
    }

    public boolean getFitnesseTargetIsSuite() {
        return Boolean.parseBoolean(this.getOption(TARGET_IS_SUITE, "False"));
    }

    public String getFitnessePathToXmlResultsOut() {
        return this.getOption(PATH_TO_RESULTS, "");
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        listener.getLogger().println("Building with options: " + this.options);
        return new FitnesseExecutor(this).execute(build, launcher, listener);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public FormValidation doCheckFitnesseHost(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please specify the host of the fitnesse instance.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFitnessePort(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please specify the fitnesse port.");
            }
            try {
                int intValue = Integer.parseInt(value);
                if (intValue < 1) {
                    return FormValidation.error((String)"Port must be a positive integer.");
                }
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Port must be a number.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFitnesseJavaOpts(@QueryParameter String value) throws IOException, ServletException {
            return FormValidation.ok();
        }

        public FormValidation doCheckFitnessePathToJar(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please specify the path to 'fitnesse.jar'.");
            }
            if (!new File(value).exists()) {
                return FormValidation.warning((String)"Path does not exist.");
            }
            if (!value.endsWith("fitnesse.jar") && new File(value, "fitnesse.jar").exists()) {
                return FormValidation.warning((String)"Path does not end with 'fitnesse.jar': is that correct?");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFitnessePathToRoot(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please specify the location of 'FitNesseRoot'.");
            }
            if (!new File(value).exists()) {
                return FormValidation.warning((String)"Path does not exist.");
            }
            if (!value.endsWith("FitNesseRoot") && new File(value, "FitNesseRoot").exists()) {
                return FormValidation.warning((String)"Path does not end with 'FitNesseRoot': is that correct?");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFitnesseTargetPage(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please specify a page to execute.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFitnesseTargetIsSuite(@QueryParameter String value) throws IOException, ServletException {
            return FormValidation.ok();
        }

        public FormValidation doCheckFitnessePathToXmlResultsOut(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please specify where to write fitnesse results to.");
            }
            File file = new File(value);
            if (!(file.exists() || file.getParent() != null && file.getParentFile().exists())) {
                return FormValidation.warning((String)"Path does not exist.");
            }
            if (!value.endsWith("xml")) {
                return FormValidation.warning((String)"Location does not end with 'xml': is that correct?");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Execute fitnesse tests";
        }

        public FitnesseBuilder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String startFitnesseValue = formData.getJSONObject(FitnesseBuilder.START_FITNESSE).getString("value");
            if (Boolean.parseBoolean(startFitnesseValue)) {
                return this.newFitnesseBuilder(startFitnesseValue, this.collectFormData(formData, new String[]{FitnesseBuilder.JAVA_OPTS, FitnesseBuilder.PATH_TO_JAR, FitnesseBuilder.PATH_TO_ROOT, FitnesseBuilder.FITNESSE_PORT_LOCAL, FitnesseBuilder.TARGET_PAGE, FitnesseBuilder.TARGET_IS_SUITE, FitnesseBuilder.PATH_TO_RESULTS}));
            }
            return this.newFitnesseBuilder(startFitnesseValue, this.collectFormData(formData, new String[]{FitnesseBuilder.FITNESSE_HOST, FitnesseBuilder.FITNESSE_PORT_REMOTE, FitnesseBuilder.TARGET_PAGE, FitnesseBuilder.TARGET_IS_SUITE, FitnesseBuilder.PATH_TO_RESULTS}));
        }

        private FitnesseBuilder newFitnesseBuilder(String startFitnesseValue, Map<String, String> collectedFormData) {
            collectedFormData.put(FitnesseBuilder.START_FITNESSE, startFitnesseValue);
            return new FitnesseBuilder(collectedFormData);
        }

        private Map<String, String> collectFormData(JSONObject formData, String[] keys) {
            HashMap<String, String> targetElements = new HashMap<String, String>();
            for (String key : keys) {
                if (formData.has(key)) {
                    targetElements.put(key, formData.getString(key));
                    continue;
                }
                targetElements.put(key, formData.getJSONObject(FitnesseBuilder.START_FITNESSE).getString(key));
            }
            return targetElements;
        }
    }
}

