/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.parser;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

@SuppressFBWarnings(value={""})
public final class HexishString
implements Serializable {
    private static final long serialVersionUID = 2925134919588181979L;
    private final Serializable content;

    public HexishString(String value) {
        if (this.isHex(value)) {
            try {
                this.content = Hex.decodeHex((char[])value.toCharArray());
            }
            catch (DecoderException e) {
                throw new AssertionError((Object)e);
            }
        } else {
            this.content = value.toCharArray();
        }
    }

    public String toString() {
        if (this.content instanceof char[]) {
            return new String((char[])this.content);
        }
        return Hex.encodeHexString((byte[])((byte[])this.content));
    }

    public boolean equals(Object that) {
        return that instanceof HexishString && this.toString().equals(that.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private boolean isHex(String value) {
        int len = value.length();
        if (len % 2 == 1) {
            return false;
        }
        for (int i = len - 1; i >= 0; --i) {
            char ch = value.charAt(i);
            if ('0' <= ch && ch <= '9' || 'a' <= ch && ch <= 'f') continue;
            return false;
        }
        return true;
    }

    public static HexishString of(String s) {
        return s == null ? null : new HexishString(s);
    }

    public static final class ConverterImpl
    extends AbstractSingleValueConverter {
        public ConverterImpl(XStream xs) {
        }

        public Object fromString(String str) {
            return new HexishString(str);
        }

        public boolean canConvert(Class type) {
            return type == HexishString.class;
        }
    }
}

