/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.favorite.user;

import hudson.Extension;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean(defaultVisibility=999)
public class FavoriteUserProperty
extends UserProperty {
    @Extension
    public static final UserPropertyDescriptor DESCRIPTOR = new DescriptorImpl();
    private ArrayList<String> favorites = new ArrayList();

    @DataBoundConstructor
    public FavoriteUserProperty() {
        this.getDescriptor();
    }

    public ArrayList<String> getFavorites() {
        return this.favorites;
    }

    public void addFavorite(String job) throws IOException {
        this.favorites.add(job);
        this.user.save();
    }

    public void removeFavorite(String job) throws IOException {
        this.favorites.remove(job);
        this.user.save();
    }

    public void toggleFavorite(String job) throws IOException {
        if (this.isJobFavorite(job)) {
            this.removeFavorite(job);
        } else {
            this.addFavorite(job);
        }
    }

    public boolean isJobFavorite(String job) {
        return this.favorites.contains(job);
    }

    public UserPropertyDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    private static class DescriptorImpl
    extends UserPropertyDescriptor {
        public DescriptorImpl() {
            super(FavoriteUserProperty.class);
        }

        public UserProperty newInstance(User user) {
            return new FavoriteUserProperty();
        }

        public String getDisplayName() {
            return "Favorites";
        }
    }
}

