/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.favorite.filter;

import hudson.model.Hudson;
import hudson.model.TopLevelItem;
import hudson.model.User;
import hudson.model.View;
import hudson.plugins.favorite.user.FavoriteUserProperty;
import hudson.views.ViewJobFilter;
import java.util.ArrayList;
import java.util.List;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FavoriteFilter
extends ViewJobFilter {
    @DataBoundConstructor
    public FavoriteFilter() {
    }

    public List<TopLevelItem> filter(List<TopLevelItem> added, List<TopLevelItem> all, View filteringView) {
        ArrayList<TopLevelItem> filtered = new ArrayList<TopLevelItem>(added);
        Authentication authentication = Hudson.getAuthentication();
        String name = authentication.getName();
        if (authentication.isAuthenticated()) {
            User user = Hudson.getInstance().getUser(name);
            FavoriteUserProperty fup = (FavoriteUserProperty)user.getProperty(FavoriteUserProperty.class);
            for (TopLevelItem item : all) {
                if (fup != null && fup.isJobFavorite(item.getName())) continue;
                filtered.remove(item);
            }
        }
        return filtered;
    }
}

