/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.favorite.column;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.User;
import hudson.plugins.favorite.user.FavoriteUserProperty;
import hudson.views.ListViewColumn;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FavoriteColumn
extends ListViewColumn {
    @Extension
    public static final Descriptor<ListViewColumn> DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public FavoriteColumn() {
    }

    public Descriptor<ListViewColumn> getDescriptor() {
        return DESCRIPTOR;
    }

    public String getStar(String job) {
        Authentication authentication = Hudson.getAuthentication();
        String name = authentication.getName();
        User user = Hudson.getInstance().getUser(name);
        FavoriteUserProperty fup = (FavoriteUserProperty)user.getProperty(FavoriteUserProperty.class);
        if (fup == null || !fup.isJobFavorite(job)) {
            return "star.gif";
        }
        return "star-gold.gif";
    }

    public String getUserId() {
        Authentication authentication = Hudson.getAuthentication();
        return authentication.getName();
    }

    public boolean isLoggedIn() {
        Authentication authentication = Hudson.getAuthentication();
        return !authentication.getName().equals("anonymous");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DescriptorImpl
    extends Descriptor<ListViewColumn> {
        private DescriptorImpl() {
        }

        public ListViewColumn newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new FavoriteColumn();
        }

        public String getDisplayName() {
            return "Favorite";
        }
    }
}

