/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import hudson.Extension;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonEC2Cloud
extends EC2Cloud {
    private static final URL EC2_ENDPOINT;
    private static final URL S3_ENDPOINT;

    @DataBoundConstructor
    public AmazonEC2Cloud(String accessId, String secretKey, String privateKey, String instanceCapStr, List<SlaveTemplate> templates) {
        super("ec2", accessId, secretKey, privateKey, instanceCapStr, templates);
    }

    @Override
    public URL getEc2EndpointUrl() {
        return EC2_ENDPOINT;
    }

    @Override
    public URL getS3EndpointUrl() {
        return S3_ENDPOINT;
    }

    static {
        try {
            EC2_ENDPOINT = new URL("https://ec2.amazonaws.com/");
            S3_ENDPOINT = new URL("https://s3.amazonaws.com/");
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends EC2Cloud.DescriptorImpl {
        public String getDisplayName() {
            return "Amazon EC2";
        }

        public FormValidation doTestConnection(@QueryParameter String accessId, @QueryParameter String secretKey, @QueryParameter String privateKey) throws IOException, ServletException {
            return super.doTestConnection(EC2_ENDPOINT, accessId, secretKey, privateKey);
        }

        public FormValidation doGenerateKey(StaplerResponse rsp, @QueryParameter String accessId, @QueryParameter String secretKey) throws IOException, ServletException {
            return super.doGenerateKey(rsp, EC2_ENDPOINT, accessId, secretKey);
        }
    }
}

