/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.claim;

import hudson.model.BuildBadgeAction;
import hudson.model.Hudson;
import hudson.model.ProminentProjectAction;
import hudson.model.Saveable;
import hudson.model.User;
import hudson.tasks.junit.TestAction;
import java.io.IOException;
import javax.servlet.ServletException;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean(defaultVisibility=2)
public abstract class AbstractClaimBuildAction<T extends Saveable>
extends TestAction
implements BuildBadgeAction,
ProminentProjectAction {
    private static final long serialVersionUID = 1L;
    private boolean claimed;
    private String claimedBy;
    private boolean transientClaim;
    protected T owner;
    private String reason;

    AbstractClaimBuildAction(T owner) {
        this.owner = owner;
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return "claim";
    }

    public void doClaim(StaplerRequest req, StaplerResponse resp) throws ServletException, IOException {
        Authentication authentication = Hudson.getAuthentication();
        String name = authentication.getName();
        String reason = (String)req.getSubmittedForm().get("reason");
        boolean sticky = req.getSubmittedForm().getBoolean("sticky");
        if (StringUtils.isEmpty((String)reason)) {
            reason = null;
        }
        this.claim(name, reason, sticky);
        this.owner.save();
        resp.forwardToPreviousPage(req);
    }

    public void doUnclaim(StaplerRequest req, StaplerResponse resp) throws ServletException, IOException {
        this.unclaim();
        this.owner.save();
        resp.forwardToPreviousPage(req);
    }

    @Exported
    public String getClaimedBy() {
        return this.claimedBy;
    }

    public String getClaimedByName() {
        User user = User.get((String)this.claimedBy, (boolean)false);
        if (user != null) {
            return user.getDisplayName();
        }
        return this.claimedBy;
    }

    public void setClaimedBy(String claimedBy) {
        this.claimedBy = claimedBy;
    }

    @Exported
    public boolean isClaimed() {
        return this.claimed;
    }

    public void claim(String claimedBy, String reason, boolean sticky) {
        this.claimed = true;
        this.claimedBy = claimedBy;
        this.reason = reason;
        this.transientClaim = !sticky;
    }

    public void copyTo(AbstractClaimBuildAction other) {
        other.claim(this.getClaimedBy(), this.getReason(), this.isSticky());
    }

    public void unclaim() {
        this.claimed = false;
        this.claimedBy = null;
        this.transientClaim = false;
    }

    public boolean isClaimedByMe() {
        return !this.isUserAnonymous() && Hudson.getAuthentication().getName().equals(this.claimedBy);
    }

    public boolean canClaim() {
        return !this.isUserAnonymous() && !this.isClaimedByMe();
    }

    public boolean canRelease() {
        return !this.isUserAnonymous() && this.isClaimedByMe();
    }

    public boolean isUserAnonymous() {
        return Hudson.getAuthentication().getName().equals("anonymous");
    }

    @Exported
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public boolean hasReason() {
        return !StringUtils.isEmpty((String)this.reason);
    }

    public boolean isTransient() {
        return this.transientClaim;
    }

    public void setTransient(boolean transientClaim) {
        this.transientClaim = transientClaim;
    }

    public boolean isSticky() {
        return !this.transientClaim;
    }

    public void setSticky(boolean sticky) {
        this.transientClaim = !sticky;
    }

    public abstract String getNoun();
}

