/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.test;

import hudson.plugins.analysis.core.AnnotationDifferencer;
import hudson.plugins.analysis.util.model.AbstractAnnotation;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.Priority;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public abstract class AnnotationDifferencerTest {
    private static final String ANNOTATIONS_ARE_NOT_EQUAL = "Annotations are not equal.";
    private static final String FILE_NAME = "File.c";
    private static final String STRING = "type1";
    private static final String WARNINGS_COUNT_ERROR = "Wrong warnings count.";

    public abstract FileAnnotation createAnnotation(String var1, Priority var2, String var3, String var4, String var5, int var6, int var7);

    @Test
    public void testAnnotationFilename() {
        FileAnnotation annotation = this.createAnnotation("C:\\Path\\File.c", Priority.HIGH, STRING, STRING, STRING, 2, 3);
        Assert.assertEquals((String)ANNOTATIONS_ARE_NOT_EQUAL, (Object)"C:/Path/File.c", (Object)annotation.getFileName());
        Assert.assertEquals((String)ANNOTATIONS_ARE_NOT_EQUAL, (Object)FILE_NAME, (Object)annotation.getShortFileName());
        annotation = this.createAnnotation("/Path/File.c", Priority.HIGH, STRING, STRING, STRING, 2, 3);
        Assert.assertEquals((String)ANNOTATIONS_ARE_NOT_EQUAL, (Object)"/Path/File.c", (Object)annotation.getFileName());
        Assert.assertEquals((String)ANNOTATIONS_ARE_NOT_EQUAL, (Object)FILE_NAME, (Object)annotation.getShortFileName());
        annotation = this.createAnnotation("/File.c", Priority.HIGH, STRING, STRING, STRING, 2, 3);
        Assert.assertEquals((String)ANNOTATIONS_ARE_NOT_EQUAL, (Object)"/File.c", (Object)annotation.getFileName());
        Assert.assertEquals((String)ANNOTATIONS_ARE_NOT_EQUAL, (Object)FILE_NAME, (Object)annotation.getShortFileName());
        annotation = this.createAnnotation(FILE_NAME, Priority.HIGH, STRING, STRING, STRING, 2, 3);
        Assert.assertEquals((String)ANNOTATIONS_ARE_NOT_EQUAL, (Object)FILE_NAME, (Object)annotation.getFileName());
        Assert.assertEquals((String)ANNOTATIONS_ARE_NOT_EQUAL, (Object)FILE_NAME, (Object)annotation.getShortFileName());
    }

    @Test
    public void testWarningEquals() {
        FileAnnotation first = this.createAnnotation(STRING, Priority.HIGH, STRING, STRING, STRING, 2, 3);
        FileAnnotation second = this.createAnnotation(STRING, Priority.HIGH, STRING, STRING, STRING, 2, 3);
        Assert.assertEquals((String)ANNOTATIONS_ARE_NOT_EQUAL, (Object)first, (Object)second);
        FileAnnotation third = this.createAnnotation(STRING, Priority.HIGH, "other", STRING, STRING, 2, 3);
        Assert.assertFalse((String)"Annotations are equal.", (boolean)first.equals(third));
        third = this.createAnnotation(STRING, Priority.HIGH, STRING, STRING, STRING, 3, 2);
        Assert.assertFalse((String)"Annotations are equal.", (boolean)first.equals(third));
    }

    @Test
    public void testDifferencer() {
        HashSet<FileAnnotation> actual = new HashSet<FileAnnotation>();
        HashSet<FileAnnotation> previous = new HashSet<FileAnnotation>();
        FileAnnotation annotation = this.createAnnotation(STRING, Priority.HIGH, STRING, STRING, STRING, 2, 3);
        actual.add(annotation);
        annotation = this.createAnnotation(STRING, Priority.HIGH, STRING, STRING, STRING, 2, 3);
        previous.add(annotation);
        Assert.assertEquals((String)WARNINGS_COUNT_ERROR, (long)0L, (long)AnnotationDifferencer.getFixedAnnotations(actual, previous).size());
        annotation = this.createAnnotation(STRING, Priority.HIGH, "type2", STRING, STRING, 2, 3);
        previous.add(annotation);
        Assert.assertEquals((String)WARNINGS_COUNT_ERROR, (long)0L, (long)AnnotationDifferencer.getNewAnnotations(actual, previous).size());
        Assert.assertEquals((String)WARNINGS_COUNT_ERROR, (long)1L, (long)AnnotationDifferencer.getFixedAnnotations(actual, previous).size());
        annotation = this.createAnnotation(STRING, Priority.HIGH, "type2", STRING, STRING, 2, 3);
        actual.add(annotation);
        Assert.assertEquals((String)WARNINGS_COUNT_ERROR, (long)0L, (long)AnnotationDifferencer.getNewAnnotations(actual, previous).size());
        Assert.assertEquals((String)WARNINGS_COUNT_ERROR, (long)0L, (long)AnnotationDifferencer.getFixedAnnotations(actual, previous).size());
        annotation = this.createAnnotation(STRING, Priority.HIGH, "type3", STRING, STRING, 2, 3);
        actual.add(annotation);
        Assert.assertEquals((String)WARNINGS_COUNT_ERROR, (long)1L, (long)AnnotationDifferencer.getNewAnnotations(actual, previous).size());
        Assert.assertEquals((String)WARNINGS_COUNT_ERROR, (long)0L, (long)AnnotationDifferencer.getFixedAnnotations(actual, previous).size());
    }

    @Test
    public void testHashCodes() {
        HashSet<FileAnnotation> actual = new HashSet<FileAnnotation>();
        HashSet<FileAnnotation> previous = new HashSet<FileAnnotation>();
        FileAnnotation current = this.createAnnotation(STRING, Priority.HIGH, STRING, STRING, STRING, 3, 4);
        actual.add(current);
        FileAnnotation old = this.createAnnotation(STRING, Priority.HIGH, STRING, STRING, STRING, 2, 3);
        previous.add(old);
        Assert.assertEquals((String)WARNINGS_COUNT_ERROR, (long)1L, (long)AnnotationDifferencer.getFixedAnnotations(actual, previous).size());
        Assert.assertEquals((String)WARNINGS_COUNT_ERROR, (long)1L, (long)AnnotationDifferencer.getNewAnnotations(actual, previous).size());
        ((AbstractAnnotation)current).setContextHashCode(0L);
        ((AbstractAnnotation)old).setContextHashCode(0L);
        Assert.assertEquals((String)WARNINGS_COUNT_ERROR, (long)0L, (long)AnnotationDifferencer.getFixedAnnotations(actual, previous).size());
        Assert.assertEquals((String)WARNINGS_COUNT_ERROR, (long)0L, (long)AnnotationDifferencer.getNewAnnotations(actual, previous).size());
    }
}

