/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.test;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.XmlFile;
import hudson.plugins.analysis.Messages;
import hudson.plugins.analysis.test.AbstractEnglishLocaleTest;
import hudson.plugins.analysis.util.model.AbstractAnnotation;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.JavaPackage;
import hudson.plugins.analysis.util.model.JavaProject;
import hudson.plugins.analysis.util.model.LineRange;
import hudson.plugins.analysis.util.model.MavenModule;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.analysis.util.model.WorkspaceFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URISyntaxException;
import java.util.Collection;
import junit.framework.Assert;
import org.apache.commons.lang.StringUtils;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSerializeModelTest
extends AbstractEnglishLocaleTest {
    protected static final String MODULE2 = "Module2";
    protected static final String MODULE1 = "Module1";
    protected static final String PACKAGE2 = "Package2";
    protected static final String PACKAGE1 = "Package1";
    protected static final String PATH_TO_FILE2 = "Path/To/File2";
    protected static final String PATH_TO_FILE1 = "Path/To/File";
    private static final String FILE1 = StringUtils.substringAfterLast((String)"Path/To/File", (String)"/");
    protected static final String LOW = "Low";
    protected static final String NORMAL = "NORMAL";
    protected static final String HIGH = "high";
    protected static final String TEST_TASK5 = "Test Task5";
    protected static final String TEST_TASK4 = "Test Task4";
    protected static final String TEST_TASK3 = "Test Task3";
    protected static final String TEST_TASK2 = "Test Task2";
    protected static final String TEST_TASK1 = "Test Task1";
    protected static final int LINE_NUMBER = 100;
    private static final String WRONG_PACKAGE_NAME = "Wrong package name.";
    private static final String WRONG_TOOLTIP_CREATED = "Wrong tooltip created.";
    private static final String WRONG_NUMBER_OF_FILES = "Wrong number of files.";
    private static final String WRONG_NUMBER_OF_PACKAGES = "Wrong number of packages.";
    private static final String WRONG_NUMBER_OF_MODULES = "Wrong number of modules.";
    private static final String WRONG_NUMBER_OF_ANNOTATIONS = "Wrong number of annotations.";
    private static final String WRONG_MODULE_ERROR = "Wrong module error.";
    private static final String WRONG_ANNOTATION_KEY = "Wrong annotation key.";
    private static final String WRONG_MODULE_NAME = "Wrong module name.";
    private static final String WRONG_FILE_SHORT_NAME = "Wrong file short name";
    private static final String WRONG_FILE_NAME = "Wrong file name.";
    private static final String MODULE_NOT_IN_PROJECT = "Module not in project.";
    private static final String PACKAGE_NOT_IN_MODULE = "Package not in module.";
    private AbstractAnnotation firstAnnotation;

    private JavaProject createOriginal() {
        JavaProject project = new JavaProject();
        this.addAnnotation(project, 100, TEST_TASK1, Priority.HIGH, PATH_TO_FILE1, PACKAGE1, MODULE1);
        this.addAnnotation(project, 100, TEST_TASK2, Priority.LOW, PATH_TO_FILE1, PACKAGE1, MODULE1);
        this.addAnnotation(project, 100, TEST_TASK3, Priority.LOW, PATH_TO_FILE2, PACKAGE1, MODULE1);
        this.addAnnotation(project, 100, TEST_TASK4, Priority.NORMAL, PATH_TO_FILE1, PACKAGE2, MODULE1);
        this.addAnnotation(project, 100, TEST_TASK5, Priority.NORMAL, PATH_TO_FILE1, PACKAGE1, MODULE2);
        this.verifyProject(project);
        this.verifyFirstAnnotation(project);
        return project;
    }

    @SuppressWarnings(value={"UI"})
    protected <T> T deserialize(String fileName) {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(fileName);
            return (T)this.readFrom(new ObjectInputStream(inputStream));
        }
        catch (IOException exception) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readFrom(ObjectInputStream objectStream) throws IOException, ClassNotFoundException {
        try {
            Object object = objectStream.readObject();
            return object;
        }
        finally {
            objectStream.close();
        }
    }

    protected void verifyFirstAnnotation(JavaProject project) {
        FileAnnotation annotation = project.getAnnotation(this.firstAnnotation.getKey());
        Assert.assertEquals((String)WRONG_ANNOTATION_KEY, (Object)this.firstAnnotation, (Object)annotation);
        annotation = project.getAnnotation(String.valueOf(this.firstAnnotation.getKey()));
        Assert.assertEquals((String)WRONG_ANNOTATION_KEY, (Object)this.firstAnnotation, (Object)annotation);
        this.verifyFirstAnnotation(this.firstAnnotation);
        JavaProject dummyProject = new JavaProject();
        this.addAnnotation(dummyProject, 100, TEST_TASK1, Priority.HIGH, PATH_TO_FILE1, PACKAGE1, MODULE1);
        FileAnnotation other = (FileAnnotation)dummyProject.getAnnotations().iterator().next();
        Assert.assertEquals((String)"Wrong equals evaluation.", (Object)annotation, (Object)other);
    }

    protected abstract void verifyFirstAnnotation(AbstractAnnotation var1);

    private void addAnnotation(JavaProject project, int line, String message, Priority priority, String fileName, String packageName, String moduleName) {
        AbstractAnnotation task = this.createAnnotation(line, message, priority, fileName, packageName, moduleName);
        if (this.firstAnnotation == null) {
            this.firstAnnotation = task;
        }
        project.addAnnotation((FileAnnotation)task);
    }

    protected abstract AbstractAnnotation createAnnotation(int var1, String var2, Priority var3, String var4, String var5, String var6);

    @Test
    public void testObjectIsSameAfterDeserialization() throws Exception {
        JavaProject original = this.createOriginal();
        ByteArrayOutputStream outputStream = this.serialize(original);
        JavaProject copy = this.deserialize(outputStream.toByteArray());
        this.verifyProject(copy);
        this.verifyFirstAnnotation(copy);
    }

    protected abstract XmlFile createXmlFile(File var1);

    private JavaProject deserialize(byte[] objectData) throws IOException, ClassNotFoundException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(objectData);
        ObjectInputStream objectStream = new ObjectInputStream(inputStream);
        Object readObject = objectStream.readObject();
        return (JavaProject)readObject;
    }

    private ByteArrayOutputStream serialize(JavaProject original) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectStream = new ObjectOutputStream(outputStream);
        objectStream.writeObject(original);
        objectStream.close();
        return outputStream;
    }

    protected void verifyProject(JavaProject project) {
        Assert.assertTrue((boolean)project.hasAnnotations());
        this.checkSummary(project);
        Assert.assertTrue((String)MODULE_NOT_IN_PROJECT, (boolean)project.containsModule(MODULE1));
        Assert.assertTrue((String)MODULE_NOT_IN_PROJECT, (boolean)project.containsModule(MODULE2));
        this.checkFirstModule(project.getModule(MODULE1));
        this.checkSecondModule(project.getModule(MODULE2));
        for (FileAnnotation annotation : project.getModule(MODULE2).getAnnotations()) {
            Assert.assertEquals((String)"Wrong primary line number.", (int)100, (int)annotation.getPrimaryLineNumber());
            Collection lineRanges = annotation.getLineRanges();
            Assert.assertEquals((String)"Wrong number of ranges.", (int)1, (int)lineRanges.size());
            LineRange range = (LineRange)lineRanges.iterator().next();
            Assert.assertEquals((String)"Wrong start line number.", (int)100, (int)range.getStart());
            Assert.assertEquals((String)"Wrong end line number.", (int)100, (int)range.getEnd());
            Assert.assertEquals((String)"Wrong package prefix.", (String)Messages.PackageDetail_header(), (String)project.getModule(MODULE2).getPackageCategoryName());
            Assert.assertSame((Object)annotation, (Object)project.getAnnotation(annotation.getKey()));
            Assert.assertSame((Object)annotation, (Object)project.getAnnotation(Long.toString(annotation.getKey())));
        }
    }

    private void checkSecondModule(MavenModule module) {
        Assert.assertNull((String)WRONG_MODULE_ERROR, (Object)module.getError());
        Assert.assertEquals((String)WRONG_MODULE_NAME, (String)MODULE2, (String)module.getName());
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)1, (int)module.getNumberOfAnnotations());
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)1, (int)module.getAnnotations().size());
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)0, (int)module.getNumberOfAnnotations(Priority.HIGH));
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)0, (int)module.getAnnotations(Priority.HIGH).size());
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)1, (int)module.getNumberOfAnnotations(Priority.NORMAL));
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)1, (int)module.getAnnotations(Priority.NORMAL).size());
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)0, (int)module.getNumberOfAnnotations(Priority.LOW));
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)0, (int)module.getAnnotations(Priority.LOW).size());
        Assert.assertEquals((String)WRONG_TOOLTIP_CREATED, (String)"Normal:1", (String)module.getToolTip());
        Assert.assertEquals((String)WRONG_NUMBER_OF_PACKAGES, (int)1, (int)module.getPackages().size());
        Assert.assertEquals((String)WRONG_NUMBER_OF_FILES, (int)1, (int)module.getFiles().size());
        Assert.assertTrue((String)PACKAGE_NOT_IN_MODULE, (boolean)module.containsPackage(PACKAGE1));
        Assert.assertFalse((String)"Package in module.", (boolean)module.containsPackage(PACKAGE2));
        JavaPackage javaPackage = module.getPackage(PACKAGE1);
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)1, (int)javaPackage.getNumberOfAnnotations());
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)0, (int)javaPackage.getNumberOfAnnotations(Priority.HIGH));
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)1, (int)javaPackage.getNumberOfAnnotations(Priority.NORMAL));
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)0, (int)javaPackage.getNumberOfAnnotations(Priority.LOW));
        WorkspaceFile file = module.getFile(PATH_TO_FILE1);
        Assert.assertEquals((String)WRONG_FILE_NAME, (String)PATH_TO_FILE1, (String)file.getName());
        Assert.assertEquals((String)WRONG_FILE_SHORT_NAME, (String)FILE1, (String)file.getShortName());
        Assert.assertTrue((String)WRONG_NUMBER_OF_ANNOTATIONS, (boolean)file.hasAnnotations());
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)1, (int)file.getNumberOfAnnotations());
        Assert.assertFalse((String)WRONG_NUMBER_OF_ANNOTATIONS, (boolean)file.hasAnnotations(HIGH));
        Assert.assertFalse((String)WRONG_NUMBER_OF_ANNOTATIONS, (boolean)file.hasAnnotations(Priority.HIGH));
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)0, (int)file.getNumberOfAnnotations(Priority.HIGH));
        Assert.assertTrue((String)WRONG_NUMBER_OF_ANNOTATIONS, (boolean)file.hasAnnotations(NORMAL));
        Assert.assertTrue((String)WRONG_NUMBER_OF_ANNOTATIONS, (boolean)file.hasAnnotations(Priority.NORMAL));
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)1, (int)file.getNumberOfAnnotations(Priority.NORMAL));
        Assert.assertFalse((String)WRONG_NUMBER_OF_ANNOTATIONS, (boolean)file.hasAnnotations(LOW));
        Assert.assertFalse((String)WRONG_NUMBER_OF_ANNOTATIONS, (boolean)file.hasAnnotations(Priority.LOW));
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)0, (int)file.getNumberOfAnnotations(Priority.LOW));
        Assert.assertEquals((String)WRONG_TOOLTIP_CREATED, (String)"Normal:1", (String)file.getToolTip());
    }

    private void checkFirstModule(MavenModule module) {
        Assert.assertEquals((String)WRONG_MODULE_NAME, (String)MODULE1, (String)module.getName());
        Assert.assertNull((String)WRONG_MODULE_ERROR, (Object)module.getError());
        Assert.assertEquals((String)WRONG_NUMBER_OF_MODULES, (int)0, (int)module.getModules().size());
        Assert.assertEquals((String)WRONG_NUMBER_OF_PACKAGES, (int)2, (int)module.getPackages().size());
        Assert.assertEquals((String)WRONG_NUMBER_OF_FILES, (int)2, (int)module.getFiles().size());
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)4, (int)module.getNumberOfAnnotations());
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)1, (int)module.getNumberOfAnnotations(Priority.HIGH));
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)1, (int)module.getNumberOfAnnotations(Priority.NORMAL));
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)2, (int)module.getNumberOfAnnotations(Priority.LOW));
        Assert.assertTrue((String)PACKAGE_NOT_IN_MODULE, (boolean)module.containsPackage(PACKAGE1));
        JavaPackage javaPackage = module.getPackage(PACKAGE1);
        Assert.assertEquals((String)WRONG_PACKAGE_NAME, (String)PACKAGE1, (String)javaPackage.getName());
        Assert.assertEquals((String)WRONG_NUMBER_OF_MODULES, (int)0, (int)javaPackage.getModules().size());
        Assert.assertEquals((String)WRONG_NUMBER_OF_PACKAGES, (int)0, (int)javaPackage.getPackages().size());
        Assert.assertEquals((String)WRONG_NUMBER_OF_FILES, (int)2, (int)javaPackage.getFiles().size());
        Assert.assertEquals((String)WRONG_NUMBER_OF_FILES, (int)2, (int)javaPackage.getFiles().size());
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)3, (int)javaPackage.getNumberOfAnnotations());
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)1, (int)javaPackage.getNumberOfAnnotations(Priority.HIGH));
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)0, (int)javaPackage.getNumberOfAnnotations(Priority.NORMAL));
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)2, (int)javaPackage.getNumberOfAnnotations(Priority.LOW));
        Assert.assertTrue((String)"File not in package.", (boolean)javaPackage.containsFile(PATH_TO_FILE1));
        WorkspaceFile file = javaPackage.getFile(PATH_TO_FILE1);
        Assert.assertEquals((String)WRONG_FILE_NAME, (String)PATH_TO_FILE1, (String)file.getName());
        Assert.assertEquals((String)WRONG_FILE_SHORT_NAME, (String)FILE1, (String)file.getShortName());
        Assert.assertEquals((String)WRONG_NUMBER_OF_MODULES, (int)0, (int)file.getModules().size());
        Assert.assertEquals((String)WRONG_NUMBER_OF_PACKAGES, (int)0, (int)file.getPackages().size());
        Assert.assertEquals((String)WRONG_NUMBER_OF_FILES, (int)0, (int)file.getFiles().size());
        javaPackage = module.getPackage(PACKAGE2);
        Assert.assertEquals((String)WRONG_PACKAGE_NAME, (String)PACKAGE2, (String)javaPackage.getName());
        Assert.assertEquals((String)WRONG_NUMBER_OF_FILES, (int)1, (int)javaPackage.getFiles().size());
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)1, (int)javaPackage.getNumberOfAnnotations());
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)0, (int)javaPackage.getNumberOfAnnotations(Priority.HIGH));
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)1, (int)javaPackage.getNumberOfAnnotations(Priority.NORMAL));
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)0, (int)javaPackage.getNumberOfAnnotations(Priority.LOW));
    }

    private void checkSummary(JavaProject project) {
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)5, (int)project.getNumberOfAnnotations());
        Assert.assertTrue((String)WRONG_NUMBER_OF_ANNOTATIONS, (boolean)project.hasAnnotations(Priority.HIGH));
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)1, (int)project.getNumberOfAnnotations(Priority.HIGH));
        Assert.assertTrue((String)WRONG_NUMBER_OF_ANNOTATIONS, (boolean)project.hasAnnotations(Priority.NORMAL));
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)2, (int)project.getNumberOfAnnotations(Priority.NORMAL));
        Assert.assertTrue((String)WRONG_NUMBER_OF_ANNOTATIONS, (boolean)project.hasAnnotations(Priority.LOW));
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)2, (int)project.getNumberOfAnnotations(Priority.LOW));
        Assert.assertEquals((String)WRONG_TOOLTIP_CREATED, (String)"High:1 - Normal:2 - Low:2", (String)project.getToolTip());
        Assert.assertEquals((String)WRONG_NUMBER_OF_MODULES, (int)2, (int)project.getModules().size());
        Assert.assertEquals((String)WRONG_NUMBER_OF_PACKAGES, (int)2, (int)project.getPackages().size());
        Assert.assertEquals((String)WRONG_NUMBER_OF_FILES, (int)2, (int)project.getFiles().size());
    }

    protected void ensureSerialization(String fileName) {
        try {
            File file = new File(this.getClass().getResource(fileName).toURI());
            XmlFile xmlFile = this.createXmlFile(file);
            Object deserialized = xmlFile.read();
            FileAnnotation[] files = (FileAnnotation[])deserialized;
            JavaProject project = new JavaProject();
            project.addAnnotations(files);
            this.verifyProject(project);
        }
        catch (URISyntaxException exception) {
            throw new IllegalArgumentException(exception);
        }
        catch (IOException exception) {
            throw new IllegalArgumentException(exception);
        }
    }
}

