/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.utils.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.hudsonci.utils.io.Closer;

public class FileBeheader {
    public static File chop(File original, long tailToKeep) {
        if (!original.isFile()) {
            throw new IllegalArgumentException("Cannot behead directories: " + original);
        }
        File truncatedFile = new File(original.getParentFile(), original.getName() + ".truncated");
        FileChannel whole = null;
        FileChannel chopped = null;
        try {
            whole = new FileInputStream(original).getChannel();
            chopped = new FileOutputStream(truncatedFile).getChannel();
            long originalLength = original.length();
            long lengthToKeep = originalLength < tailToKeep ? 0L : originalLength - tailToKeep;
            whole.transferTo(lengthToKeep, originalLength, chopped);
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException("Cannot behead file due to inconsistent internal state.", e);
            }
            catch (Throwable throwable) {
                Closer.close(whole, chopped);
                throw throwable;
            }
        }
        Closer.close(whole, chopped);
        boolean isRenamed = truncatedFile.renameTo(original);
        if (!isRenamed) {
            IllegalStateException renameException = new IllegalStateException("Cannot replace original with chopped file to: " + original);
            String originalPath = original.getAbsolutePath();
            boolean isDeleted = original.delete();
            if (isDeleted) {
                boolean isRenamedAgain = truncatedFile.renameTo(new File(originalPath));
                if (!isRenamedAgain) {
                    throw renameException;
                }
            } else {
                throw renameException;
            }
        }
        return original;
    }
}

