/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.utils.id;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import org.hudsonci.utils.id.ID;

@XStreamAlias(value="longid")
public class LongID
implements ID {
    @XStreamAsAttribute
    private final long value;

    public LongID(long value) {
        this.value = value;
    }

    public LongID(Number value) {
        this.value = (Long)Preconditions.checkNotNull((Object)value.longValue());
    }

    public LongID(String value) {
        this(Long.parseLong(value));
    }

    public long getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LongID)) {
            return false;
        }
        LongID that = (LongID)obj;
        return this.value == that.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

