/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.model.AbstractBuild;
import hudson.model.User;
import hudson.scm.ChangeLogParser;
import hudson.scm.ChangeLogSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.digester.Digester;
import org.jvnet.hudson.test.ExtractChangeLogSet;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.xml.sax.SAXException;

public class ExtractChangeLogParser
extends ChangeLogParser {
    public ExtractChangeLogSet parse(AbstractBuild build, File changeLogFile) throws IOException, SAXException {
        if (changeLogFile.exists()) {
            FileInputStream fis = new FileInputStream(changeLogFile);
            ExtractChangeLogSet logSet = this.parse(build, fis);
            fis.close();
            return logSet;
        }
        return new ExtractChangeLogSet(build, new ArrayList<ExtractChangeLogEntry>());
    }

    public ExtractChangeLogSet parse(AbstractBuild build, InputStream changeLogStream) throws IOException, SAXException {
        ArrayList<ExtractChangeLogEntry> changeLog = new ArrayList<ExtractChangeLogEntry>();
        Digester digester = new Digester();
        digester.setClassLoader(ExtractChangeLogSet.class.getClassLoader());
        digester.push(changeLog);
        digester.addObjectCreate("*/extractChanges/entry", ExtractChangeLogEntry.class);
        digester.addBeanPropertySetter("*/extractChanges/entry/zipFile");
        digester.addObjectCreate("*/extractChanges/entry/file", FileInZip.class);
        digester.addBeanPropertySetter("*/extractChanges/entry/file/fileName");
        digester.addSetNext("*/extractChanges/entry/file", "addFile");
        digester.addSetNext("*/extractChanges/entry", "add");
        digester.parse(changeLogStream);
        return new ExtractChangeLogSet(build, changeLog);
    }

    @ExportedBean(defaultVisibility=999)
    public static class FileInZip {
        private String fileName = "";

        public FileInZip() {
        }

        public FileInZip(String fileName) {
            this.fileName = fileName;
        }

        @Exported
        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @ExportedBean(defaultVisibility=999)
    public static class ExtractChangeLogEntry
    extends ChangeLogSet.Entry {
        private List<FileInZip> files = new ArrayList<FileInZip>();
        private String zipFile;

        public ExtractChangeLogEntry() {
        }

        public ExtractChangeLogEntry(String zipFile) {
            this.zipFile = zipFile;
        }

        public void setZipFile(String zipFile) {
            this.zipFile = zipFile;
        }

        @Exported
        public String getZipFile() {
            return this.zipFile;
        }

        public void setParent(ChangeLogSet parent) {
            super.setParent(parent);
        }

        public Collection<String> getAffectedPaths() {
            ArrayList<String> paths = new ArrayList<String>(this.files.size());
            for (FileInZip file : this.files) {
                paths.add(file.getFileName());
            }
            return paths;
        }

        @Exported
        public User getAuthor() {
            return User.get((String)"testuser");
        }

        @Exported
        public String getMsg() {
            return "Extracted from " + this.zipFile;
        }

        public void addFile(FileInZip fileName) {
            this.files.add(fileName);
        }

        public void addFiles(Collection<FileInZip> fileNames) {
            this.files.addAll(fileNames);
        }

        public String getUser() {
            return this.getAuthor().getDisplayName();
        }
    }
}

